/**
 Copyright (c) 2021. All rights reserved.

 This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

 */

function values(obj) {
    return Object.keys(obj).map(function(e) {
        return obj[e]
    });
}

var primaryColors = {
    blue: '#3D6C9E',
    green: '#498500',
    red: '#D61F21',
    orange: '#FF9E49',
    purple: '#991C71',
    yellow: '#EEC511',
};

function lightenColor(color, percent) {
    var num = parseInt(color.replace("#", ""), 16),
        amt = Math.round(2.55 * percent),
        R = (num >> 16) + amt,
        B = (num >> 8 & 0x00FF) + amt,
        G = (num & 0x0000FF) + amt;
    return "#" + (0x1000000 + (R < 255 ? R < 1 ? 0 : R : 255) * 0x10000 + (B < 255 ? B < 1 ? 0 : B : 255) * 0x100 + (G < 255 ? G < 1 ? 0 : G : 255)).toString(16).slice(1);
}

function generateColorPalette(data, colors) {
    var colorPalette = colors;
    if (data.length > colors.length) {
        var newColorPalette = colorPalette;
        colorPalette.forEach((color) => {
            var lighterColor = lightenColor(color, 10);
            newColorPalette.push(lighterColor);
        });
        generateColorPalette(data, newColorPalette);
    }
    return colorPalette;
}

function commitsTimelineSummary(response, id) {
    var dates = response.data.data.dates;
    var commitsEachDay = response.data.data.commitsEachDay;
    var dom = document.getElementById(id);
    var chart = echarts.init(dom);
    var option = {
        tooltip: {
            trigger: 'axis',
            position: function (pt) {
                return [pt[0], '10%'];
            }
        },
        toolbox: {
            right: '10%',
            feature: {
                dataZoom: {
                    yAxisIndex: 'none',
                    title: {
                        zoom: 'Zoom',
                        back: 'Back'
                    }
                },
                restore: {
                    title: "Restore"
                }
            }
        },
        xAxis: {
            type: 'category',
            boundaryGap: false,
            data: dates
        },
        yAxis: {
            type: 'value',
            boundaryGap: [0, '100%']
        },
        dataZoom: [{
            type: 'inside',
            start: 0,
            end: 100
        }, {
            start: 0,
            end: 10,
            handleIcon: 'M10.7,11.9v-1.3H9.3v1.3c-4.9,0.3-8.8,4.4-8.8,9.4c0,5,3.9,9.1,8.8,9.4v1.3h1.3v-1.3c4.9-0.3,8.8-4.4,8.8-9.4C19.5,16.3,15.6,12.2,10.7,11.9z M13.3,24.4H6.7V23h6.6V24.4z M13.3,19.6H6.7v-1.4h6.6V19.6z',
            handleSize: '80%',
            handleStyle: {
                color: '#fff',
                shadowBlur: 3,
                shadowColor: 'rgba(0, 0, 0, 0.6)',
                shadowOffsetX: 2,
                shadowOffsetY: 2
            }
        }],
        series: [{
            name: 'Commits',
            type: 'line',
            smooth: true,
            symbol: 'none',
            sampling: 'average',
            itemStyle: {
                color: primaryColors.blue
            },
            areaStyle: {
                color: primaryColors.blue
            },
            data: commitsEachDay
        }]
    };
    if (option && typeof option === "object") {
        chart.setOption(option, true);
    }
}

function contributionsSummary(response, id) {
    var authors = response.data.data.authors;
    var committers = response.data.data.committers;
    var people = response.data.data.people;
    var dom = document.getElementById(id);
    var chart = echarts.init(dom);
    var option = {
        tooltip: {
            trigger: 'item',
            formatter: "{a} <br/>{b}: {c} Commit(s) ({d}%)"
        },
        legend: {
            orient: 'vertical',
            type: 'scroll',
            x: 'left',
            data: people
        },
        series: [{
            name: 'Authors',
            type: 'pie',
            selectedMode: 'single',
            radius: [0, '45%'],
            label: {
                normal: {
                    show: false
                }
            },
            data: authors
        },
            {
                name: 'Committers',
                type: 'pie',
                radius: ['60%', '82.5%'],
                label: {
                    normal: {
                        show: false
                    }
                },
                data: committers
            }
        ],
        color: generateColorPalette(people, values(primaryColors)),
    };
    if (option && typeof option === "object") {
        chart.setOption(option, true);
    }
}

function tagsTimelineSummary(response, id) {
    var dates = response.data.data.dates;
    var tagsEachDay = response.data.data.tagsEachDay;
    var tagNamesEachDay = response.data.data.tagNamesEachDay;
    var dom = document.getElementById(id);
    var chart = echarts.init(dom);
    var option = {
        tooltip: {
            trigger: 'axis',
            position: function (pt) {
                return [pt[0], '10%'];
            },
            formatter: '{b}<br/>{a0}: {c0}<br/>{a1}: {c1}',
            confine: true
        },
        toolbox: {
            right: '10%',
            feature: {
                dataZoom: {
                    yAxisIndex: 'none',
                    title: {
                        zoom: 'Zoom',
                        back: 'Back'
                    }
                },
                restore: {
                    title: "Restore"
                }
            }
        },
        xAxis: {
            type: 'category',
            boundaryGap: false,
            data: dates
        },
        yAxis: {
            type: 'value',
            boundaryGap: [0, '100%']
        },
        dataZoom: [{
            type: 'inside',
            start: 0,
            end: 100
        }, {
            start: 0,
            end: 10,
            handleIcon: 'M10.7,11.9v-1.3H9.3v1.3c-4.9,0.3-8.8,4.4-8.8,9.4c0,5,3.9,9.1,8.8,9.4v1.3h1.3v-1.3c4.9-0.3,8.8-4.4,8.8-9.4C19.5,16.3,15.6,12.2,10.7,11.9z M13.3,24.4H6.7V23h6.6V24.4z M13.3,19.6H6.7v-1.4h6.6V19.6z',
            handleSize: '80%',
            handleStyle: {
                color: '#fff',
                shadowBlur: 3,
                shadowColor: 'rgba(0, 0, 0, 0.6)',
                shadowOffsetX: 2,
                shadowOffsetY: 2
            }
        }],
        series: [{
            name: 'Tags Count',
            type: 'line',
            smooth: true,
            symbol: 'none',
            sampling: 'average',
            itemStyle: {
                color: primaryColors.blue
            },
            areaStyle: {
                color: primaryColors.blue
            },
            data: tagsEachDay
        },
            {
                name: 'Tags List',
                type: 'line',
                symbol: 'none',
                itemStyle: {
                    opacity: 0
                },
                data: tagNamesEachDay
            }
        ]
    };
    if (option && typeof option === "object") {
        chart.setOption(option, true);
    }
}
