# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

from gitlab.Client import Client
import sys

client = Client()
if "input_pipeline_id" in locals() and input_pipeline_id:
    locals()["pipeline_id"] = input_pipeline_id
elif "commit_id" in locals() and not commit_id or not ref:
    raise Exception("Either CommitId and Ref or PipelineId must be provided")
response = client.gitlab_pipeline_status(locals())
if response is not None:
    for key, value in response.items():
        locals()[key] = value

task.setStatusLine(
    "Pipeline #{0}: {1}".format(response["pipeline_id"], response["status"])
)
pipeline_web_url = response["web_url"]

if response["status"] == "failed" or response["status"] == "canceled":
    pipeline_status = response["status"]
    task.schedule("gitlab/task-fail.py")
elif response["status"] == "success":
    print "Pipeline #{0}: {1}".format(response["pipeline_id"], "Success!")
    pipeline_status = response["status"]
else:
    task.schedule("gitlab/pipeline-wait.py")
