# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.

from gitlab.Client import Client

client = Client()
response = client.gitlab_runjob_status(locals())
currentRetryCount = currentRetryCount + 1   
if response is not None:
    for key, value in response.items():
        locals()[key] = value
if response["status"] == "running":
    if currentRetryCount < maxRetries:
        task.schedule("gitlab/runJob-wait.py", retryWait)
        task.setStatusLine(
            "Status: {0}".format(response["status"])
        )
    else:
        raise Exception("Status retry check exhausted after {0} retries".format(maxRetries))
    
elif response["status"]=="success":
    task.setStatusLine(
        "Status: {0}".format(response["status"])
    )
    jobStatus= response["status"].title()
    print("[View job]({0})".format(response["web_url"]))
else:
    raise Exception("Job ended with status: {0} due to {1}".format(response["status"],response.get("failure_reason", "unknown reason")))
    
    