import sys
from org.apache.http.client import ClientProtocolException

params = { 'url': configuration.url, 'username' : configuration.username, 'password': configuration.password,
           'proxyHost': configuration.proxyHost, 'proxyPort': configuration.proxyPort,
           'proxyUsername': configuration.proxyUsername, 'proxyPassword': configuration.proxyPassword}

response = None
try:
    response = HttpRequest(params).get('/rest/api/2/application-properties', contentType = 'application/json')
except ClientProtocolException:
    raise Exception("URL is not valid")

# Jira api returns 403 in case you are authenticated but not enough permissions
if response.status != 403 and response.status != 200:
    reason = "Unknown"
    if response.status == 400:
        reason = "Bad request"
    elif response.status == 401:
        reason = "Unauthorized"
    raise Exception("HTTP response code %s, reason %s" % (response.status, reason))