#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
from octopus.OctopusClient import OctopusClient

client = OctopusClient(server, server['apiKey'])

retryAttempt = retryAttempt + 1
complete = False

if retryAttempt <= server['retryCount']:
    '''Waits for an Octopus deployment to finish and returns the result (success or failure)'''
    print("Waiting for deployment to succeed...")
    taskDetailsUrl = "%s/details" % (taskUrl)
    task_details = client.httpGetUrl(taskUrl)
    complete = task_details["IsCompleted"] if "IsCompleted" in task_details.keys() else task_details["Task"]["IsCompleted"]
    if not complete:
        task.schedule("octopus/wait-for-deploy.py",server['retryWaitingTime'])
    else:
        # Accomodate both sides of a breaking API change
        finishedSuccessfully = task_details["FinishedSuccessfully"] if "FinishedSuccessfully" in task_details.keys() else task_details["Task"]["FinishedSuccessfully"]
        if finishedSuccessfully:
            task_details = client.httpGetUrl(taskDetailsUrl)
            for item in task_details['ActivityLogs'][0]['Children']:
                print "Step: [%s], Status: [%s], Started: [%s], Ended: [%s]\n" % (item["Name"], item["Status"], item["Started"], item["Ended"])
        else:
            # Accomodate both sides of a breaking API change
            sys.exit("Deployment failed, errors: [%s]" % task_details["ErrorMessage"] if "ErrorMessage" in task_details.keys() else task_details["Task"]["ErrorMessage"])
else:
    print("Failed to determine deploy status and max number of retries reached")
    sys.exit(1)