#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#
from xlropenshift.client.openshift_client import OpenShiftClient
import kubernetes.client
import time

client = OpenShiftClient(server)

# OpenShift dynamic client
test_dyn_client = client.dyn_client()

meta = kubernetes.client.V1ObjectMeta()
meta.name = buildConfName

# Returning a ResourceInstance object
v1_buildConfigs = test_dyn_client.resources.get(api_version='build.openshift.io/v1', kind='BuildConfig')

# BuildConfig instantiation
response = v1_buildConfigs.subresources["instantiate"].create(
                name=buildConfName,
                namespace=project,
                body={
                    "kind": "BuildRequest",
                    "apiVersion": "build.openshift.io/v1",
                    "metadata": {
                        "name": buildConfName,
                    },
                },
            )

print "Started {}".format(response.metadata.name)
buildId=response.metadata.name

while True:
    response = test_dyn_client.resources.get(api_version='build.openshift.io/v1', kind='Build').get(name=response.metadata.name, namespace=project)
    status = response.status.phase
    print "Status : {}".format(status)
    if status == "Complete":
        break
    if status is not None and status in ["Error", "Failed", "Cancelled"]:
        raise RuntimeError("Build not successful status is : " + status)
    time.sleep(5)