from openshift.api_client import APIClient

client = APIClient(task.pythonScript.getProperty("host"), task.pythonScript.getProperty('ocPath'))

response = client.execute_openshift_command(
    command="{} dc/{}".format(task.pythonScript.getProperty('command'), task.pythonScript.getProperty('deploymentConfName')),
    cmd_params=task.pythonScript.getProperty('cmdParams'), process_exit = False).stdout

if response != 'deploymentconfig "{}" rolled out'.format(task.pythonScript.getProperty('deploymentConfName')):
    raise RuntimeError("Triggering {} deployment failed.".format(task.pythonScript.getProperty('deploymentConfName')))

output = client.execute_openshift_command(
    command="rollout status dc/{}".format(task.pythonScript.getProperty('deploymentConfName')), process_exit = False).stdout

if not output.endswith("successfully rolled out"):
    raise RuntimeError("Deployment {} failed.".format(task.pythonScript.getProperty('deploymentConfName')))