#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#


from xlropenshift.client.openshift_client import OpenShiftClient
import kubernetes.client
import openshift.client
import time

client = OpenShiftClient(server)
test_oapi_client = client.oapi_client()

meta = kubernetes.client.V1ObjectMeta()
meta.name = buildConfName

cause = openshift.client.V1BuildTriggerCause(message="{}-{}".format(project, buildConfName))

body = openshift.client.V1BuildRequest(metadata=meta, triggered_by=[cause])
response = test_oapi_client.create_namespaced_build_config_instantiate(namespace=project, name=buildConfName, body=body)

print "Started {}".format(response.metadata.name)
buildId=response.metadata.name

while True:
    response = test_oapi_client.read_namespaced_build(name=response.metadata.name, namespace=project)
    status = response.status.phase
    print "Status : {}".format(status)
    if status == "Complete":
        break
    if status is not None and status in ["Error", "Failed", "Cancelled"]:
        raise RuntimeError("Build not successful status is : " + status)
    time.sleep(5)
