# coding: utf-8

"""
    OpenShift API (with Kubernetes)

    OpenShift provides builds, application lifecycle, image content management, and administrative policy on top of Kubernetes. The API allows consistent management of those objects.  All API operations are authenticated via an Authorization bearer token that is provided for service accounts as a generated secret (in JWT form) or via the native OAuth endpoint located at /oauth/authorize. Core infrastructure components may use client certificates that require no authentication.  All API operations return a 'resourceVersion' string that represents the version of the object in the underlying storage. The standard LIST operation performs a snapshot read of the underlying objects, returning a resourceVersion representing a consistent version of the listed objects. The WATCH operation allows all updates to a set of objects after the provided resourceVersion to be observed by a client. By listing and beginning a watch from the returned resourceVersion, clients may observe a consistent view of the state of one or more objects. Note that WATCH always returns the update after the provided resourceVersion. Watch may be extended a limited time in the past - using etcd 2 the watch window is 1000 events (which on a large cluster may only be a few tens of seconds) so clients must explicitly handle the \"watch to old error\" by re-listing.  Objects are divided into two rough categories - those that have a lifecycle and must reflect the state of the cluster, and those that have no state. Objects with lifecycle typically have three main sections:  * 'metadata' common to all objects * a 'spec' that represents the desired state * a 'status' that represents how much of the desired state is reflected on   the cluster at the current time  Objects that have no state have 'metadata' but may lack a 'spec' or 'status' section.  Objects are divided into those that are namespace scoped (only exist inside of a namespace) and those that are cluster scoped (exist outside of a namespace). A namespace scoped resource will be deleted when the namespace is deleted and cannot be created if the namespace has not yet been created or is in the process of deletion. Cluster scoped resources are typically only accessible to admins - resources like nodes, persistent volumes, and cluster policy.  All objects have a schema that is a combination of the 'kind' and 'apiVersion' fields. This schema is additive only for any given version - no backwards incompatible changes are allowed without incrementing the apiVersion. The server will return and accept a number of standard responses that share a common schema - for instance, the common error type is 'metav1.Status' (described below) and will be returned on any error from the API server.  The API is available in multiple serialization formats - the default is JSON (Accept: application/json and Content-Type: application/json) but clients may also use YAML (application/yaml) or the native Protobuf schema (application/vnd.kubernetes.protobuf). Note that the format of the WATCH API call is slightly different - for JSON it returns newline delimited objects while for Protobuf it returns length-delimited frames (4 bytes in network-order) that contain a 'versioned.Watch' Protobuf object.  See the OpenShift documentation at https://docs.openshift.org for more information. 

    OpenAPI spec version: latest
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class V1RepositoryImportStatus(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'additional_tags': 'list[str]',
        'images': 'list[V1ImageImportStatus]',
        'status': 'V1Status'
    }

    attribute_map = {
        'additional_tags': 'additionalTags',
        'images': 'images',
        'status': 'status'
    }

    def __init__(self, additional_tags=None, images=None, status=None):
        """
        V1RepositoryImportStatus - a model defined in Swagger
        """

        self._additional_tags = None
        self._images = None
        self._status = None
        self.discriminator = None

        if additional_tags is not None:
          self.additional_tags = additional_tags
        if images is not None:
          self.images = images
        if status is not None:
          self.status = status

    @property
    def additional_tags(self):
        """
        Gets the additional_tags of this V1RepositoryImportStatus.
        AdditionalTags are tags that exist in the repository but were not imported because a maximum limit of automatic imports was applied.

        :return: The additional_tags of this V1RepositoryImportStatus.
        :rtype: list[str]
        """
        return self._additional_tags

    @additional_tags.setter
    def additional_tags(self, additional_tags):
        """
        Sets the additional_tags of this V1RepositoryImportStatus.
        AdditionalTags are tags that exist in the repository but were not imported because a maximum limit of automatic imports was applied.

        :param additional_tags: The additional_tags of this V1RepositoryImportStatus.
        :type: list[str]
        """

        self._additional_tags = additional_tags

    @property
    def images(self):
        """
        Gets the images of this V1RepositoryImportStatus.
        Images is a list of images successfully retrieved by the import of the repository.

        :return: The images of this V1RepositoryImportStatus.
        :rtype: list[V1ImageImportStatus]
        """
        return self._images

    @images.setter
    def images(self, images):
        """
        Sets the images of this V1RepositoryImportStatus.
        Images is a list of images successfully retrieved by the import of the repository.

        :param images: The images of this V1RepositoryImportStatus.
        :type: list[V1ImageImportStatus]
        """

        self._images = images

    @property
    def status(self):
        """
        Gets the status of this V1RepositoryImportStatus.
        Status reflects whether any failure occurred during import

        :return: The status of this V1RepositoryImportStatus.
        :rtype: V1Status
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this V1RepositoryImportStatus.
        Status reflects whether any failure occurred during import

        :param status: The status of this V1RepositoryImportStatus.
        :type: V1Status
        """

        self._status = status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, V1RepositoryImportStatus):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
