#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
from opsgenie_xlr import connect_to_opsgenie
from opsgenie.swagger_client import AlertApi
from opsgenie.swagger_client.rest import ApiException

connect_to_opsgenie(configuration)

try:
    response = AlertApi().list_alerts(
            limit=5,
            query='status: open',
            order='desc',
            sort='createdAt')
    if not response.data:
        sys.exit(1)

except ApiException as err:
    print("```Unable to Connect to OpsGenie: Exception %s\n```" % err)
    sys.exit(1)

