/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.relationships.graph;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.xlrelease.api.v1.ReleaseApi;
import com.xebialabs.xlrelease.api.v1.TemplateApi;
import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.relationships.graph.Edge;
import com.xebialabs.xlrelease.relationships.graph.Graph;
import com.xebialabs.xlrelease.relationships.graph.Node;
import com.xebialabs.xlrelease.relationships.graph.RiskData;
import com.xebialabs.xlrelease.relationships.graph.TaskData;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.risk.api.v1.RiskApi;
import com.xebialabs.xlrelease.risk.configuration.RiskGlobalThresholds;
import com.xebialabs.xlrelease.risk.domain.Risk;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipsResolver {
    private static final Logger logger = LoggerFactory.getLogger(RelationshipsResolver.class);
    private ReleaseApi releaseApi;
    private TemplateApi templateApi;
    private RiskApi riskApi;
    private ReleaseRepository releaseRepository;

    public RelationshipsResolver(ReleaseApi releaseApi, TemplateApi templateApi, RiskApi riskApi, ReleaseRepository releaseRepository) {
        this.releaseApi = releaseApi;
        this.templateApi = templateApi;
        this.riskApi = riskApi;
        this.releaseRepository = releaseRepository;
    }

    public Graph resolveGraph(String releaseId) {
        Graph graph = new Graph();
        this.analyseGraph(releaseId, graph, 0);
        return graph;
    }

    private void analyseGraph(String releaseId, Graph graph, int nextNodeLevel) {
        Release release;
        if (!graph.isNodeProcessed(releaseId) && (release = this.readRelease(releaseId)) != null) {
            ArrayList<TaskData> failedTasks = new ArrayList<TaskData>();
            ArrayList<TaskData> activeTasks = new ArrayList<TaskData>();
            RiskData risk = this.getRisk(release);
            Node node = graph.addNode(releaseId, release.getTitle(), release.getStatus().name(), this.getPhaseTitle(release), nextNodeLevel, failedTasks, activeTasks, risk);
            for (Phase phase : release.getPhases()) {
                this.processTasks(phase.getTasks(), graph, node, failedTasks, activeTasks);
            }
            List<Release> childReleasesFromApi = this.findByRootRelease(releaseId);
            for (Release childRelease : childReleasesFromApi) {
                Task task = release.getTask(childRelease.getStartedFromTaskId());
                if (task == null || this.isTaskType(task, "xlrelease.CreateReleaseTask") || graph.isNodeProcessed(childRelease.getId())) continue;
                graph.addEdge(releaseId, childRelease.getId(), task.getTitle(), Edge.Kind.CREATE);
                this.analyseGraph(childRelease.getId(), graph, node.getLevel() + 1);
            }
        }
    }

    private List<Release> findByRootRelease(String rootReleaseId) {
        Page queryPage = new Page(0L, 100L, Integer.valueOf(0), false);
        return this.releaseRepository.search(new ReleaseSearchByParams(queryPage, null, ReleaseStatus.values(), null, rootReleaseId, false));
    }

    private RiskData getRisk(Release release) {
        if (!release.isDefunct() && !release.isTemplate()) {
            try {
                Risk risk = this.riskApi.getRisk(release);
                RiskGlobalThresholds riskGlobalThresholds = this.riskApi.getRiskGlobalThresholds();
                Integer score = risk.getScore();
                int atRiskFrom = riskGlobalThresholds.getAtRiskFrom();
                int attentionNeededFrom = riskGlobalThresholds.getAttentionNeededFrom();
                RiskData.RiskStatus riskStatus = RiskData.RiskStatus.ON_TRACK;
                if (score >= attentionNeededFrom && score < atRiskFrom) {
                    riskStatus = RiskData.RiskStatus.ATTENTION_NEEDED;
                } else if (score >= atRiskFrom) {
                    riskStatus = RiskData.RiskStatus.AT_RISK;
                }
                return new RiskData(riskStatus, score);
            }
            catch (NotFoundException risk) {
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    private String getPhaseTitle(Release release) {
        Phase currentPhase = release.getCurrentPhase();
        if (currentPhase != null) {
            return currentPhase.getTitle();
        }
        return null;
    }

    private Release readRelease(String releaseId) {
        try {
            try {
                return this.templateApi.getTemplate(releaseId);
            }
            catch (NotFoundException a) {
                try {
                    return this.releaseApi.getArchivedRelease(releaseId);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        catch (PermissionDeniedException ex) {
            logger.trace("Ignoring release with no permissions", (Throwable)ex);
        }
        return null;
    }

    private void processTasks(List<Task> tasks, Graph graph, Node node, List<TaskData> failedTasks, List<TaskData> activeTasks) {
        for (Task task : tasks) {
            block9: {
                block10: {
                    CreateReleaseTask createReleaseTask;
                    block11: {
                        block8: {
                            if (!this.isTaskType(task, "xlrelease.ParallelGroup") && !this.isTaskType(task, "xlrelease.SequentialGroup")) break block8;
                            this.processTasks(task.getAllTasks().subList(1, task.getAllTasks().size()), graph, node, failedTasks, activeTasks);
                            break block9;
                        }
                        if (!this.isTaskType(task, "xlrelease.CreateReleaseTask")) break block10;
                        createReleaseTask = (CreateReleaseTask)task;
                        if (createReleaseTask.getNewReleaseTitle() == null || createReleaseTask.getTemplateId() == null) break block9;
                        if (!createReleaseTask.getStatus().equals((Object)TaskStatus.COMPLETED)) break block11;
                        graph.addEdge(node.getName(), createReleaseTask.getCreatedReleaseId(), createReleaseTask.getTitle(), Edge.Kind.CREATE);
                        this.analyseGraph(createReleaseTask.getCreatedReleaseId(), graph, node.getLevel() + 1);
                        break block9;
                    }
                    if (createReleaseTask.getStatus().equals((Object)TaskStatus.SKIPPED) || createReleaseTask.getStatus().equals((Object)TaskStatus.SKIPPED_IN_ADVANCE)) break block9;
                    graph.addEdge(node.getName(), createReleaseTask.getTemplateId(), createReleaseTask.getTitle(), Edge.Kind.CREATE);
                    this.analyseGraph(createReleaseTask.getTemplateId(), graph, node.getLevel() + 1);
                    break block9;
                }
                if (this.isTaskType(task, "xlrelease.GateTask") && ((GateTask)task).getDependencies().size() > 0) {
                    GateTask gateTask = (GateTask)task;
                    for (Dependency dep : gateTask.getDependencies()) {
                        String targetId;
                        if (dep.hasResolvedTarget()) {
                            if (dep.getTarget() != null && dep.getTarget().getId() != null) {
                                targetId = dep.getTarget().getId();
                            } else {
                                if (dep.getTargetId() == null) continue;
                                targetId = dep.getTargetId();
                            }
                        } else {
                            if (dep.getTargetId() == null) continue;
                            targetId = dep.getTargetId();
                        }
                        String resolvedTargetId = this.resolveGateReleaseId(targetId);
                        graph.addEdge(node.getName(), resolvedTargetId, task.getTitle(), Edge.Kind.GATE);
                        this.analyseGraph(resolvedTargetId, graph, node.getLevel() + 1);
                    }
                }
            }
            if (task.isFailed()) {
                failedTasks.add(new TaskData(task.getId(), task.getTitle()));
            }
            if (!task.isActive()) continue;
            activeTasks.add(new TaskData(task.getId(), task.getTitle()));
        }
    }

    private String resolveGateReleaseId(String targetId) {
        ArrayList<String> result = new ArrayList<String>();
        for (String p : targetId.split("/")) {
            if (p.startsWith("Phase")) break;
            result.add(p);
        }
        return result.stream().collect(Collectors.joining("/"));
    }

    private boolean isTaskType(Task task, String taskType) {
        return task.getTaskType().equals((Object)Type.valueOf((String)taskType));
    }
}

