'use strict';

angular.module('xlrelease').factory('Timeline', ['Planner', function (Planner) {

    return {
        init: function init(currentRelease, releases, currentReleaseTree) {
            Planner.setRelease(currentRelease);
            Planner.setReleaseTree(currentReleaseTree);
            var plan = Planner.makePlan();
            var releasePlan = plan.plan;
            var expectedEndDate = plan.plannedEndDate;
            var startDate = plan.elements[0].displayStartDate;
            var endDate = releasePlan.displayEndDate;
            var phaseDetails = _.chain(plan.elements).filter(function (item) {
                return item.type === 'xlrelease.Phase';
            }).map(function (phase) {
                return {
                    title: phase.text,
                    startDate: moment(phase.start_date),
                    endDate: moment(phase.end_date),
                    color: phase.planItem.color
                };
            }).value();
            return {
                release: currentRelease,
                startDate: startDate,
                expectedEndDate: expectedEndDate,
                endDate: endDate,
                phases: phaseDetails
            };
        }
    };
}]);