'use strict';

(function () {

    var XLDeployTileControllerInject = ['$scope', 'ReleasesService', 'DeployitService', 'XlrTileHelper'];
    var XLDeployTileController = function XLDeployTileController($scope, ReleasesService, DeployitService, XlrTileHelper) {
        var vm = this;

        if ($scope.xlrDashboard) {
            // summary page
            vm.release = $scope.xlrDashboard.release;
        } else {
            // details page
            vm.release = $scope.xlrTileDetailsCtrl.release;
        }

        DeployitService.getAllServers().then(function (response) {
            var servers = response.data;
            vm.allXLDeployTasks = getAllXLDeployTasks(vm.release, servers);
            vm.counts = XlrTileHelper.countTasksByStatus(vm.allXLDeployTasks);
            vm.totalCount = vm.allXLDeployTasks.length;
            vm.gridOptions = getGridOptions(vm.allXLDeployTasks);

            vm.chartOptions = XlrTileHelper.getChartOptions({
                label: 'Deployment',
                total: vm.totalCount
            });
        });

        function getAllXLDeployTasks(release, xldServers) {
            return _(ReleasesService.getLeafTasks(release)).filter({ type: 'xlrelease.DeployitTask' }).map(function (task) {
                return {
                    taskName: task.title,
                    taskId: task.deployitTaskId,
                    taskPackage: task.deploymentPackage,
                    taskEnvironment: task.environment,
                    taskStatus: task.status,
                    taskStatusCategory: XlrTileHelper.getCategoryByTaskStatus(task.status),
                    xldUrl: getXldUrl(xldServers, task.server)
                };
            }).value();
        }

        function getGridOptions(allXLDeployTasks) {
            var columnDefs = [{
                displayName: "Task",
                field: "taskName",
                cellTemplate: "static/5.0.1/include/XLDeployTile/grid/deployment-name-cell-template.html",
                filterHeaderTemplate: "<div data-ng-include=\"'partials/releases/grid/templates/name-filter-template.html'\"></div>",
                enableColumnMenu: false,
                width: '30%'
            }, {
                displayName: "Package",
                field: "taskPackage",
                enableColumnMenu: false,
                width: '20%'
            }, {
                displayName: "Environment",
                field: "taskEnvironment",
                enableColumnMenu: false,
                width: '20%'
            }, {
                displayName: "Status",
                field: "taskStatusCategory",
                cellTemplate: "static/5.0.1/include/XLDeployTile/grid/deployment-status-cell-template.html",
                filterHeaderTemplate: "<div data-ng-include=\"'partials/releases/grid/templates/name-filter-template.html'\"></div>",
                enableColumnMenu: false,
                width: '10%'
            }, {
                displayName: "XL Deploy task ID",
                field: "taskId",
                cellTemplate: "static/5.0.1/include/XLDeployTile/grid/deployment-task-id-cell-template.html",
                filterHeaderTemplate: "<div data-ng-include=\"'partials/releases/grid/templates/name-filter-template.html'\"></div>",
                enableColumnMenu: false,
                width: '20%'
            }];
            return XlrTileHelper.getGridOptions(allXLDeployTasks, columnDefs);
        }

        function getXldUrl(xldServers, serverId) {
            var server = _.find(xldServers, { 'id': serverId });
            return server ? server.url : null;
        }
    };
    XLDeployTileController.$inject = XLDeployTileControllerInject;

    angular.module('xlrelease').controller('summary.XLDeployTileController', XLDeployTileController);
})();