/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.CiUtils;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.ImapServer;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.ImapTokenHelper;
import com.xebialabs.xlrelease.plugins.remotecompletion.util.FunctionalUtils;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import jakarta.mail.Folder;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.angus.mail.imap.IMAPStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailStore {
    private static final Logger logger = LoggerFactory.getLogger(EmailStore.class);
    private static final int MAIL_TIMEOUT = 30000;
    private static final String MAIL_IMAP_CONNECTION_TIMEOUT = "mail.imap.connectiontimeout";
    private static final String MAIL_IMAP_TIMEOUT = "mail.imap.timeout";
    private Optional<Store> store = Optional.empty();
    protected ImapServer imapServer;
    private Optional<Folder> inbox = Optional.empty();
    private ImapTokenHelper imapTokenHelper;

    public EmailStore(ImapServer imapServer, ImapTokenHelper imapTokenHelper) throws Exception {
        this.imapServer = imapServer;
        this.imapTokenHelper = imapTokenHelper;
        this.initializeStore(imapServer, "imap");
        this.initializeInbox(false);
    }

    public ImapServer getImapServer() {
        return this.imapServer;
    }

    public void close() {
        logger.debug("Closing the IMAPStore");
        this.store.ifPresent(store -> {
            try {
                store.close();
            }
            catch (Exception e) {
                logger.warn("Encountered an exception while closing IMAPStore", (Throwable)e);
            }
        });
    }

    public EmailStore(ConfigurationRepository configurationRepository, ImapTokenHelper imapTokenHelper) throws Exception {
        this.imapTokenHelper = imapTokenHelper;
        Optional<Object> localImapServer = Optional.empty();
        try {
            localImapServer = CiUtils.getImapServer(configurationRepository);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.imapServer = localImapServer.orElse((Object)new ImapServer());
        if (!this.imapServer.isValid()) {
            logger.debug("Could not find a valid mail server configuration. Skipping mail synchronisation.");
            return;
        }
        logger.debug("Mail server configuration found. Started mail server synchronisation. {}", (Object)this.imapServer);
        this.initializeStore(this.imapServer, "imap");
        this.initializeInbox(true);
    }

    public boolean isWhitelistEnabled() {
        return this.imapServer.isWhitelistEnabled();
    }

    public List<String> getWhitelist() {
        return this.imapServer.getWhitelist();
    }

    public boolean hasSortCapability() {
        try {
            return ((IMAPStore)this.store.get()).hasCapability("SORT*");
        }
        catch (MessagingException e) {
            logger.error("Encountered an exception while checking sort capability : " + FunctionalUtils.getNestedExceptionsMessagesFunction.apply(e));
            return false;
        }
    }

    public String getFromAddress() {
        return this.imapServer.getFromAddress();
    }

    private void initializeStore(ImapServer server, String protocol) throws Exception {
        Properties props = this.getImapProperties(server);
        Session session = Session.getInstance((Properties)props);
        this.store = Optional.ofNullable(session.getStore(protocol));
    }

    private void initializeInbox(boolean decryptPassword) throws Exception {
        if (this.imapServer.isUseOAuth2()) {
            this.imapTokenHelper.refreshTokenIfRequired(this.imapServer, decryptPassword);
            String accessToken = PasswordEncrypter.getInstance().decrypt(this.imapServer.getAccessToken());
            this.store.get().connect(this.imapServer.getHost(), this.imapServer.getPort(), this.imapServer.getFromAddress(), accessToken);
        } else {
            String password = decryptPassword ? PasswordEncrypter.getInstance().decrypt(this.imapServer.getPassword()) : this.imapServer.getPassword();
            this.store.get().connect(this.imapServer.getHost(), this.imapServer.getPort(), this.imapServer.getUsername(), password);
        }
        Folder inbox = this.store.get().getFolder("INBOX");
        inbox.open(2);
        this.inbox = Optional.of(inbox);
    }

    public Optional<Folder> getInbox() throws Exception {
        if (!this.inbox.isPresent() && this.store.isPresent()) {
            this.initializeInbox(true);
        }
        this.inbox.ifPresent(folder -> {
            try {
                if (!folder.isOpen()) {
                    folder.open(2);
                }
            }
            catch (MessagingException e) {
                logger.error("Unable to open inbox for read/write mode", (Throwable)e);
            }
        });
        return this.inbox;
    }

    private Properties getImapProperties(ImapServer imapServer) {
        Properties props = System.getProperties();
        String mailTimeout = String.valueOf(30000);
        if (!props.containsKey(MAIL_IMAP_CONNECTION_TIMEOUT)) {
            props.setProperty(MAIL_IMAP_CONNECTION_TIMEOUT, mailTimeout);
        }
        if (!props.containsKey(MAIL_IMAP_TIMEOUT)) {
            props.setProperty(MAIL_IMAP_TIMEOUT, mailTimeout);
        }
        if (imapServer.isTls()) {
            props.setProperty("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.imap.socketFactory.fallback", "false");
        } else {
            props.setProperty("mail.imap.socketFactory.class", "javax.net.SocketFactory");
        }
        if (imapServer.isUseOAuth2()) {
            props.put("mail.imap.auth.mechanisms", "XOAUTH2");
        } else {
            props.remove("mail.imap.auth.mechanisms");
        }
        props.setProperty("mail.imap.ssl.checkserveridentity", "false");
        logger.trace("Connection properties passed to javamail: {}", props.entrySet().stream().filter(e -> e.getKey().toString().startsWith("mail")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return props;
    }
}

