/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.ImapServer;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.EmailAttachment;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.EmailStore;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.ImapTokenHelper;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.MessageReader;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.MessageValidator;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.ReleaseLicenseService;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.TaskAction;
import com.xebialabs.xlrelease.plugins.remotecompletion.util.FunctionalUtils;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.service.UploadService;
import com.xebialabs.xlrelease.user.User;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.angus.mail.imap.IMAPFolder;
import org.eclipse.angus.mail.imap.SortTerm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Option;

@Service
public class RemoteCompletionEmailProcessorService {
    private static final Logger logger = LoggerFactory.getLogger(RemoteCompletionEmailProcessorService.class);
    private MessageReader messageReader;
    private ReleaseActorService releaseActorService;
    private EmailStore emailStore;
    private MessageValidator messageValidator;
    private ConfigurationRepository configurationRepository;
    private ImapTokenHelper imapTokenHelper;
    private UploadService uploadService;
    private ReleaseLicenseService releaseLicenseService;

    public RemoteCompletionEmailProcessorService() {
    }

    @Autowired
    public RemoteCompletionEmailProcessorService(MessageReader messageReader, ReleaseActorService releaseActorService, MessageValidator messageValidator, ConfigurationRepository configurationRepository, ImapTokenHelper imapTokenHelper, UploadService uploadService, ReleaseLicenseService releaseLicenseService) {
        this.messageReader = messageReader;
        this.releaseActorService = releaseActorService;
        this.messageValidator = messageValidator;
        this.configurationRepository = configurationRepository;
        this.imapTokenHelper = imapTokenHelper;
        this.uploadService = uploadService;
        this.releaseLicenseService = releaseLicenseService;
    }

    public void run() {
        this.processMessages(true);
    }

    public void testMailServer(ImapServer server) throws Exception {
        this.emailStore = new EmailStore(server, new ImapTokenHelper());
        this.messageValidator = new MessageValidator();
        this.processMessages(false).ifPresent(FunctionalUtils.nestedExceptionsWithThrowableConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Exception> processMessages(boolean processMails) {
        Optional<Exception> exception = Optional.empty();
        try {
            Optional<Folder> optionalInbox;
            if (processMails) {
                this.emailStore = new EmailStore(this.configurationRepository, this.imapTokenHelper);
            }
            if ((optionalInbox = this.emailStore.getInbox()).isPresent()) {
                Message[] messages;
                Folder inbox = optionalInbox.get();
                if (this.emailStore.hasSortCapability()) {
                    logger.debug("SORT extension available, using server side sorting");
                    messages = ((IMAPFolder)inbox).getSortedMessages(new SortTerm[]{SortTerm.ARRIVAL});
                } else {
                    logger.debug("SORT extension NOT available, sorting locally");
                    messages = inbox.getMessages();
                    this.sortMessagesByReceivedDate(messages);
                }
                if (processMails) {
                    for (Message message : messages) {
                        this.process(message);
                    }
                }
                inbox.close(true);
            }
        }
        catch (Exception ex) {
            logger.error("Exception occurred while processing mail. Reason: {}", (Object)FunctionalUtils.getNestedExceptionsMessagesFunction.apply(ex));
            exception = Optional.of(ex);
        }
        finally {
            if (this.emailStore != null) {
                this.emailStore.close();
            }
        }
        return exception;
    }

    private void sortMessagesByReceivedDate(Message[] messages) {
        Arrays.sort(messages, (m1, m2) -> {
            try {
                return m1.getReceivedDate().compareTo(m2.getReceivedDate());
            }
            catch (Exception e) {
                return 0;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Message msg) throws MessagingException {
        String fromEmail = "[unknown]";
        try {
            fromEmail = this.messageValidator.verifyAndGetFromEmail(msg);
            this.messageValidator.verifyFromEmailIsNotSameAsImapFromAddress(fromEmail, this.emailStore.getFromAddress());
            logger.info("Processing email from {} for remote completion", (Object)fromEmail);
            this.messageValidator.verifyEmailIsWhitelisted(fromEmail, this.emailStore.getImapServer());
            this.messageValidator.verifyEmailSize(msg, fromEmail);
            String body = this.messageReader.getEmailBody(msg, fromEmail);
            String taskId = this.messageValidator.verifyAndGetTaskId(body, fromEmail);
            TaskAction action = this.messageValidator.verifyAndGetAction(body, fromEmail);
            this.messageValidator.verifySignature(body, fromEmail, action, taskId);
            logger.info("About to look for email attachments from {} for remote completion", (Object)fromEmail);
            List<EmailAttachment> attachments = this.messageReader.getEmailAttachments(msg, fromEmail);
            logger.info("Attachment List size is  {} ", (Object)attachments.size());
            this.messageValidator.verifySignature(body, fromEmail, action, taskId);
            logger.info("About to handle attachments");
            for (EmailAttachment att : attachments) {
                logger.info("Handling attachment {}", (Object)att);
                this.handleAttachment(taskId, att);
            }
            String theFromEmail = fromEmail;
            Optional.ofNullable(this.messageValidator.verifyAndGetTask(taskId, fromEmail)).ifPresent(task -> {
                String assignee = this.messageValidator.verifyAndGetTaskAssignees(theFromEmail, (Task)task).get(this.messageValidator.correctCase(theFromEmail));
                this.releaseLicenseService.validateAssigneeLicense(assignee, theFromEmail, (Task)task);
                this.handleAction(action, taskId, task.getTitle(), assignee, theFromEmail);
            });
        }
        catch (Exception ex) {
            logger.error("Error while processing email from {}. Reason: {}", (Object)fromEmail, (Object)FunctionalUtils.getNestedExceptionsMessagesFunction.apply(ex));
        }
        finally {
            logger.info("Deleting email from {}", (Object)fromEmail);
            msg.setFlag(Flags.Flag.DELETED, true);
        }
    }

    private void handleAttachment(String taskId, EmailAttachment attachment) {
        logger.debug("in handleAttachment");
        logger.debug("Handling email attachment: taskId: {}, fileName: {}", (Object)taskId, (Object)attachment.getFileName());
        try {
            logger.debug("About to attempt upload, taskId=" + taskId + " fileName=" + attachment.getFileName() + ", bytes=" + new String(attachment.getBytes()));
            this.uploadService.addAttachment(taskId, attachment.getFileName(), attachment.getBytes());
        }
        catch (Exception handleAttachmentException) {
            logger.error("Error while processing attachment for task: {}, fileName {}. Exception: {}", new Object[]{taskId, attachment.getFileName(), handleAttachmentException});
        }
    }

    private void handleAction(TaskAction action, String taskId, String taskName, String assignee, String assigneeEmail) {
        logger.debug("Handling email action: {} taskId: {} taskName: {}, assignee: {}, assigneeEmail: {}", new Object[]{action, taskId, taskName, assignee, assigneeEmail});
        switch (action) {
            case COMPLETE: {
                logger.info("Completing task by remote completion: {}", (Object)taskName);
                this.releaseActorService.markTaskAsDone(TaskStatus.COMPLETED, taskId, String.format("Completed by user: %s", assignee), User.SYSTEM);
                break;
            }
            case FAIL: {
                logger.info("Failing task by remote completion: {}", (Object)taskName);
                this.releaseActorService.failTask(taskId, String.format("Failed by user: %s", assignee), User.SYSTEM, Option.empty());
                break;
            }
            default: {
                logger.error("Email command not understood: {}", (Object)action);
            }
        }
    }
}

