/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.google.common.hash.Hashing;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.CiUtils;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.ImapServer;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SignatureService {
    private final ConfigurationRepository configurationRepository;

    @Autowired
    public SignatureService(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    public Optional<String> createSignature(String fromEmail, String action, String taskId) {
        return CiUtils.getImapServer(this.configurationRepository).map(ImapServer::getSecret).filter(s -> !s.isEmpty()).map(arg_0 -> ((PasswordEncrypter)PasswordEncrypter.getInstance()).decrypt(arg_0)).map(secret -> this.generateHash(fromEmail + action + taskId + secret));
    }

    private String generateHash(CharSequence input) {
        return Hashing.sha512().hashString(input, StandardCharsets.UTF_8).toString();
    }
}

