/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.remotecompletion.email;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.imap.SortTerm;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.CiUtils;
import com.xebialabs.xlrelease.plugins.remotecompletion.ci.ImapServer;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.EmailAddressService;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.HandleFeedbackService;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.MessageReader;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.SignatureService;
import com.xebialabs.xlrelease.plugins.remotecompletion.email.TaskAction;
import com.xebialabs.xlrelease.plugins.remotecompletion.util.FunctionalUtils;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.user.User;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteCompletionEmailProcessorService
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RemoteCompletionEmailProcessorService.class);
    private static final int BYTES_PER_MEGABYTE = 1000000;
    private static final int SIZE_LIMIT_MEGABYTE = 1;
    private static final int MAIL_TIMEOUT = 30000;
    private static final Pattern actionPattern = Pattern.compile(".*ACTION:\\s*(COMPLETE|FAIL).*", 32);
    private static final Pattern signaturePattern = Pattern.compile(".*SIGNATURE:\\s*([a-zA-Z0-9/]+).*", 32);
    private static final Pattern taskidPattern = Pattern.compile(".*TASK_ID:\\s*([a-zA-Z0-9/]+).*", 32);
    private static final String MAIL_IMAP_CONNECTIONTIMEOUT = "mail.imap.connectiontimeout";
    private static final String MAIL_IMAP_TIMEOUT = "mail.imap.timeout";
    private ConfigurationRepository configurationRepository;
    private EmailAddressService emailAddressService;
    private HandleFeedbackService handleFeedbackService;
    private MessageReader messageReader;
    private ReleaseActorService releaseActorService;
    private SignatureService signatureService;
    private TaskService taskService;

    public RemoteCompletionEmailProcessorService() {
    }

    @Autowired
    public RemoteCompletionEmailProcessorService(ConfigurationRepository configurationRepository, EmailAddressService emailAddressService, HandleFeedbackService handleFeedbackService, MessageReader messageReader, ReleaseActorService releaseActorService, SignatureService signatureService, TaskService taskService) {
        this.configurationRepository = configurationRepository;
        this.emailAddressService = emailAddressService;
        this.handleFeedbackService = handleFeedbackService;
        this.messageReader = messageReader;
        this.releaseActorService = releaseActorService;
        this.signatureService = signatureService;
        this.taskService = taskService;
    }

    @Override
    public void run() {
        ImapServer server = CiUtils.getImapServer(this.configurationRepository).orElse(new ImapServer());
        if (!server.isValid()) {
            logger.debug("Could not find a valid mail server configuration. Skipping mail synchronisation.");
            return;
        }
        logger.debug("Mail server configuration found. Started mail server synchronisation. {}", (Object)server);
        this.connectToMailServer(server, true, true);
    }

    public void testMailServer(ImapServer server) {
        this.connectToMailServer(server, false, false).ifPresent(FunctionalUtils.nestedExceptionsWithThrowableConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Exception> connectToMailServer(ImapServer server, boolean processMails, boolean decryptPassword) {
        Exception exception = null;
        IMAPStore store = null;
        IMAPFolder inbox = null;
        try {
            Message[] messages;
            store = this.initializeStore(server, "imap");
            inbox = this.connectToStoreAndOpenFolder(server, (Store)store, decryptPassword);
            if (store.hasCapability("SORT*")) {
                logger.debug("SORT extension available, using server side sorting");
                messages = inbox.getSortedMessages(new SortTerm[]{SortTerm.ARRIVAL});
            } else {
                logger.debug("SORT extension NOT available, sorting locally");
                messages = inbox.getMessages();
                this.sortMessagesByRecievedDate(messages);
            }
            if (processMails) {
                for (Message msg : messages) {
                    this.processMail(msg, server);
                }
            }
        }
        catch (Exception ex) {
            logger.error("Exception occurred while processing mail. Reason: {}", (Object)FunctionalUtils.getNestedExceptionsMessagesFunction.apply(ex));
            exception = ex;
        }
        finally {
            try {
                if (inbox != null) {
                    inbox.close(true);
                }
                if (store != null) {
                    store.close();
                }
            }
            catch (Exception ex) {
                logger.error("Exception occurred while closing mail resources. Reason: {}", (Object)FunctionalUtils.getNestedExceptionsMessagesFunction.apply(ex));
            }
        }
        return Optional.ofNullable(exception);
    }

    private IMAPStore initializeStore(ImapServer server, String protocol) throws NoSuchProviderException {
        Properties props = this.getImapProperties(server);
        Session session = Session.getInstance((Properties)props);
        return (IMAPStore)session.getStore(protocol);
    }

    private IMAPFolder connectToStoreAndOpenFolder(ImapServer server, Store store, boolean decryptPassword) throws MessagingException {
        String password = decryptPassword ? PasswordEncrypter.getInstance().decrypt(server.getPassword()) : server.getPassword();
        store.connect(server.getHost(), server.getPort(), server.getUsername(), password);
        IMAPFolder inbox = (IMAPFolder)store.getFolder("INBOX");
        inbox.open(2);
        return inbox;
    }

    private Properties getImapProperties(ImapServer imapServer) {
        Properties props = System.getProperties();
        String mailTimeout = String.valueOf(30000);
        if (!props.containsKey(MAIL_IMAP_CONNECTIONTIMEOUT)) {
            props.setProperty(MAIL_IMAP_CONNECTIONTIMEOUT, mailTimeout);
        }
        if (!props.containsKey(MAIL_IMAP_TIMEOUT)) {
            props.setProperty(MAIL_IMAP_TIMEOUT, mailTimeout);
        }
        if (imapServer.isTls()) {
            props.setProperty("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.imap.socketFactory.fallback", "false");
        } else {
            props.setProperty("mail.imap.socketFactory.class", "javax.net.SocketFactory");
        }
        logger.trace("Connection properties passed to javamail: {}", props.entrySet().stream().filter(e -> e.getKey().toString().startsWith("mail")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return props;
    }

    private void sortMessagesByRecievedDate(Message[] messages) {
        Arrays.sort(messages, (m1, m2) -> {
            try {
                return m1.getReceivedDate().compareTo(m2.getReceivedDate());
            }
            catch (Exception e) {
                return 0;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMail(Message msg, ImapServer imapServer) throws MessagingException {
        String fromEmail = "[unknown]";
        try {
            fromEmail = this.verifyAndGetFromEmail(msg);
            this.verifyFromEmailIsNotSameAsImapFromAddress(fromEmail, imapServer.getFromAddress());
            logger.info("Processing email from {} for remote completion", (Object)fromEmail);
            this.verifyEmailIsWhitelisted(fromEmail, imapServer);
            this.verifyEmailSize(msg, fromEmail);
            String body = this.messageReader.getEmailBody(msg, fromEmail);
            String taskId = this.verifyAndGetTaskId(body, fromEmail);
            TaskAction action = this.verifyAndGetAction(body, fromEmail);
            this.verifySignature(body, fromEmail, action, taskId);
            String theFromEmail = fromEmail;
            Optional.ofNullable(this.verifyAndGetTask(taskId, fromEmail)).ifPresent(task -> {
                String assignee = this.verifyAndGetTaskAssignees(theFromEmail, (Task)task).get(theFromEmail);
                this.handleAction(action, taskId, task.getTitle(), assignee, theFromEmail);
            });
        }
        catch (Exception ex) {
            logger.error("Error while processing email from {}. Reason: {}", (Object)fromEmail, (Object)FunctionalUtils.getNestedExceptionsMessagesFunction.apply(ex));
        }
        finally {
            logger.info("Deleting email from {}", (Object)fromEmail);
            msg.setFlag(Flags.Flag.DELETED, true);
        }
    }

    private String verifyAndGetFromEmail(Message message) throws MessagingException {
        if (message.getFrom() == null || message.getFrom().length < 1) {
            throw new IllegalStateException("From email is not set");
        }
        return ((InternetAddress)message.getFrom()[0]).getAddress();
    }

    private void verifyFromEmailIsNotSameAsImapFromAddress(String fromAddress, String imapFromAddress) {
        if (fromAddress.equalsIgnoreCase(imapFromAddress)) {
            throw new IllegalStateException(String.format("Ignoring email received from same email address as imap server account to avoid endless loops. Imap from address: %s", imapFromAddress));
        }
    }

    private void verifyEmailIsWhitelisted(String fromEmail, ImapServer imapServer) {
        if (!this.emailAddressService.emailIsWhitelisted(fromEmail, imapServer)) {
            throw new IllegalStateException(String.format("Ignoring email from: %s because it could not be matched to any domain set in the domain whitelist IMAP configuration.", fromEmail));
        }
    }

    private void verifyEmailSize(Message msg, String fromEmail) throws MessagingException {
        if (msg.getSize() > 1000000) {
            this.handleFeedbackService.sendMailAndThrowException(String.format("The size of the email sent exceeds the size limit of %s MB.", 1), fromEmail);
        }
    }

    private String verifyAndGetTaskId(String body, String fromEmail) {
        Matcher taskidMatcher = taskidPattern.matcher(body);
        if (!taskidMatcher.matches()) {
            this.handleFeedbackService.sendMailAndThrowException("'TASK_ID' not found or invalid.", fromEmail);
        }
        return taskidMatcher.group(1);
    }

    private TaskAction verifyAndGetAction(String body, String fromEmail) {
        Matcher actionMatcher = actionPattern.matcher(body);
        if (!actionMatcher.matches()) {
            this.handleFeedbackService.sendMailAndThrowException("'ACTION' not found or invalid.", fromEmail);
        }
        return TaskAction.valueOf(actionMatcher.group(1).toUpperCase());
    }

    private String verifyAndGetSignature(String body, String fromEmail) {
        Matcher signatureMatcher = signaturePattern.matcher(body);
        if (!signatureMatcher.matches()) {
            this.handleFeedbackService.sendMailAndThrowException("'SIGNATURE' not found or invalid.", fromEmail);
        }
        return signatureMatcher.group(1);
    }

    private void verifySignature(String body, String fromEmail, TaskAction action, String taskId) {
        String signature = this.verifyAndGetSignature(body, fromEmail);
        Optional<String> signatureCheck = this.signatureService.createSignature(fromEmail, action.name(), taskId);
        if (signatureCheck.isPresent()) {
            String str_signatureCheck = signatureCheck.get();
            logger.info("email ({})", (Object)fromEmail);
            logger.info("signature ({})", (Object)signature);
            logger.info("signatureCheck: ({})", (Object)str_signatureCheck);
            if (!str_signatureCheck.equals(signature)) {
                logger.info("signature not match");
                this.handleFeedbackService.sendMailAndThrowException("The email may have been modified. If email address is case sensitive, enable it from XL Release configurations.", fromEmail);
            }
        }
    }

    private Task verifyAndGetTask(String taskId, String fromEmail) {
        Task task = null;
        try {
            task = this.taskService.findById(taskId);
            if (!task.isInProgress()) {
                this.handleFeedbackService.sendMailAndThrowException(String.format("Task is no longer in progress. Task status is \u2018%s\u2019", task.getStatus()), fromEmail, Optional.of(task));
            }
        }
        catch (NotFoundException ex) {
            this.handleFeedbackService.sendMailAndThrowException("A task with the given ID was not found.", fromEmail);
        }
        return task;
    }

    private Map<String, String> verifyAndGetTaskAssignees(String fromEmail, Task task) {
        Map<String, String> assignees = this.emailAddressService.getEmailAddressesFromTask(task);
        if (!assignees.containsKey(this.signatureService.correctCase(fromEmail))) {
            this.handleFeedbackService.sendMailAndThrowException(String.format("Email address \u2018%s\u2019 does not match a user who is assigned to the task.", fromEmail), fromEmail, Optional.of(task));
        }
        return assignees;
    }

    private void handleAction(TaskAction action, String taskId, String taskName, String assignee, String assigneeEmail) {
        logger.debug("Handling email action: {} taskId: {} taskName: {}, assignee: {}, assigneeEmail: {}", new Object[]{action, taskId, taskName, assignee, assigneeEmail});
        switch (action) {
            case COMPLETE: {
                logger.info("Completing task by remote completion: {}", (Object)taskName);
                this.releaseActorService.markTaskAsDone(TaskStatus.COMPLETED, taskId, String.format("Completed by user: %s", assignee), User.SYSTEM);
                break;
            }
            case FAIL: {
                logger.info("Failing task by remote completion: {}", (Object)taskName);
                this.releaseActorService.failTask(taskId, String.format("Failed by user: %s", assignee), User.SYSTEM);
                break;
            }
            default: {
                logger.error("Email command not understood: {}", (Object)action);
            }
        }
    }
}

