/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.overthere;

import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.ssh.SshConnectionType;
import com.xebialabs.overthere.util.OverthereFileTranscoder;
import com.xebialabs.xlplatform.spring.SpringContextHolder;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.plugin.overthere.util.StorageOutputHandler;
import com.xebialabs.xlrelease.plugin.overthere.util.TaskExecutionLogHelper;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteScript {
    private static final String SCRIPT_NAME = "uploaded-script";
    private final ConnectionOptions options = new ConnectionOptions();
    private final String protocol;
    private final String remotePath;
    private final String script;
    private final String extension;
    private final TaskExecutionLogHelper taskExecutionLogHelper;
    private final StorageOutputHandler stdout;
    private final StorageOutputHandler stderr;
    private static Logger logger = LoggerFactory.getLogger(RemoteScript.class);

    public RemoteScript(ConfigurationItem remoteScript) {
        TaskExecutionLogService taskExecutionLogService = (TaskExecutionLogService)SpringContextHolder.getApplicationContext().getBean(TaskExecutionLogService.class);
        this.taskExecutionLogHelper = new TaskExecutionLogHelper((PythonScript)remoteScript, taskExecutionLogService);
        this.stdout = new StorageOutputHandler((PythonScript)remoteScript, this.taskExecutionLogHelper, false);
        this.stderr = new StorageOutputHandler((PythonScript)remoteScript, this.taskExecutionLogHelper, true);
        this.protocol = (String)remoteScript.getProperty("protocol");
        this.copyPropertiesToConnectionOptions(this.options, remoteScript);
        OperatingSystemFamily osFamily = (OperatingSystemFamily)this.options.get("os", (Object)OperatingSystemFamily.UNIX);
        String scriptContent = (String)remoteScript.getProperty("script");
        this.script = scriptContent != null ? scriptContent.replaceAll("\\R", osFamily.getLineSeparator()) : null;
        this.extension = osFamily.getScriptExtension();
        this.remotePath = (String)remoteScript.getProperty("remotePath");
    }

    protected void copyPropertiesToConnectionOptions(ConnectionOptions options, ConfigurationItem ci) {
        if (ci.hasProperty("sudo") && ((Boolean)ci.getProperty("sudo")).booleanValue()) {
            ci.setProperty("connectionType", (Object)SshConnectionType.SUDO);
            ci.setProperty("sudoUsername", (Object)"root");
        }
        for (PropertyDescriptor pd : ci.getType().getDescriptor().getPropertyDescriptors()) {
            if (pd.getCategory().equals("output")) continue;
            Object value = pd.get(ci);
            this.setConnectionOption(options, pd.getName(), value);
        }
    }

    private void setConnectionOption(ConnectionOptions options, String key, Object value) {
        if (key.equals("script") || key.equals("remotePath") || key.equals("scriptLocation")) {
            return;
        }
        if (value == null || value.toString().isEmpty()) {
            return;
        }
        if (key.equals("temporaryDirectoryPath")) {
            key = "tmp";
        } else if (key.equals("timeout")) {
            key = "winrmTimeout";
        }
        if (value instanceof Integer && (Integer)value == 0) {
            logger.debug("Activating workaround for DEPLOYITPB-4775: Integer with value of 0 not passed to Overthere.");
            return;
        }
        if (key.equals("jumpstation")) {
            ConfigurationItem item = (ConfigurationItem)value;
            ConnectionOptions jumpstationOptions = new ConnectionOptions();
            this.copyPropertiesToConnectionOptions(jumpstationOptions, item);
            options.set(key, (Object)jumpstationOptions);
        } else {
            options.set(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        try {
            int n;
            block12: {
                OverthereConnection connection = Overthere.getConnection((String)this.protocol, (ConnectionOptions)this.options);
                try {
                    if (this.remotePath != null && !this.remotePath.isEmpty()) {
                        connection.setWorkingDirectory(connection.getFile(this.remotePath));
                    }
                    OverthereFile targetFile = connection.getTempFile(SCRIPT_NAME, this.extension);
                    OverthereFileTranscoder.transcode((String)this.script, (String)"UTF-8", (OverthereFile)targetFile);
                    targetFile.setExecutable(true);
                    CmdLine scriptCommand = CmdLine.build((String[])new String[]{targetFile.getPath()});
                    n = connection.execute((OverthereExecutionOutputHandler)this.stdout, (OverthereExecutionOutputHandler)this.stderr, scriptCommand);
                    if (connection == null) break block12;
                }
                catch (Throwable targetFile) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable scriptCommand) {
                                targetFile.addSuppressed(scriptCommand);
                            }
                        }
                        throw targetFile;
                    }
                    catch (Exception e) {
                        StringWriter stacktrace = new StringWriter();
                        PrintWriter writer = new PrintWriter((Writer)stacktrace, true);
                        e.printStackTrace(writer);
                        this.stderr.handleLine(stacktrace.toString());
                        int n2 = 1;
                        return n2;
                    }
                }
                connection.close();
            }
            return n;
        }
        finally {
            this.taskExecutionLogHelper.flushBuffer();
        }
    }

    public String getStdout() {
        return this.stdout.getOutput();
    }

    public String getStderr() {
        return this.stderr.getOutput();
    }

    public ConnectionOptions getOptions() {
        return this.options;
    }

    public String getScript() {
        return this.script;
    }
}

