import json
from xlrelease.HttpRequest import HttpRequest

class SonarService(object):
    metrics = {}

    @staticmethod
    def get_sonar_metrics(sonar_server):

        if len(SonarService.metrics) < 1:
            http_request = HttpRequest(sonar_server)
            sonar_response = http_request.get('api/metrics/search?ps=500')
            json_data = json.loads(sonar_response.getResponse())

            for metric in json_data['metrics']:
                SonarService.metrics[metric['key']] = metric

        return SonarService.metrics

    @staticmethod
    def add_comment(comment):
        print "```"
        print comment
        print "```"

    @staticmethod
    def get_project_metrics(sonar_server, project_id):
        sonar_server_api_url = "/api/qualitygates/project_status?projectKey={}".format(project_id)
        http_request = HttpRequest(sonar_server)
        sonar_response = http_request.get(sonar_server_api_url)
        if not sonar_response.isSuccessful():
            raise Exception(
                "Failed to get Sonar Measures. Server returned response [%s] with status code [%s]" % (
                sonar_response.response, sonar_response.status
                ))
        return json.loads(sonar_response.getResponse())

    @staticmethod
    def get_analysis_date(sonar_server, project_id):
        sonar_server_api_url = "/api/components/show?component={}".format(project_id)
        http_request = HttpRequest(sonar_server)
        sonar_response = http_request.get(sonar_server_api_url)
        if not sonar_response.isSuccessful():
            raise Exception(
                "Failed to get analysis date. Server returned response [%s] with status code [%s]" % (
                    sonar_response.response, sonar_response.status
                ))
        return json.loads(sonar_response.getResponse())['component']['analysisDate']
