'use strict';

(function () {

    var SonarQueryTileViewController = function ($scope, SonarQueryService, XlrTileHelper) {
        var vm = this;

        vm.tileConfigurationIsPopulated = tileConfigurationIsPopulated;

        var tile;

        if ($scope.xlrDashboard) {
            // summary page
            vm.release = $scope.xlrDashboard.release;
            vm.tile = $scope.xlrTile.tile;
            if (vm.tile.properties == null) {
                vm.config = vm.tile.configurationProperties;
            } else {
                // new style since 7.0
                vm.config = vm.tile.properties;
            }
        }

        function tileConfigurationIsPopulated() {
            return !_.isEmpty(vm.config.sonarServer);
        }

        function load(config) {
            if (tileConfigurationIsPopulated()) {
                vm.loading = true;
                SonarQueryService.executeQuery(vm.tile.id, config).then(
                    function (response) {
                        var sonardata = response.data.data;
                        var lstData = [];
                        if (!sonardata.error) {
                            for (var metric = 0 ; metric < Object.getOwnPropertyNames(sonardata).length ; metric++)
                            {
                                var keyName = Object.getOwnPropertyNames(sonardata)[metric];
                                var finalKeyName = vm.config.metrics.value[keyName];
                                switch(keyName){
                                    case 'key' : lstData.push({ key : 'Project Key', value : sonardata[keyName], url : sonardata['sonarUrl'] + '/overview?id=' + sonardata['key']}); break;
                                    case 'version' : lstData.push({ key : 'Arfifact Version', value : sonardata[keyName]}); break;
                                    case 'name' : break;
                                    case 'id' : break;
                                    case 'sonarUrl' : break;
                                    case 'analysisDate': break;
                                    default : lstData.push({ key : finalKeyName, value : sonardata[keyName], url : sonardata['sonarUrl'] + '/component_measures/metric/' + keyName + '/list?id=' + sonardata['key']});

                                }

                            }
                            vm.result = {'lstData':lstData, 'analysisDate':sonardata['analysisDate']};
                        }else{
                            var error=''
                            if(sonardata.error instanceof Array){
                                for (var index = 0 ; index < sonardata.error.length ; index++){
                                    error=error+ sonardata.error[index]['msg'].replace("Component key","Resource")
                                }
                            }else{
                                error=sonardata.error
                            }
                            vm.result = {'lstData':lstData, 'error':error};
                        }

                        $scope.xlrTile.title = tile.title + " : " + sonardata['name'];
                    }
                ).finally(function () {
                    vm.loading = false;

                });
            }
        }


        function refresh() {
            load({params: {refresh: true}});
        }

        load();

        vm.refresh = refresh;
    };

    SonarQueryTileViewController.$inject = ['$scope', 'xlrelease.sonar.SonarQueryService', 'XlrTileHelper'];

    var SonarQueryService = function (Backend) {

        function executeQuery(tileId, config) {
            return Backend.get("tiles/" + tileId + "/data", config);
        }

        return {
            executeQuery: executeQuery
        };
    };

    SonarQueryService.$inject = ['Backend'];

    angular.module('xlrelease.sonar.tile', []);
    angular.module('xlrelease.sonar.tile').service('xlrelease.sonar.SonarQueryService', SonarQueryService);
    angular.module('xlrelease.sonar.tile').controller('sonar.SonarQueryTileViewController', SonarQueryTileViewController);
    angular.module('xlrelease').directive("addScrollBar",function(){return{
            link:function(scope,element){
                element.context.parentElement.style.overflowY = "auto";
            }}});

})();

