/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.patch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.InflaterInputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnDiffHunk;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatchFile;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPropertiesPatch;

public class SvnPatch {
    public static final File DEV_NULL = new File("/dev/null");
    private static final Transition[] TRANSITIONS = new Transition[]{new Transition("--- ", ParserState.START, IParserFunction.DIFF_MINUS), new Transition("+++ ", ParserState.MINUS_SEEN, IParserFunction.DIFF_PLUS), new Transition("diff --git", ParserState.START, IParserFunction.GIT_START), new Transition("--- a/", ParserState.GIT_DIFF_SEEN, IParserFunction.GIT_MINUS), new Transition("--- a/", ParserState.GIT_MODE_SEEN, IParserFunction.GIT_MINUS), new Transition("--- a/", ParserState.GIT_TREE_SEEN, IParserFunction.GIT_MINUS), new Transition("--- /dev/null", ParserState.GIT_MODE_SEEN, IParserFunction.GIT_MINUS), new Transition("--- /dev/null", ParserState.GIT_TREE_SEEN, IParserFunction.GIT_MINUS), new Transition("+++ b/", ParserState.GIT_MINUS_SEEN, IParserFunction.GIT_PLUS), new Transition("+++ /dev/null", ParserState.GIT_MINUS_SEEN, IParserFunction.GIT_PLUS), new Transition("old mode ", ParserState.GIT_DIFF_SEEN, IParserFunction.GIT_OLD_MODE), new Transition("new mode ", ParserState.OLD_MODE_SEEN, IParserFunction.GIT_NEW_MODE), new Transition("rename from ", ParserState.GIT_DIFF_SEEN, IParserFunction.GIT_MOVE_FROM), new Transition("rename from ", ParserState.GIT_MODE_SEEN, IParserFunction.GIT_MOVE_FROM), new Transition("rename to ", ParserState.MOVE_FROM_SEEN, IParserFunction.GIT_MOVE_TO), new Transition("copy from ", ParserState.GIT_DIFF_SEEN, IParserFunction.GIT_COPY_FROM), new Transition("copy from ", ParserState.GIT_MODE_SEEN, IParserFunction.GIT_COPY_FROM), new Transition("copy to ", ParserState.COPY_FROM_SEEN, IParserFunction.GIT_COPY_TO), new Transition("new file ", ParserState.GIT_DIFF_SEEN, IParserFunction.GIT_NEW_FILE), new Transition("deleted file ", ParserState.GIT_DIFF_SEEN, IParserFunction.GIT_DELETED_FILE), new Transition("index ", ParserState.GIT_DIFF_SEEN, IParserFunction.GIT_INDEX), new Transition("index ", ParserState.GIT_TREE_SEEN, IParserFunction.GIT_INDEX), new Transition("index ", ParserState.GIT_MODE_SEEN, IParserFunction.GIT_INDEX), new Transition("GIT binary patch", ParserState.GIT_DIFF_SEEN, IParserFunction.BINARY_PATCH_START), new Transition("GIT binary patch", ParserState.GIT_TREE_SEEN, IParserFunction.BINARY_PATCH_START), new Transition("GIT binary patch", ParserState.GIT_MODE_SEEN, IParserFunction.BINARY_PATCH_START)};
    private List<SvnDiffHunk> hunks;
    private Map<String, SvnPropertiesPatch> propPatches;
    private SvnDiffCallback.OperationKind operation;
    private boolean reverse;
    private boolean gitPatchFormat;
    Map<String, SVNMergeRangeList> mergeInfo;
    private Map reverseMergeInfo;
    private File oldFileName;
    private File newFileName;
    private File path;
    private SVNPatchFileStream patchFileStream;
    private BinaryPatch binaryPatch;
    private Boolean newExecutableBit;
    private Boolean oldExecutableBit;
    private Boolean newSymlinkBit;
    private Boolean oldSymlinkBit;
    private SVNNodeKind nodeKind;

    public static SvnPatch parseNextPatch(SvnPatchFile patchFile, boolean reverse, boolean ignoreWhitespace) throws IOException, SVNException {
        boolean eof;
        if (patchFile.getPatchFileStream().isEOF()) {
            return null;
        }
        ParserState state = ParserState.START;
        boolean lineAfterTreeHeaderRead = false;
        SvnPatch patch = new SvnPatch();
        patch.setNodeKind(SVNNodeKind.UNKNOWN);
        patch.setOperation(SvnDiffCallback.OperationKind.Unchanged);
        long pos = patchFile.getNextPatchOffset();
        patchFile.getPatchFileStream().setSeekPosition(pos);
        do {
            boolean validHeaderLine = false;
            long lastLine = pos;
            StringBuffer lineBuffer = new StringBuffer();
            eof = patchFile.getPatchFileStream().readLine(lineBuffer);
            String line = lineBuffer.toString();
            if (!eof) {
                pos = patchFile.getPatchFileStream().getSeekPosition();
            }
            for (int i = 0; i < TRANSITIONS.length; ++i) {
                Transition transition = TRANSITIONS[i];
                if (!transition.matches(line, state)) continue;
                state = transition.getParserFunction().parse(line, patch, state);
                validHeaderLine = true;
                break;
            }
            if (state == ParserState.UNIDIFF_FOUND || state == ParserState.GIT_HEADER_FOUND || state == ParserState.BINARY_PATCH_FOUND) break;
            if ((state == ParserState.GIT_TREE_SEEN || state == ParserState.GIT_MODE_SEEN) && lineAfterTreeHeaderRead && !validHeaderLine) {
                patchFile.getPatchFileStream().setSeekPosition(lastLine);
                break;
            }
            if (state == ParserState.GIT_TREE_SEEN || state == ParserState.GIT_MODE_SEEN) {
                lineAfterTreeHeaderRead = true;
                continue;
            }
            if (validHeaderLine || state == ParserState.START || state == ParserState.GIT_DIFF_SEEN) continue;
            patchFile.getPatchFileStream().setSeekPosition(lastLine);
            state = ParserState.START;
        } while (!eof);
        patch.setReverse(reverse);
        if (reverse) {
            File tmp = patch.getOldFileName();
            patch.setOldFileName(patch.getNewFileName());
            patch.setNewFileName(tmp);
            switch (patch.getOperation()) {
                case Added: {
                    patch.setOperation(SvnDiffCallback.OperationKind.Deleted);
                    break;
                }
                case Deleted: {
                    patch.setOperation(SvnDiffCallback.OperationKind.Added);
                    break;
                }
                case Modified: {
                    break;
                }
                case Copied: 
                case Moved: {
                    break;
                }
            }
            Boolean tmpBit = patch.getOldExecutableBit();
            patch.setOldExecutableBit(patch.getNewExecutableBit());
            patch.setNewExecutableBit(tmpBit);
            tmpBit = patch.getOldSymlinkBit();
            patch.setOldSymlinkBit(patch.getNewSymlinkBit());
            patch.setNewSymlinkBit(tmpBit);
        }
        if (patch.getOldFileName() == null || patch.getNewFileName() == null) {
            patch = null;
        } else {
            if (state == ParserState.BINARY_PATCH_FOUND) {
                patch.parseBinaryPatch(patch, patchFile.getPatchFileStream(), reverse);
            }
            patch.parseHunks(patchFile.getPatchFileStream(), ignoreWhitespace);
        }
        patchFile.setNextPatchOffset(0L);
        patchFile.setNextPatchOffset(patchFile.getPatchFileStream().getSeekPosition());
        if (patch != null) {
            Collections.sort(patch.hunks);
        }
        return patch;
    }

    private void parseHunks(SVNPatchFileStream patchFileStream, boolean ignoreWhitespace) throws IOException, SVNException {
        SvnDiffHunk hunk;
        String lastPropName = null;
        this.hunks = new ArrayList<SvnDiffHunk>();
        this.propPatches = new HashMap<String, SvnPropertiesPatch>();
        do {
            SvnDiffCallback.OperationKind[] propOperation;
            String[] propName;
            boolean[] isProperty;
            if ((hunk = this.parseNextHunk(isProperty = new boolean[1], propName = new String[1], propOperation = new SvnDiffCallback.OperationKind[1], patchFileStream, ignoreWhitespace)) != null && isProperty[0]) {
                if (propName[0] == null) {
                    propName[0] = lastPropName;
                } else {
                    lastPropName = propName[0];
                }
                if ("svn:mergeinfo".equals(propName[0])) continue;
                this.addPropertyHunk(propName[0], hunk, propOperation[0]);
                continue;
            }
            if (hunk == null) continue;
            this.hunks.add(hunk);
            lastPropName = null;
        } while (hunk != null);
    }

    private void parseBinaryPatch(SvnPatch patch, SVNPatchFileStream patchFileStream, boolean reverse) throws IOException, SVNException {
        boolean eof = false;
        boolean inBlob = false;
        boolean inSrc = false;
        BinaryPatch binaryPatch = new BinaryPatch();
        binaryPatch.setPatchFileStream(patchFileStream);
        long lastLine = -1L;
        long pos = patchFileStream.getSeekPosition();
        while (!eof) {
            lastLine = pos;
            StringBuffer lineBuffer = new StringBuffer();
            eof = patchFileStream.readLine(lineBuffer);
            String line = lineBuffer.toString();
            pos = patchFileStream.getSeekPosition();
            if (inBlob) {
                char c;
                char c2 = c = line.length() == 0 ? (char)'\u0000' : line.charAt(0);
                if ((c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') && line.length() <= 66 && !line.contains(":") && !line.contains(" ")) {
                    if (inSrc) {
                        binaryPatch.setSrcEnd(pos);
                        continue;
                    }
                    binaryPatch.setDstEnd(pos);
                    continue;
                }
                if (this.containsNonSpaceCharacter(line) && (!inSrc || binaryPatch.getSrcStart() >= lastLine)) break;
                if (inSrc) {
                    patch.setBinaryPatch(binaryPatch);
                    break;
                }
                inBlob = false;
                inSrc = true;
                continue;
            }
            if (!line.startsWith("literal ")) break;
            try {
                long expandedSize = Long.parseLong(line.substring("literal ".length()));
                if (inSrc) {
                    binaryPatch.setSrcStart(pos);
                    binaryPatch.setSrcFileSize(expandedSize);
                } else {
                    binaryPatch.setDstStart(pos);
                    binaryPatch.setDstFileSize(expandedSize);
                }
                inBlob = true;
            }
            catch (NumberFormatException e) {
                break;
            }
        }
        if (!eof) {
            patchFileStream.setSeekPosition(lastLine);
        } else if (inSrc && (binaryPatch.getSrcEnd() > binaryPatch.getSrcStart() || binaryPatch.getSrcFileSize() == 0L)) {
            patch.setBinaryPatch(binaryPatch);
        }
        if (reverse && patch.getBinaryPatch() != null) {
            long tmpStart = binaryPatch.getSrcStart();
            long tmpEnd = binaryPatch.getSrcEnd();
            long tmpFileSize = binaryPatch.getSrcFileSize();
            binaryPatch.setSrcStart(binaryPatch.getDstStart());
            binaryPatch.setSrcEnd(binaryPatch.getDstEnd());
            binaryPatch.setSrcFileSize(binaryPatch.getDstFileSize());
            binaryPatch.setDstStart(tmpStart);
            binaryPatch.setDstEnd(tmpEnd);
            binaryPatch.setDstFileSize(tmpFileSize);
        }
    }

    private boolean containsNonSpaceCharacter(String line) {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isSpaceChar(c)) continue;
            return true;
        }
        return false;
    }

    public SvnDiffHunk parseNextHunk(boolean[] isProperty, String[] propName, SvnDiffCallback.OperationKind[] propOperation, SVNPatchFileStream patchStream, boolean ignoreWhitespace) throws IOException, SVNException {
        long lastLine;
        String line;
        boolean eof;
        String minus = "--- ";
        String textAtat = "@@";
        String propAtat = "##";
        boolean originalNoFinalEol = false;
        boolean modifiedNoFinalEol = false;
        propOperation[0] = SvnDiffCallback.OperationKind.Unchanged;
        propName[0] = null;
        isProperty[0] = false;
        if (patchStream.isEOF()) {
            return null;
        }
        boolean inHunk = false;
        boolean hunkSeen = false;
        int leadingContext = 0;
        int trailingContext = 0;
        boolean changedLineSeen = false;
        long originalEnd = 0L;
        long modifiedEnd = 0L;
        long start = 0L;
        long end = 0L;
        int originalLines = 0;
        int modifiedLines = 0;
        SvnDiffHunk hunk = new SvnDiffHunk();
        long pos = patchStream.getSeekPosition();
        LineType lastLineType = LineType.NOISE_LINE;
        do {
            boolean foundMergeInfo;
            lastLine = pos;
            StringBuffer lineBuffer = new StringBuffer();
            eof = patchStream.readLine(lineBuffer);
            line = lineBuffer.toString();
            pos = patchStream.getSeekPosition();
            if (line.startsWith("\\")) {
                String eolStr;
                if (!inHunk) continue;
                patchStream.setSeekPosition(lastLine - 2L);
                StringBuffer buffer = new StringBuffer();
                String s = buffer.toString();
                StringBuffer eolStrBuffer = new StringBuffer();
                eof = patchStream.readLineWithEol(lineBuffer, eolStrBuffer);
                String string = eolStr = eolStrBuffer.length() == 0 ? null : eolStrBuffer.toString();
                long hunkTextEnd = eolStr == null ? lastLine : (eolStr.charAt(0) == '\r' && eolStr.charAt(1) == '\n' ? lastLine - 2L : (eolStr.charAt(0) == '\n' || eolStr.charAt(0) == '\r' ? lastLine - 1L : lastLine));
                if (lastLineType == LineType.ORIGINAL_LINE && originalEnd == 0L) {
                    originalEnd = hunkTextEnd;
                } else if (lastLineType == LineType.MODIFIED_LINE && modifiedEnd == 0L) {
                    modifiedEnd = hunkTextEnd;
                } else if (lastLineType == LineType.CONTEXT_LINE) {
                    if (originalEnd == 0L) {
                        originalEnd = hunkTextEnd;
                    }
                    if (modifiedEnd == 0L) {
                        modifiedEnd = hunkTextEnd;
                    }
                }
                patchStream.setSeekPosition(pos);
                if (lastLineType != LineType.MODIFIED_LINE) {
                    originalNoFinalEol = true;
                }
                if (lastLineType == LineType.ORIGINAL_LINE) continue;
                modifiedNoFinalEol = true;
                continue;
            }
            if (inHunk && isProperty[0] && propName[0] != null && propName[0].equals("svn:mergeinfo") && (foundMergeInfo = this.parseMergeInfo(line, hunk))) continue;
            if (inHunk) {
                char c;
                int add = 43;
                int del = 45;
                if (!hunkSeen) {
                    start = lastLine;
                }
                char c2 = c = line.length() == 0 ? (char)'\u0000' : line.charAt(0);
                if (originalLines > 0 && modifiedLines > 0 && (c == ' ' || !eof && line.length() == 0 || ignoreWhitespace && c != '-' && c != '+')) {
                    hunkSeen = true;
                    --originalLines;
                    --modifiedLines;
                    if (changedLineSeen) {
                        ++trailingContext;
                    } else {
                        ++leadingContext;
                    }
                    lastLineType = LineType.CONTEXT_LINE;
                    continue;
                }
                if (c == '-' && (originalLines > 0 || line.charAt(1) != '-')) {
                    hunkSeen = true;
                    changedLineSeen = true;
                    if (trailingContext > 0) {
                        trailingContext = 0;
                    }
                    if (originalLines > 0) {
                        --originalLines;
                    } else {
                        hunk.setOriginalLength(hunk.getOriginalLength() + 1);
                        hunk.setOriginalFuzz(hunk.getOriginalFuzz() + 1);
                    }
                    lastLineType = LineType.ORIGINAL_LINE;
                    continue;
                }
                if (c == '+' && (modifiedLines > 0 || line.charAt(1) != '+')) {
                    hunkSeen = true;
                    changedLineSeen = true;
                    if (trailingContext > 0) {
                        trailingContext = 0;
                    }
                    if (modifiedLines > 0) {
                        --modifiedLines;
                    } else {
                        hunk.setModifiedLength(hunk.getModifiedLength() + 1);
                        hunk.setModifiedFuzz(hunk.getModifiedFuzz() + 1);
                    }
                    lastLineType = LineType.MODIFIED_LINE;
                    continue;
                }
                end = eof ? pos : lastLine;
                if (originalEnd == 0L) {
                    originalEnd = end;
                }
                if (modifiedEnd != 0L) break;
                modifiedEnd = end;
                break;
            }
            if (line.startsWith("@@")) {
                inHunk = this.parseHunkHeader(line, hunk, "@@");
                if (!inHunk) continue;
                originalLines = hunk.getOriginalLength();
                modifiedLines = hunk.getModifiedLength();
                isProperty[0] = false;
                continue;
            }
            if (line.startsWith("##")) {
                inHunk = this.parseHunkHeader(line, hunk, "##");
                if (!inHunk) continue;
                originalLines = hunk.getOriginalLength();
                modifiedLines = hunk.getModifiedLength();
                isProperty[0] = true;
                continue;
            }
            if (line.startsWith("Added: ")) {
                propName[0] = this.parsePropName(line, "Added: ");
                if (propName[0] == null) continue;
                propOperation[0] = SvnDiffCallback.OperationKind.Added;
                continue;
            }
            if (line.startsWith("Deleted: ")) {
                propName[0] = this.parsePropName(line, "Deleted: ");
                if (propName[0] == null) continue;
                propOperation[0] = SvnDiffCallback.OperationKind.Deleted;
                continue;
            }
            if (line.startsWith("Modified: ")) {
                propName[0] = this.parsePropName(line, "Modified: ");
                if (propName[0] == null) continue;
                propOperation[0] = SvnDiffCallback.OperationKind.Modified;
                continue;
            }
            if (line.startsWith("--- ") || line.startsWith("diff --git ")) break;
        } while (!eof || line.length() > 0);
        if (!eof) {
            patchStream.setSeekPosition(lastLine);
        }
        if (hunkSeen && start < end) {
            if (originalLines != 0) {
                hunk.setOriginalLength(hunk.getOriginalLength() - originalLines);
                hunk.setOriginalFuzz(hunk.getOriginalFuzz() + originalLines);
            }
            if (modifiedLines != 0) {
                hunk.setModifiedLength(hunk.getModifiedLength() - modifiedLines);
                hunk.setModifiedFuzz(hunk.getModifiedFuzz() + modifiedLines);
            }
            hunk.setPatch(this);
            hunk.setPatchFileStream(patchStream);
            hunk.setLeadingContext(leadingContext);
            hunk.setTrailingContext(trailingContext);
            hunk.setDiffTextRange(new SvnDiffHunk.Range(start, end, start));
            hunk.setOriginalTextRange(new SvnDiffHunk.Range(start, originalEnd, start));
            hunk.setModifiedTextRange(new SvnDiffHunk.Range(start, modifiedEnd, start));
            hunk.setOriginalNoFinalEol(originalNoFinalEol);
            hunk.setModifiedNoFinalEol(modifiedNoFinalEol);
            return hunk;
        }
        hunk = null;
        return hunk;
    }

    private boolean parseMergeInfo(String line, SvnDiffHunk hunk) throws SVNException {
        int slashPos = line.indexOf(47);
        int colonPos = line.indexOf(58);
        boolean foundMergeInfo = false;
        if (slashPos >= 0 && colonPos >= 0 && line.charAt(colonPos + 1) == 'r' && slashPos < colonPos) {
            Map<String, SVNMergeRangeList> mergeInfoMap;
            int s;
            StringBuilder input = new StringBuilder();
            for (s = slashPos; s <= colonPos; ++s) {
                input.append(line.charAt(s));
            }
            ++s;
            while (s < line.length() && !SVNFormatUtil.isSpace(line.charAt(s))) {
                input.append(line.charAt(s));
                ++s;
            }
            try {
                mergeInfoMap = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(input.toString()), null);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.MERGE_INFO_PARSE_ERROR) {
                    mergeInfoMap = null;
                }
                throw e;
            }
            if (mergeInfoMap != null) {
                if (hunk.getOriginalLength() > 0) {
                    if (this.isReverse()) {
                        if (this.getMergeInfo() == null) {
                            this.setMergeInfo(mergeInfoMap);
                        } else {
                            SVNMergeInfoUtil.mergeMergeInfos(this.getMergeInfo(), mergeInfoMap);
                        }
                    } else if (this.getReverseMergeInfo() == null) {
                        this.setReverseMergeInfo(mergeInfoMap);
                    } else {
                        SVNMergeInfoUtil.mergeMergeInfos(this.getReverseMergeInfo(), mergeInfoMap);
                    }
                    hunk.decreaseOriginalLength();
                } else if (hunk.getModifiedLength() > 0) {
                    if (this.isReverse()) {
                        if (this.getReverseMergeInfo() == null) {
                            this.setReverseMergeInfo(mergeInfoMap);
                        } else {
                            SVNMergeInfoUtil.mergeMergeInfos(this.getReverseMergeInfo(), mergeInfoMap);
                        }
                    } else if (this.getMergeInfo() == null) {
                        this.setMergeInfo(mergeInfoMap);
                    } else {
                        SVNMergeInfoUtil.mergeMergeInfos(this.getMergeInfo(), mergeInfoMap);
                    }
                    hunk.decreaseModifiedLength();
                }
                foundMergeInfo = true;
            }
        }
        return foundMergeInfo;
    }

    private String parsePropName(String header, String indicator) throws SVNException {
        String propName = header.substring(indicator.length());
        if (propName.length() == 0) {
            return null;
        }
        if (!SVNPropertiesManager.isValidPropertyName(propName)) {
            return SVNPropertiesManager.isValidPropertyName(propName = propName.trim()) ? propName : null;
        }
        return propName;
    }

    private boolean parseHunkHeader(String header, SvnDiffHunk hunk, String atat) {
        int pos = atat.length();
        if (header.charAt(pos) != ' ') {
            return false;
        }
        if (header.charAt(++pos) != '-') {
            return false;
        }
        StringBuilder range = new StringBuilder();
        int start = ++pos;
        while (pos < header.length() && header.charAt(pos) != ' ') {
            ++pos;
        }
        if (pos == header.length() || header.charAt(pos) != ' ') {
            return false;
        }
        range.append(header.substring(start, pos));
        int[] startArray = new int[1];
        int[] lengthArray = new int[1];
        if (!this.parseRange(startArray, lengthArray, range)) {
            hunk.setOriginalStart(startArray[0]);
            hunk.setOriginalLength(lengthArray[0]);
            return false;
        }
        hunk.setOriginalStart(startArray[0]);
        hunk.setOriginalLength(lengthArray[0]);
        range = new StringBuilder();
        if (header.charAt(++pos) != '+') {
            return false;
        }
        start = ++pos;
        while (pos < header.length() && header.charAt(pos) != ' ') {
            ++pos;
        }
        if (pos == header.length() || header.charAt(pos) != ' ') {
            return false;
        }
        range.append(header.substring(start, pos));
        if (!header.substring(++pos).startsWith(atat)) {
            return false;
        }
        if (!this.parseRange(startArray, lengthArray, range)) {
            hunk.setModifiedStart(startArray[0]);
            hunk.setModifiedLength(lengthArray[0]);
            return false;
        }
        hunk.setModifiedStart(startArray[0]);
        hunk.setModifiedLength(lengthArray[0]);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseRange(int[] start, int[] length, StringBuilder range) {
        if (range.length() == 0) {
            return false;
        }
        int commaPos = range.indexOf(",");
        if (commaPos >= 0) {
            if (range.length() <= 1) return false;
            if (!this.parseOffset(length, range.substring(commaPos + ",".length()))) {
                return false;
            }
            range.setLength(commaPos);
            return this.parseOffset(start, range.toString());
        } else {
            length[0] = 1;
        }
        return this.parseOffset(start, range.toString());
    }

    private boolean parseOffset(int[] offset, String range) {
        String s = range;
        try {
            offset[0] = Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void addPropertyHunk(String propName, SvnDiffHunk hunk, SvnDiffCallback.OperationKind operation) {
        SvnPropertiesPatch propPatch = this.propPatches.get(propName);
        if (propPatch == null) {
            propPatch = new SvnPropertiesPatch(propName, new ArrayList<SvnDiffHunk>(), operation);
            this.propPatches.put(propName, propPatch);
        }
        propPatch.addHunk(hunk);
    }

    public File getOldFileName() {
        return this.oldFileName;
    }

    public File getNewFileName() {
        return this.newFileName;
    }

    public List<SvnDiffHunk> getHunks() {
        return this.hunks;
    }

    public Map<String, SvnPropertiesPatch> getPropPatches() {
        return this.propPatches;
    }

    public SvnDiffCallback.OperationKind getOperation() {
        return this.operation;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public boolean isGitPatchFormat() {
        return this.gitPatchFormat;
    }

    public void setGitPatchFormat(boolean gitPatchFormat) {
        this.gitPatchFormat = gitPatchFormat;
    }

    public Map getMergeInfo() {
        return this.mergeInfo;
    }

    public Map getReverseMergeInfo() {
        return this.reverseMergeInfo;
    }

    public void setMergeInfo(Map<String, SVNMergeRangeList> mergeInfo) {
        this.mergeInfo = mergeInfo;
    }

    public void setReverseMergeInfo(Map reverseMergeInfo) {
        this.reverseMergeInfo = reverseMergeInfo;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void setOldFileName(File oldFileName) {
        this.oldFileName = oldFileName;
    }

    public void setNewFileName(File newFileName) {
        this.newFileName = newFileName;
    }

    public void setOperation(SvnDiffCallback.OperationKind operation) {
        this.operation = operation;
    }

    private static File grabFileName(String s) {
        if ("/dev/null".equals(s)) {
            return DEV_NULL;
        }
        return SVNFileUtil.createFilePath(SVNPathUtil.canonicalizePath(s));
    }

    public void setBinaryPatch(BinaryPatch binaryPatch) {
        this.binaryPatch = binaryPatch;
    }

    public BinaryPatch getBinaryPatch() {
        return this.binaryPatch;
    }

    public Boolean getNewExecutableBit() {
        return this.newExecutableBit;
    }

    public void setNewExecutableBit(Boolean newExecutableBit) {
        this.newExecutableBit = newExecutableBit;
    }

    public Boolean getOldExecutableBit() {
        return this.oldExecutableBit;
    }

    public void setOldExecutableBit(Boolean oldExecutableBit) {
        this.oldExecutableBit = oldExecutableBit;
    }

    public Boolean getNewSymlinkBit() {
        return this.newSymlinkBit;
    }

    public void setNewSymlinkBit(Boolean newSymlinkBit) {
        this.newSymlinkBit = newSymlinkBit;
    }

    public Boolean getOldSymlinkBit() {
        return this.oldSymlinkBit;
    }

    public void setOldSymlinkBit(Boolean oldSymlinkBit) {
        this.oldSymlinkBit = oldSymlinkBit;
    }

    public SVNNodeKind getNodeKind() {
        return this.nodeKind;
    }

    public void setNodeKind(SVNNodeKind nodeKind) {
        this.nodeKind = nodeKind;
    }

    private Boolean[] parseGitModeBits(String modeString) {
        Boolean symlinkBit;
        Boolean executableBit;
        int mode = Integer.parseInt(modeString, 8);
        switch (mode & 0x1FF) {
            case 420: {
                executableBit = Boolean.FALSE;
                break;
            }
            case 493: {
                executableBit = Boolean.TRUE;
                break;
            }
            default: {
                executableBit = null;
            }
        }
        switch (mode & 0xF000) {
            case 40960: {
                symlinkBit = Boolean.TRUE;
                break;
            }
            case 16384: 
            case 32768: {
                symlinkBit = Boolean.FALSE;
                break;
            }
            default: {
                symlinkBit = null;
            }
        }
        return new Boolean[]{executableBit, symlinkBit};
    }

    protected static int readFully(InputStream inputStream, byte[] b, int off, int len) throws IOException {
        int bytesRead;
        int totalBytesRead = 0;
        while ((bytesRead = inputStream.read(b, off, len)) >= 0) {
            totalBytesRead += bytesRead;
            off += bytesRead;
            if ((len -= bytesRead) != 0) continue;
            break;
        }
        if (totalBytesRead == 0) {
            return -1;
        }
        return totalBytesRead;
    }

    private static class CheckBase85LengthInputStream
    extends InputStream {
        private final InputStream inputStream;
        private final byte[] singleByteBuffer;
        private long remaining;

        private CheckBase85LengthInputStream(InputStream inputStream, long remaining) {
            this.inputStream = inputStream;
            this.remaining = remaining;
            this.singleByteBuffer = new byte[1];
        }

        @Override
        public int read() throws IOException {
            int read = this.inputStream.read(this.singleByteBuffer, 0, 1);
            if (read < 0) {
                return read;
            }
            return this.singleByteBuffer[0] & 0xFF;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int requestedLength = len;
            if ((len = SvnPatch.readFully(this.inputStream, b, off, len)) < 0) {
                len = 0;
            }
            if ((long)len > this.remaining) {
                throw new IOException("Base85 data expands to longer than declared filesize");
            }
            if (requestedLength > len && (long)len != this.remaining) {
                throw new IOException("Base85 data expands to smaller than declared filesize");
            }
            this.remaining -= (long)len;
            return len == 0 ? -1 : len;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.inputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.inputStream.available();
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public void mark(int readlimit) {
            this.inputStream.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.inputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }
    }

    private static class Base85DataStream
    extends InputStream {
        private final SVNPatchFileStream patchFileStream;
        private long start;
        private final long end;
        private boolean done;
        private byte[] buffer;
        private int bufSize;
        private int bufPos;
        private byte[] singleByteBuffer;

        public Base85DataStream(SVNPatchFileStream patchFileStream, long start, long end) {
            this.patchFileStream = patchFileStream;
            this.start = start;
            this.end = end;
            this.done = false;
            this.buffer = new byte[52];
            this.bufSize = 0;
            this.bufPos = 0;
            this.singleByteBuffer = new byte[1];
        }

        @Override
        public int read() throws IOException {
            int bytesRead = this.read(this.singleByteBuffer, 0, 1);
            if (bytesRead < 0) {
                return bytesRead;
            }
            return this.singleByteBuffer[0] & 0xFF;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int remaining = len;
                int destOff = off;
                if (this.done) {
                    return -1;
                }
                while (remaining != 0 && (this.bufSize > this.bufPos || this.start < this.end)) {
                    int available = this.bufSize - this.bufPos;
                    if (available != 0) {
                        int n = remaining < available ? remaining : available;
                        System.arraycopy(this.buffer, this.bufPos, b, destOff, n);
                        destOff += n;
                        this.bufPos += n;
                        if ((remaining -= n) == 0) {
                            return len;
                        }
                    }
                    if (this.start >= this.end) break;
                    this.patchFileStream.setSeekPosition(this.start);
                    StringBuffer lineBuf = new StringBuffer();
                    boolean atEof = this.patchFileStream.readLine(lineBuf);
                    String line = lineBuf.toString();
                    this.start = atEof ? this.end : this.patchFileStream.getSeekPosition();
                    if (line.length() > 0 && line.charAt(0) >= 'A' && line.charAt(0) <= 'Z') {
                        this.bufSize = line.charAt(0) - 65 + 1;
                    } else if (line.length() > 0 && line.charAt(0) >= 'a' && line.charAt(0) <= 'z') {
                        this.bufSize = line.charAt(0) - 97 + 26 + 1;
                    } else {
                        throw new IOException("Unexpected data in base85 section");
                    }
                    if (this.bufSize < 52) {
                        this.start = this.end;
                    }
                    Base85DataStream.base85DecodeLine(this.buffer, this.bufSize, line.substring(1));
                    this.bufPos = 0;
                }
                this.done = true;
                return len -= remaining;
            }
            catch (SVNException e) {
                throw new IOException(e);
            }
        }

        private static void base85DecodeLine(byte[] outputBuffer, int outputBufferSize, String line) throws IOException {
            int expectedData = (outputBufferSize + 3) / 4 * 5;
            if (line.length() != expectedData) {
                throw new IOException("Unexpected base85 line length");
            }
            int base85Offet = 0;
            int base85Length = line.length();
            int outputBufferOffset = 0;
            while (base85Length != 0) {
                int i;
                long info = 0L;
                for (i = 0; i < 5; ++i) {
                    int value = Base85DataStream.base85Value(line.charAt(base85Offet + i));
                    info *= 85L;
                    info += (long)value;
                }
                i = 0;
                int n = 24;
                while (i < 4) {
                    if (i < outputBufferSize) {
                        outputBuffer[outputBufferOffset + i] = (byte)(info >> n & 0xFFL);
                    }
                    ++i;
                    n -= 8;
                }
                base85Offet += 5;
                base85Length -= 5;
                outputBufferOffset += 4;
                outputBufferSize -= 4;
            }
        }

        private static int base85Value(char c) throws IOException {
            int index = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!#$%&()*+-;<=>?@^_`{|}~".indexOf(String.valueOf(c));
            if (index < 0) {
                throw new IOException("Invalid base85 value");
            }
            return index;
        }
    }

    public static class BinaryPatch {
        private SvnPatch patch;
        private SVNPatchFileStream patchFileStream;
        private long srcStart;
        private long srcEnd;
        private long srcFileSize;
        private long dstStart;
        private long dstEnd;
        private long dstFileSize;

        public SvnPatch getPatch() {
            return this.patch;
        }

        public void setPatch(SvnPatch patch) {
            this.patch = patch;
        }

        public SVNPatchFileStream getPatchFileStream() {
            return this.patchFileStream;
        }

        public void setPatchFileStream(SVNPatchFileStream patchFileStream) {
            this.patchFileStream = patchFileStream;
        }

        public long getSrcStart() {
            return this.srcStart;
        }

        public void setSrcStart(long srcStart) {
            this.srcStart = srcStart;
        }

        public long getSrcEnd() {
            return this.srcEnd;
        }

        public void setSrcEnd(long srcEnd) {
            this.srcEnd = srcEnd;
        }

        public long getSrcFileSize() {
            return this.srcFileSize;
        }

        public void setSrcFileSize(long srcFileSize) {
            this.srcFileSize = srcFileSize;
        }

        public long getDstStart() {
            return this.dstStart;
        }

        public void setDstStart(long dstStart) {
            this.dstStart = dstStart;
        }

        public long getDstEnd() {
            return this.dstEnd;
        }

        public void setDstEnd(long dstEnd) {
            this.dstEnd = dstEnd;
        }

        public long getDstFileSize() {
            return this.dstFileSize;
        }

        public void setDstFileSize(long dstFileSize) {
            this.dstFileSize = dstFileSize;
        }

        public InputStream getBinaryDiffOriginalStream() {
            InputStream inputStream = new Base85DataStream(this.patchFileStream, this.srcStart, this.srcEnd);
            inputStream = new InflaterInputStream(inputStream);
            return new CheckBase85LengthInputStream(inputStream, this.srcFileSize);
        }

        public InputStream getBinaryDiffResultStream() {
            InputStream inputStream = new Base85DataStream(this.patchFileStream, this.dstStart, this.dstEnd);
            inputStream = new InflaterInputStream(inputStream);
            return new CheckBase85LengthInputStream(inputStream, this.dstFileSize);
        }
    }

    private static enum LineType {
        NOISE_LINE,
        ORIGINAL_LINE,
        MODIFIED_LINE,
        CONTEXT_LINE;

    }

    private static class Transition {
        private String expectedInput;
        private ParserState state;
        private IParserFunction parserFunction;

        public Transition(String expectedInput, ParserState state, IParserFunction parserFunction) {
            this.expectedInput = expectedInput;
            this.state = state;
            this.parserFunction = parserFunction;
        }

        public boolean matches(String line, ParserState state) {
            return line.startsWith(this.expectedInput) && this.state == state;
        }

        private IParserFunction getParserFunction() {
            return this.parserFunction;
        }
    }

    private static interface IParserFunction {
        public static final IParserFunction DIFF_MINUS = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                String s = line.split("\t")[0].substring("--- ".length());
                patch.setOldFileName(SvnPatch.grabFileName(s));
                return ParserState.MINUS_SEEN;
            }
        };
        public static final IParserFunction DIFF_PLUS = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                String s = line.split("\t")[0].substring("+++ ".length());
                patch.setNewFileName(SvnPatch.grabFileName(s));
                return ParserState.UNIDIFF_FOUND;
            }
        };
        public static final IParserFunction GIT_START = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                int oldPathMarkerPos = line.indexOf(" a/");
                if (oldPathMarkerPos < 0) {
                    return ParserState.START;
                }
                if (oldPathMarkerPos + 3 == line.length()) {
                    return ParserState.START;
                }
                int newPathMarkerPos = line.indexOf(" b/");
                if (newPathMarkerPos < 0) {
                    return ParserState.START;
                }
                int oldPathStartPos = "diff --git a/".length();
                int newPathEndPos = line.length();
                int newPathStartPos = oldPathStartPos;
                while ((newPathMarkerPos = line.indexOf(" b/", newPathStartPos)) >= 0) {
                    int oldPathEndPos = newPathMarkerPos;
                    int lenOld = oldPathEndPos - oldPathStartPos;
                    newPathStartPos = newPathMarkerPos + " b/".length();
                    int lenNew = newPathEndPos - newPathStartPos;
                    if (lenOld != lenNew || !line.substring(oldPathStartPos, oldPathEndPos).equals(line.substring(newPathStartPos, newPathEndPos))) continue;
                    patch.setOldFileName(SvnPatch.grabFileName(line.substring(oldPathStartPos, oldPathEndPos)));
                    patch.setNewFileName(SvnPatch.grabFileName(line.substring(newPathStartPos)));
                    break;
                }
                patch.setOperation(SvnDiffCallback.OperationKind.Modified);
                patch.setGitPatchFormat(true);
                return ParserState.GIT_DIFF_SEEN;
            }
        };
        public static final IParserFunction GIT_MINUS = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                String s = line.split("\t")[0];
                if (s.startsWith("--- /dev/null")) {
                    patch.setOldFileName(SvnPatch.grabFileName("/dev/null"));
                } else {
                    patch.setOldFileName(SvnPatch.grabFileName(s.substring("--- a/".length())));
                }
                patch.setGitPatchFormat(true);
                return ParserState.GIT_MINUS_SEEN;
            }
        };
        public static final IParserFunction GIT_PLUS = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                String s = line.split("\t")[0];
                if (s.startsWith("+++ /dev/null")) {
                    patch.setNewFileName(SvnPatch.grabFileName("/dev/null"));
                } else {
                    patch.setNewFileName(SvnPatch.grabFileName(s.substring("+++ b/".length())));
                }
                patch.setGitPatchFormat(true);
                return ParserState.GIT_HEADER_FOUND;
            }
        };
        public static final IParserFunction GIT_OLD_MODE = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                Boolean[] modeBits = patch.parseGitModeBits(line.substring("old mode ".length()));
                patch.setOldExecutableBit(modeBits[0]);
                patch.setOldSymlinkBit(modeBits[1]);
                patch.setGitPatchFormat(true);
                return ParserState.OLD_MODE_SEEN;
            }
        };
        public static final IParserFunction GIT_NEW_MODE = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                Boolean[] modeBits = patch.parseGitModeBits(line.substring("new mode ".length()));
                patch.setNewExecutableBit(modeBits[0]);
                patch.setNewSymlinkBit(modeBits[1]);
                patch.setGitPatchFormat(true);
                return ParserState.GIT_MODE_SEEN;
            }
        };
        public static final IParserFunction GIT_MOVE_FROM = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                patch.setOldFileName(SvnPatch.grabFileName(line.substring("rename from ".length())));
                patch.setGitPatchFormat(true);
                return ParserState.MOVE_FROM_SEEN;
            }
        };
        public static final IParserFunction GIT_MOVE_TO = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                patch.setNewFileName(SvnPatch.grabFileName(line.substring("rename to ".length())));
                patch.setOperation(SvnDiffCallback.OperationKind.Moved);
                patch.setGitPatchFormat(true);
                return ParserState.GIT_TREE_SEEN;
            }
        };
        public static final IParserFunction GIT_COPY_FROM = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                patch.setOldFileName(SvnPatch.grabFileName(line.substring("copy from ".length())));
                patch.setGitPatchFormat(true);
                return ParserState.COPY_FROM_SEEN;
            }
        };
        public static final IParserFunction GIT_COPY_TO = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                patch.setNewFileName(SvnPatch.grabFileName(line.substring("copy to ".length())));
                patch.setOperation(SvnDiffCallback.OperationKind.Copied);
                patch.setGitPatchFormat(true);
                return ParserState.GIT_TREE_SEEN;
            }
        };
        public static final IParserFunction GIT_NEW_FILE = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                Boolean[] modeBits = patch.parseGitModeBits(line.substring("new file mode ".length()));
                patch.setNewExecutableBit(modeBits[0]);
                patch.setNewSymlinkBit(modeBits[1]);
                patch.setOperation(SvnDiffCallback.OperationKind.Added);
                patch.setNodeKind(SVNNodeKind.FILE);
                patch.setGitPatchFormat(true);
                return ParserState.GIT_TREE_SEEN;
            }
        };
        public static final IParserFunction GIT_DELETED_FILE = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                patch.setOperation(SvnDiffCallback.OperationKind.Deleted);
                patch.setGitPatchFormat(true);
                return ParserState.GIT_TREE_SEEN;
            }
        };
        public static final IParserFunction GIT_INDEX = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                int pos = line.substring("index ".length()).indexOf(32);
                if (pos >= 0 && patch.getNewExecutableBit() == null && patch.getNewSymlinkBit() == null && patch.getOperation() != SvnDiffCallback.OperationKind.Added && patch.getOperation() != SvnDiffCallback.OperationKind.Deleted) {
                    Boolean[] modeBits = patch.parseGitModeBits(line.substring(" ".length()));
                    patch.setNewExecutableBit(modeBits[0]);
                    patch.setNewSymlinkBit(modeBits[1]);
                    patch.setOldExecutableBit(patch.getNewExecutableBit());
                    patch.setOldSymlinkBit(patch.getNewSymlinkBit());
                }
                patch.setGitPatchFormat(true);
                return currentState;
            }
        };
        public static final IParserFunction BINARY_PATCH_START = new IParserFunction(){

            @Override
            public ParserState parse(String line, SvnPatch patch, ParserState currentState) {
                return ParserState.BINARY_PATCH_FOUND;
            }
        };

        public ParserState parse(String var1, SvnPatch var2, ParserState var3);
    }

    private static enum ParserState {
        START,
        GIT_DIFF_SEEN,
        GIT_TREE_SEEN,
        GIT_MINUS_SEEN,
        GIT_PLUS_SEEN,
        OLD_MODE_SEEN,
        GIT_MODE_SEEN,
        MOVE_FROM_SEEN,
        COPY_FROM_SEEN,
        MINUS_SEEN,
        UNIDIFF_FOUND,
        GIT_HEADER_FOUND,
        BINARY_PATCH_FOUND;

    }
}

