/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.tmatesoft.svn.core.internal.io.dav.http.INTLMEngine;
import org.tmatesoft.svn.core.internal.io.dav.http.NTLMEngineException;
import org.tmatesoft.svn.core.internal.util.SVNBase64;

public class NTLMJCIFSEngine
implements INTLMEngine {
    private static final int TYPE_1_FLAGS = -1610055676;

    public static boolean isAvailable() {
        try {
            Class<?> clazz = Class.forName("jcifs.ntlmssp.NtlmFlags");
            return clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @Override
    public String generateType1Msg(String domain, String ws) throws NTLMEngineException {
        try {
            Class<?> type1MessageClass = Class.forName("jcifs.ntlmssp.Type1Message");
            Constructor<?> constructor = type1MessageClass.getConstructor(Integer.TYPE, String.class, String.class);
            Object type1MessageObject = constructor.newInstance(-1610055676, domain, ws);
            Method toByteArray = type1MessageClass.getMethod("toByteArray", new Class[0]);
            byte[] message = (byte[])toByteArray.invoke(type1MessageObject, new Object[0]);
            return SVNBase64.byteArrayToBase64(message);
        }
        catch (Exception e) {
            throw new NTLMEngineException(e.getMessage(), e);
        }
    }

    @Override
    public String generateType3Msg(String userName, char[] password, String domain, String ws, String token) throws NTLMEngineException {
        byte[] buffer = new byte[token.length()];
        int length = SVNBase64.base64ToByteArray(new StringBuffer(token), buffer);
        byte[] tokenBytes = new byte[length];
        System.arraycopy(buffer, 0, tokenBytes, 0, length);
        try {
            Class<?> type2MessageClass = Class.forName("jcifs.ntlmssp.Type2Message");
            Class<?> type3MessageClass = Class.forName("jcifs.ntlmssp.Type3Message");
            Constructor<?> type2Constructor = type2MessageClass.getConstructor(byte[].class);
            Constructor<?> type3Constructor = type3MessageClass.getConstructor(type2MessageClass, String.class, String.class, String.class, String.class, Integer.TYPE);
            Object type2MessageObject = type2Constructor.newInstance(new Object[]{tokenBytes});
            Method getFlags = type2MessageClass.getMethod("getFlags", new Class[0]);
            int type2Flags = (Integer)getFlags.invoke(type2MessageObject, new Object[0]);
            int type3Flags = type2Flags & 0xFFFCFFFF;
            Object type3MessageObject = type3Constructor.newInstance(type2MessageObject, new String(password), domain, userName, ws, type3Flags);
            Method toByteArray = type3MessageClass.getMethod("toByteArray", new Class[0]);
            byte[] message = (byte[])toByteArray.invoke(type3MessageObject, new Object[0]);
            return SVNBase64.byteArrayToBase64(message);
        }
        catch (Exception e) {
            throw new NTLMEngineException(e.getMessage(), e);
        }
    }
}

