/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchTargetInfo;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemove;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatch;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatchFile;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatchTarget;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgPatch
extends SvnNgOperationRunner<Void, org.tmatesoft.svn.core.wc2.SvnPatch> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void run(SVNWCContext context) throws SVNException {
        SVNErrorMessage errorMessage;
        File workingCopyDirectory;
        SVNErrorMessage errorMessage2;
        File patchFile;
        SVNNodeKind kind;
        SvnTarget firstTarget;
        if (((org.tmatesoft.svn.core.wc2.SvnPatch)this.getOperation()).getStripCount() < 0) {
            SVNErrorMessage errorMessage3 = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "strip count must be positive");
            SVNErrorManager.error(errorMessage3, SVNLogType.WC);
        }
        if ((firstTarget = ((org.tmatesoft.svn.core.wc2.SvnPatch)this.getOperation()).getFirstTarget()).isURL()) {
            SVNErrorMessage errorMessage4 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not a local path", (Object)firstTarget);
            SVNErrorManager.error(errorMessage4, SVNLogType.WC);
        }
        if ((kind = SVNFileType.getNodeKind(SVNFileType.getType(patchFile = ((org.tmatesoft.svn.core.wc2.SvnPatch)this.getOperation()).getPatchFile()))) == SVNNodeKind.NONE) {
            errorMessage2 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' does not exist", (Object)patchFile);
            SVNErrorManager.error(errorMessage2, SVNLogType.WC);
        }
        if (kind != SVNNodeKind.FILE) {
            errorMessage2 = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not a file", (Object)patchFile);
            SVNErrorManager.error(errorMessage2, SVNLogType.WC);
        }
        if ((kind = SVNFileType.getNodeKind(SVNFileType.getType(workingCopyDirectory = firstTarget.getFile()))) == SVNNodeKind.NONE) {
            errorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' does not exist", (Object)workingCopyDirectory);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        if (kind != SVNNodeKind.DIR) {
            errorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not a directory", (Object)workingCopyDirectory);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        File lockAbsPath = null;
        try {
            lockAbsPath = context.acquireWriteLock(workingCopyDirectory, false, false);
            this.applyPatches(patchFile, workingCopyDirectory, ((org.tmatesoft.svn.core.wc2.SvnPatch)this.getOperation()).isDryRun(), ((org.tmatesoft.svn.core.wc2.SvnPatch)this.getOperation()).getStripCount(), ((org.tmatesoft.svn.core.wc2.SvnPatch)this.getOperation()).isReverse(), ((org.tmatesoft.svn.core.wc2.SvnPatch)this.getOperation()).isIgnoreWhitespace(), ((org.tmatesoft.svn.core.wc2.SvnPatch)this.getOperation()).isRemoveTempFiles(), context);
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage5 = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage5, SVNLogType.WC);
        }
        finally {
            if (lockAbsPath != null) {
                context.releaseWriteLock(lockAbsPath);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPatches(File patchFile, File workingCopyDirectory, boolean dryRun, int stripCount, boolean reverse, boolean ignoreWhitespace, boolean removeTempFiles, SVNWCContext context) throws SVNException, IOException {
        SvnPatchFile svnPatchFile = SvnPatchFile.openReadOnly(patchFile);
        try {
            SvnPatch patch;
            ArrayList<SVNPatchTargetInfo> targetInfos = new ArrayList<SVNPatchTargetInfo>();
            do {
                SvnPatchTarget target;
                this.checkCancelled();
                patch = SvnPatch.parseNextPatch(svnPatchFile, reverse, ignoreWhitespace);
                if (patch == null || (target = SvnPatchTarget.applyPatch(patch, workingCopyDirectory, stripCount, context, ignoreWhitespace, removeTempFiles, ((org.tmatesoft.svn.core.wc2.SvnPatch)this.getOperation()).getPatchHandler())).isFiltered()) continue;
                SVNPatchTargetInfo targetInfo = new SVNPatchTargetInfo(target.getAbsPath(), target.isDeleted());
                if (!target.isSkipped()) {
                    targetInfos.add(targetInfo);
                    if (target.hasTextChanges() || target.isAdded() || target.getMoveTargetAbsPath() != null || target.isDeleted()) {
                        target.installPatchedTarget(workingCopyDirectory, dryRun, context);
                    }
                    if (target.hasPropChanges() && !target.isDeleted()) {
                        target.installPatchedPropTarget(dryRun, context);
                    }
                    target.writeOutRejectedHunks(dryRun);
                }
                target.sendPatchNotification(context);
                if (!target.isDeleted() || target.isSkipped()) continue;
                this.checkAncestorDelete(targetInfo.getLocalAbsPath(), targetInfos, workingCopyDirectory, context, dryRun);
            } while (patch != null);
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
        finally {
            if (svnPatchFile != null) {
                svnPatchFile.close();
            }
        }
    }

    private void checkAncestorDelete(File deletedTarget, List<SVNPatchTargetInfo> targetsInfo, File applyRoot, SVNWCContext context, boolean dryRun) throws SVNException {
        File dirAbsPath = SVNFileUtil.getFileDir(deletedTarget);
        Collection<String> globalIgnores = SVNStatusEditor17.getGlobalIgnores(context.getOptions());
        while (SVNPathUtil.isAncestor(SVNFileUtil.getFilePath(applyRoot), SVNFileUtil.getFilePath(dirAbsPath)) && !applyRoot.equals(dirAbsPath)) {
            CanDeleteBaton statusWalker;
            block5: {
                statusWalker = new CanDeleteBaton();
                statusWalker.localAbsPath = dirAbsPath;
                statusWalker.mustKeep = false;
                statusWalker.targetsInfo = targetsInfo;
                SVNStatusEditor17 editor = new SVNStatusEditor17(dirAbsPath, context, context.getOptions(), false, true, SVNDepth.INFINITY, statusWalker);
                try {
                    editor.walkStatus(dirAbsPath, SVNDepth.INFINITY, true, false, false, globalIgnores);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CEASE_INVOCATION) break block5;
                    throw e;
                }
            }
            if (statusWalker.mustKeep) break;
            if (!dryRun) {
                SvnNgRemove.delete(context, dirAbsPath, null, false, false, null);
            }
            SVNPatchTargetInfo targetInfo = new SVNPatchTargetInfo(dirAbsPath, true);
            targetsInfo.add(targetInfo);
            ISVNEventHandler eventHandler = context.getEventHandler();
            if (eventHandler != null) {
                eventHandler.handleEvent(SVNEventFactory.createSVNEvent(dirAbsPath, SVNNodeKind.DIR, null, -1L, SVNEventAction.DELETE, SVNEventAction.DELETE, null, null), -1.0);
            }
            dirAbsPath = SVNFileUtil.getFileDir(dirAbsPath);
        }
    }

    private class CanDeleteBaton
    implements ISvnObjectReceiver<SvnStatus> {
        public File localAbsPath;
        public boolean mustKeep;
        public List<SVNPatchTargetInfo> targetsInfo;

        private CanDeleteBaton() {
        }

        @Override
        public void receive(SvnTarget target, SvnStatus status) throws SVNException {
            if (status.getNodeStatus() == SVNStatusType.STATUS_NONE || status.getNodeStatus() == SVNStatusType.STATUS_DELETED) {
                return;
            }
            if (this.localAbsPath.equals(target.getFile())) {
                return;
            }
            for (SVNPatchTargetInfo targetInfo : this.targetsInfo) {
                if (!targetInfo.getLocalAbsPath().equals(target.getFile())) continue;
                if (!targetInfo.isDeleted()) break;
                return;
            }
            this.mustKeep = true;
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CEASE_INVOCATION);
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
    }
}

