/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class FSRepresentation {
    public static final String REP_DELTA = "DELTA";
    public static final String REP_PLAIN = "PLAIN";
    public static final String REP_TRAILER = "ENDREP";
    private long myRevision;
    private long myItemIndex;
    private long mySize;
    private long myExpandedSize;
    private String myMD5HexDigest;
    private String mySHA1HexDigest;
    private String myTxnId;
    private String myUniquifier;

    public static FSRepresentation parse(String representationString) throws SVNException {
        String[] fields = representationString.split(" ");
        if (fields.length != 5 && fields.length != 7) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text representation offset line in node-rev");
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
        }
        try {
            long revision = Long.parseLong(fields[0]);
            long itemIndex = Long.parseLong(fields[1]);
            long size = Long.parseLong(fields[2]);
            long expandedSize = Long.parseLong(fields[3]);
            String md5Checksum = fields[4];
            FSRepresentation representation = new FSRepresentation();
            representation.setRevision(revision);
            representation.setItemIndex(itemIndex);
            representation.setSize(size);
            representation.setExpandedSize(expandedSize);
            representation.setMD5HexDigest(md5Checksum);
            if (fields.length == 7) {
                String sha1Checksum = fields[5];
                String[] transactionWithUniquifier = fields[6].split("/_");
                if (transactionWithUniquifier.length != 2) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text representation offset line in node-rev");
                    SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
                }
                String txnId = transactionWithUniquifier[0];
                representation.setSHA1HexDigest(sha1Checksum);
                representation.setTxnId(txnId);
                representation.setUniquifier(fields[6]);
            }
            return representation;
        }
        catch (NumberFormatException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.FS_CORRUPT, "Malformed text representation offset line in node-rev");
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            return null;
        }
    }

    public FSRepresentation(FSRepresentation representation) {
        this.myRevision = representation.myRevision;
        this.myItemIndex = representation.myItemIndex;
        this.mySize = representation.mySize;
        this.myExpandedSize = representation.myExpandedSize;
        this.myMD5HexDigest = representation.myMD5HexDigest;
        this.mySHA1HexDigest = representation.mySHA1HexDigest;
        this.myUniquifier = representation.myUniquifier;
        this.myTxnId = representation.myTxnId;
    }

    public FSRepresentation() {
        this.myRevision = -1L;
        this.myItemIndex = -1L;
        this.mySize = -1L;
        this.myExpandedSize = -1L;
    }

    public void setRevision(long rev) {
        this.myRevision = rev;
    }

    public void setItemIndex(long itemIndex) {
        this.myItemIndex = itemIndex;
    }

    public void setSize(long size) {
        this.mySize = size;
    }

    public void setExpandedSize(long expandedSize) {
        this.myExpandedSize = expandedSize;
    }

    public void setMD5HexDigest(String hexDigest) {
        this.myMD5HexDigest = hexDigest;
    }

    public String getSHA1HexDigest() {
        return this.mySHA1HexDigest;
    }

    public void setSHA1HexDigest(String hexDigest) {
        this.mySHA1HexDigest = hexDigest;
    }

    public String getUniquifier() {
        return this.myUniquifier;
    }

    public void setUniquifier(String uniquifier) {
        this.myUniquifier = uniquifier;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public long getItemIndex() {
        return this.myItemIndex;
    }

    public long getSize() {
        return this.mySize;
    }

    public long getExpandedSize() {
        return this.myExpandedSize;
    }

    public String getMD5HexDigest() {
        return this.myMD5HexDigest;
    }

    public static boolean compareRepresentations(FSRepresentation r1, FSRepresentation r2) {
        if (r1 == r2) {
            return true;
        }
        if (r1 == null) {
            return false;
        }
        return r1.equals(r2);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != FSRepresentation.class) {
            return false;
        }
        FSRepresentation rep = (FSRepresentation)obj;
        if (this.myRevision != rep.myRevision) {
            return false;
        }
        if (this.myItemIndex != rep.myItemIndex) {
            return false;
        }
        if (this.myUniquifier == rep.myUniquifier) {
            return true;
        }
        if (this.myUniquifier == null || rep.myUniquifier == null) {
            return false;
        }
        return this.myUniquifier.equals(rep.myUniquifier);
    }

    public String getStringRepresentation(int dbFormat) {
        if (dbFormat < 4 || this.mySHA1HexDigest == null || this.myUniquifier == null) {
            return this.myRevision + " " + this.myItemIndex + " " + this.mySize + " " + this.myExpandedSize + " " + this.myMD5HexDigest;
        }
        return this.myRevision + " " + this.myItemIndex + " " + this.mySize + " " + this.myExpandedSize + " " + this.myMD5HexDigest + " " + this.mySHA1HexDigest + " " + this.myUniquifier;
    }

    public String getTxnId() {
        return this.myTxnId;
    }

    public void setTxnId(String txnId) {
        this.myTxnId = txnId;
    }

    public boolean isTxn() {
        return this.myTxnId != null;
    }
}

