/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.svn;

import com.xebialabs.xlrelease.plugin.svn.SvnKitFacade;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.SVNRepository;

public class SvnClient {
    private String svnRoot;
    private String userName;
    private String password;
    private SvnKitFacade svnKitFacade;

    public SvnClient(String svnRoot, String userName, String password) {
        this(svnRoot, userName, password, new SvnKitFacade());
    }

    SvnClient(String svnRoot, String userName, String password, SvnKitFacade svnKitFacade) {
        this.svnRoot = svnRoot;
        this.userName = userName;
        this.password = password;
        this.svnKitFacade = svnKitFacade;
    }

    public long getLatestRevision() throws SVNException {
        return this.getLatestRevision(null);
    }

    public long getLatestRevision(String lastRevisionChecked) throws SVNException {
        this.svnKitFacade.setup();
        SVNRepository repository = this.svnKitFacade.create(this.svnRoot);
        ISVNAuthenticationManager authenticationManager = this.svnKitFacade.createDefaultAuthenticationManager(this.userName, this.password);
        repository.setAuthenticationManager(authenticationManager);
        long latestRevision = repository.getLatestRevision();
        if (lastRevisionChecked == null) {
            return latestRevision;
        }
        long lastRevisionCheckedLong = Long.parseLong(lastRevisionChecked);
        SVNDirEntry folderInfo = repository.info(this.getRelativePath(repository), repository.getLatestRevision());
        if (folderInfo.getRevision() >= lastRevisionCheckedLong && lastRevisionCheckedLong != latestRevision) {
            return latestRevision;
        }
        return lastRevisionCheckedLong;
    }

    private String getRelativePath(SVNRepository repository) throws SVNException {
        String repoPath = SVNURL.parseURIEncoded((String)this.svnRoot).getPath().substring(repository.getRepositoryRoot(true).getPath().length());
        if (!repoPath.startsWith("/")) {
            repoPath = "/" + repoPath;
        }
        return repoPath;
    }
}

