'use strict';
(function () {

    var TaskProgressTileViewController = function ($scope, XlrTileHelper, TasksService, ReleaseGridService) {
        var vm = this;
        var tile;
        if ($scope.xlrTile) {
            // summary mode
            vm.release = $scope.release;
            tile = $scope.xlrTile.tile;
        } else {
            // details mode
            tile = $scope.xlrTileDetailsCtrl.tile;
            vm.release = $scope.xlrTileDetailsCtrl.release;
        }

        vm.chartOptions = {
            topTitleText: function(data) {
                return data.completed + "/" + (data.completed + data.planned);
            },
            bottomTitleText: "tasks",
            legend: {
                borderRadius: 0
            },
            series: function (data) {
                return [{
                    name: 'Tasks',
                    data: [{
                        y: data.completed,
                        name: "Completed",
                        color: "#5DAE3F"
                    }, {
                        y: data.planned,
                        name: "Planned",
                        color: "#DDD"
                    }]
                }];
            },
            showLegend: true,
            donutThickness: '90%'
        };

        refresh();

        function refresh() {
            vm.tags = tile.configurationProperties.tags;
            vm.taskWithTags = getTaskWithTags(vm.tags);

            var completedTasks = calculateCompletedTasks(vm.taskWithTags);
            vm.chartData = {
                completed: completedTasks.length,
                planned: vm.taskWithTags.length - completedTasks.length
            };
            vm.progress = calculateProgress(completedTasks.length, vm.taskWithTags.length);
            vm.gridOptions = createGridOptions(vm.taskWithTags);
        }

        function isTask(entity) {
            return !('xlrelease.Release' === entity.type || 'xlrelease.Phase' === entity.type);
        }

        function calculateCompletedTasks(tasks) {
            return _.filter(tasks, TasksService.isTaskReadOnly);
        }

        function calculateProgress(completed, total) {
            var progress = 0;
            if (angular.isNumber(completed) && angular.isNumber(total) && total != 0) {
                progress = completed/total * 100;
            }
            return progress;
        }

        function getTaskWithTags(tags) {
            return ReleaseGridService.getGridItems(vm.release).filter(isTask).filter (function (task) {
                var taskWithTag = false;
                tags.value.forEach(function (tag) {
                    if (task.planItem.tags.indexOf(tag) > -1) {taskWithTag = true;}
                });
                return taskWithTag;
            });
        }

        function createGridOptions(tasks) {
            var dateFilter = 'mediumDateShortTime';
            var columnDefs = [
                {
                    displayName: "Name",
                    field: "title",
                    filterHeaderTemplate: "<div data-ng-include=\"'partials/releases/grid/templates/name-filter-template.html'\"></div>",
                    enableColumnMenu: false,
                    width: '30%'
                },
                {
                    displayName: "Status",
                    field: "status",
                    cellTemplate: "static/@project.version@/include/TaskProgressTile/grid/status-cell-template.html",
                    enableColumnMenu: false,
                    width: '10%'
                },
                {
                    displayName: "Start Date",
                    field: "startDate",
                    cellFilter: dateFilter,
                    filterHeaderTemplate: "<div ng-include=\"'partials/releases/grid/templates/date-filter-template.html'\"></div>",
                    enableFiltering: true,
                    enableColumnMenu: false,
                    width: '10%',
                    filter: {
                        placeholder: 'From:',
                        condition: function (searchTerm, cellValue) {
                            moment(cellValue).isAfter(moment(searchTerm).startOf('day'));
                        }
                    }
                },
                {
                    displayName: "End Date",
                    field: "endDate",
                    cellFilter: dateFilter,
                    filterHeaderTemplate: "<div ng-include=\"'partials/releases/grid/templates/date-filter-template.html'\"></div>",
                    enableColumnMenu: false,
                    enableFiltering: true,
                    filter: {
                        placeholder: 'To:',
                        condition: function (searchTerm, cellValue) {
                            moment(cellValue).isBefore(moment(searchTerm).endOf('day'))
                        }
                    },
                    width: '10%'
                },
                {
                    displayName: "Duration",
                    field: "duration",
                    enableColumnMenu: false,
                    filterCellFiltered: true,
                    cellFilter: 'prettyDuration',
                    width: '10%'
                },
                {
                    displayName: "Assigned To",
                    field: "assignedTo",
                    cellTemplate: "static/@project.version@/include/TaskProgressTile/grid/assigned-to-cell-template.html",
                    enableColumnMenu: false,
                    width: '12%'
                },
                {
                    displayName: "Tags",
                    field: "tags",
                    cellTemplate: "static/@project.version@/include/TaskProgressTile/grid/tags-cell-template.html",
                    enableColumnMenu: false,
                    width: '17%'
                }
            ];

            return XlrTileHelper.getGridOptions(tasks, columnDefs);
        }

        vm.refresh = refresh;
    };
    var injectParams = ['$scope','XlrTileHelper', 'TasksService', 'ReleaseGridService'];
    TaskProgressTileViewController.$inject = injectParams;
    angular.module('xlrelease.taskprogress.tile', []);
    angular.module('xlrelease.taskprogress.tile').controller('xlrelease.TaskProgressTileViewController', TaskProgressTileViewController);

})();

