/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.jayway.jsonpath.internal.filter;

import java.util.List;
import java.util.regex.Pattern;
import wiremock.com.jayway.jsonpath.internal.filter.PathTokenFilter;
import wiremock.com.jayway.jsonpath.spi.JsonProvider;

public class ArrayIndexFilter
extends PathTokenFilter {
    private static final Pattern SINGLE_ARRAY_INDEX_PATTERN = Pattern.compile("\\[\\d+\\]");

    public ArrayIndexFilter(String condition) {
        super(condition);
    }

    @Override
    public Object filter(Object obj, JsonProvider jsonProvider) {
        List<Object> src = jsonProvider.toList(obj);
        List<Object> result = jsonProvider.createList();
        String trimmedCondition = this.trim(this.condition, 1, 1);
        if (trimmedCondition.contains("@.length")) {
            trimmedCondition = this.trim(trimmedCondition, 1, 1);
            trimmedCondition = trimmedCondition.replace("@.length", "");
            trimmedCondition = trimmedCondition + ":";
        }
        if (trimmedCondition.startsWith(":")) {
            trimmedCondition = this.trim(trimmedCondition, 1, 0);
            int get = Integer.parseInt(trimmedCondition);
            for (int i = 0; i < get; ++i) {
                result.add(src.get(i));
            }
            return result;
        }
        if (trimmedCondition.endsWith(":")) {
            trimmedCondition = this.trim(trimmedCondition.replace(" ", ""), 1, 1);
            int get = Integer.parseInt(trimmedCondition);
            return src.get(src.size() - get);
        }
        String[] indexArr = trimmedCondition.split(",");
        if (src.isEmpty()) {
            return result;
        }
        if (indexArr.length == 1) {
            return src.get(Integer.parseInt(indexArr[0]));
        }
        for (String idx : indexArr) {
            result.add(src.get(Integer.parseInt(idx.trim())));
        }
        return result;
    }

    @Override
    public Object getRef(Object obj, JsonProvider jsonProvider) {
        if (SINGLE_ARRAY_INDEX_PATTERN.matcher(this.condition).matches()) {
            String trimmedCondition = this.trim(this.condition, 1, 1);
            List<Object> src = jsonProvider.toList(obj);
            return src.get(Integer.parseInt(trimmedCondition));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isArrayFilter() {
        return true;
    }
}

