import java.io.IOException as IOException
import sys
import os
import xldeploy
import requests
from urlparse import urlparse
from xlrxldeploy.ControlTaskRunner import ControlTaskRunner
from xldeploy.domain.QueryBuilder import QueryBuilder
from xml.etree import ElementTree
from xldeploy.errors import XLDeployException
from xldeploy.errors import XLDeployConnectionError
from xldeploy.errors import XLDeployConnectionTimeout
from xldeploy.errors import APIError
import tempfile
import urllib2

from com.xebialabs.xlr.ssl import LoaderUtil
from java.nio.file import Files, Paths, StandardCopyOption




def start_deployment(task, script_path):
    return _start_deployment(task, script_path)

def start_undeployment(task, script_path):
    return _start_undeployment(task, script_path)


def start_rollback(task, script_path):
    client = get_api_client(task.getPythonScript().getProperty("server"), task)
    xld_task_id = task.getPythonScript().getProperty("xlDeployTaskId")
    xld_rollback_task = xld_exception_decorator(client.deployment.rollback, xld_task_id)

    task.setStatusLine("Deployment rollback triggered")
    task.schedule(script_path, 2)
    return xld_rollback_task.task_id

def _start_undeployment(task, script_path):
    try:
        xld_task_id = prepare_undeployment(task)
        task.setStatusLine("Waiting")
        task.schedule(script_path, 2)
        return xld_task_id
    except:
        raise Exception("Undeployment of task: '%s' failed : [%s]\n" % (task, sys.exc_info()))

def _start_deployment(task, script_path):
    try:
        xld_task_id = prepare_deployment(task)
        task.setStatusLine("Waiting")
        task.schedule(script_path, 2)
        return xld_task_id
    except:
        raise Exception("Deployment of task: '%s' failed : [%s]\n" % (task, sys.exc_info()))


def check_status(task, script_path, server_url, connection_failures, process_deployment):
    try:
        xld_task_id = task.getPythonScript().getProperty("xlDeployTaskId")
        task_with_steps = check_deployment_status(task, xld_task_id)

        if connection_failures > 0:
            connection_failures = 0
            print "Connection to XL Deploy '%s' is back.\n" % server_url
        task_state = task_with_steps['state']
        if task_state == "EXECUTING":
            current_and_total_steps = get_steps_count_from_xl_deploy(task.getPythonScript().getProperty("server"), task)
            task.setStatusLine(
                    "Executing step %s/%s" % (current_and_total_steps['currentStep'], current_and_total_steps['totalSteps']))

        task.schedule(script_path, 2)
        process_deployment(task_state)

    except IOException as e:
        connection_failures += 1
        if connection_failures > 5:
            raise Exception("Failed to update task status after 6 attempts: %s\n" % e)
        else:
            print "Failed to connect to XL Deploy, will retry in 60 seconds: %s\n" % e
            task.schedule(script_path, 60)

    return connection_failures

def get_client_config(xld_server, task):
    xld_url = urlparse(xld_server.url)
    xld_protocol = xld_url.scheme
    xld_port = xld_url.port
    xld_host = xld_url.hostname
    username = None
    password = None
    if task is not None:
        username = task.getPythonScript().getProperty("username")
        password = task.getPythonScript().getProperty("password")

    xld_username = username if username else xld_server.username
    xld_password = password if password else xld_server.password

    if xld_server.proxyHost and xld_server.proxyPort:
        config = xldeploy.Config(protocol=xld_protocol, host=xld_host, port=xld_port, username=xld_username,
                                 password=xld_password, proxy_host=xld_server.proxyHost,
                                 proxy_port=xld_server.proxyPort,
                                 proxy_username=xld_server.proxyUsername, proxy_password=xld_server.proxyPassword, verify_ssl=xld_server.getProperty('verifySSL'))
    else:
        config = xldeploy.Config(protocol=xld_protocol, host=xld_host, port=xld_port, username=xld_username,
                                 password=xld_password, verify_ssl=xld_server.getProperty('verifySSL'))
    return config

def get_api_client(xld_server, task=None):
    config = get_client_config(xld_server, task)
    return xldeploy.Client(config)

def query_xld_repository(repository_service, request, params):
    xld_server = repository_service.read(request.query['serverId'])
    task = repository_service.read('Applications/' + request.query['taskId'].replace('-', '/'))
    client = get_api_client(xld_server, task)
    try:
        result = client.repository.query(params)
    except:
        result = []
    return result


def prepare_deployment(task):
    ensure_deployment_properties_filled(task)

    package_id = "Applications/" + task.getPythonScript().getProperty("deploymentPackage")
    environment_id = "Environments/" + task.getPythonScript().getProperty("deploymentEnvironment")

    client = get_api_client(task.getPythonScript().getProperty("server"), task)
    try:
        application_name = package_id.split("/") [-2]
        if not application_already_deployed(client, package_id, environment_id):
            deployment = client.deployment.prepare_initial(package_id, environment_id)
            print "Prepared Initial Deployment.\n"
        else:
            deployment = client.deployment.prepare_update(package_id, environment_id + '/' + application_name)
            print "Prepared Update Deployment.\n"

        deployment = client.deployment.prepare_auto_deployeds(deployment)
        valid_deployment = client.deployment.validate(deployment)

        if check_for_validation_messages(deployment) or check_for_validation_messages(valid_deployment):
            sys.exit(1)
        xld_task = client.deployment.create_task(deployment)
        print "Created Deployment Task: %s.\n" % xld_task.task_id
    except Exception as e:
        catch_and_log_xld_exception(e)

    task.getPythonScript().setProperty("xlDeployTaskId", xld_task.task_id)
    return xld_task.task_id

def prepare_undeployment(task):
    ensure_undeployment_properties_filled(task)

    deployed_application_id = task.getPythonScript().getProperty("deployedApplication")

    client = get_api_client(task.getPythonScript().getProperty("server"), task)

    deployment = client.deployment.prepare_undeploy(deployed_application_id)
    xld_task = client.deployment.create_task(deployment)
    print "Created undeployment Task: %s\n" % xld_task.task_id

    task.getPythonScript().setProperty("xlDeployTaskId", xld_task.task_id)
    return xld_task.task_id

def ensure_deployment_properties_filled(task):
    if not task.getPythonScript().getProperty("server") or not task.getPythonScript().getProperty(
            "deploymentPackage") or not task.getPythonScript().getProperty("deploymentEnvironment"):
        raise Exception("Deployment package or environment is missing")

def ensure_undeployment_properties_filled(task):
    if not task.getPythonScript().getProperty("server") or not task.getPythonScript().getProperty(
            "deployedApplication"):
        raise Exception("Deployed application or server is missing")


def application_already_deployed(client, package_id, environment_id):
    application_name = package_id.split("/") [-2]
    query_params = QueryBuilder().type("udm.DeployedApplication").parent(environment_id).name_pattern(application_name).result_per_page(-1).build()
    application_list = xld_exception_decorator(client.repository.query, query_params)
    return application_list


def check_deployment_status(task, xld_task_id):
    client = get_api_client(task.getPythonScript().getProperty("server"), task)
    xld_task = xld_exception_decorator(client.tasks.get_task, xld_task_id)
    start_or_archive_task(xld_task['state'], task, xld_task_id)
    return xld_task


def start_or_archive_task(task_state, task, xld_task_id):
    client = get_api_client(task.getPythonScript().getProperty("server"), task)
    if task_state.lower() == "pending":
        xld_exception_decorator(client.tasks.start, xld_task_id)
        print "Started XL Deploy Task: %s\n" % xld_task_id
    elif task_state.lower() == "executed":
        xld_exception_decorator(client.tasks.archive, xld_task_id)
        print "Archived XL Deploy Task: %s\n" % xld_task_id



def get_steps_count_from_xl_deploy(server_id, task):
    xld_task_id = task.getPythonScript().getProperty("xlDeployTaskId")
    xld_config = get_client_config(server_id, task)
    path = "/task/%s/step" % xld_task_id
    proxies = None
    if xld_config.proxy_host and xld_config.proxy_port:
        proxies = get_proxies(xld_config)
    response = requests.get(get_xldeploy_url(xld_config,path=path), auth=(xld_config.username, xld_config.password), headers=get_xml_headers(), proxies=proxies, verify=xld_config.verify_ssl)

    tree = ElementTree.fromstring(response.text)
    current_step = tree.find('currentSteps').find('current').text
    total_step = len(tree.find('steps'))
    current_and_total_steps = {"currentStep": current_step, "totalSteps": total_step}
    return current_and_total_steps

def get_proxies(config):
    proxies = None
    if config.proxy_host and config.proxy_port:
        if config.proxy_username and config.proxy_password:
            proxy_host_url = urlparse(config.proxy_host)
            proxy_username = urllib2.quote(config.proxy_username, safe='')
            proxy_password = urllib2.quote(config.proxy_password, safe='')

            proxy_url = "%s://%s:%s@%s:%s" % (proxy_host_url.scheme, proxy_username, proxy_password
                                              ,proxy_host_url.hostname , config.proxy_port)
        else:
            proxy_url = "%s:%s" % (config.proxy_host, config.proxy_port)

        proxies = {'http': proxy_url,
                   'https': proxy_url}
    return proxies

def start_control_task(task, script_path):
    try:
        config = get_client_config(task.getPythonScript().getProperty("server"), task)

        control_task_runner = ControlTaskRunner(config)
        task_id = control_task_runner.prepare_control_task(task.getPythonScript().getProperty("taskName"), task.getPythonScript().getProperty("ciId"))
        task.getPythonScript().setProperty("xlDeployTaskId", task_id)
        task.setStatusLine("Waiting")
        task.schedule(script_path, 2)
        return task_id
    except:
        raise Exception("Deployment of task: '%s' failed : [%s]\n" % (task, sys.exc_info()))


def check_for_validation_messages(deployment):
    validation_messages_exists = False
    for deployed in deployment.deployeds:
        if 'validation-messages' in deployed:
            print "Validation errors :\n"
            for message in deployed['validation-messages']:
                print "%s : %s, for property %s in CI %s.\n" % (message['level'], message['message'], message['property'], message['ci'])
                validation_messages_exists = True
    return validation_messages_exists


def catch_and_log_xld_exception(e):
    if isinstance(e, XLDeployConnectionError):
        print "Connection error : %s.\n" % e.message
        sys.exit(1)
    elif isinstance(e, XLDeployConnectionTimeout):
        print "Connection to XL Deploy has been timed out.\n %s" % e.message
        sys.exit(1)
    elif isinstance(e, XLDeployException):
        message = e.explanation if e.explanation else e.message
        log_error_message(str(message))
        print "Deployment Failed, please check the logs.\n"
        sys.exit(1)
    else:
        raise e


def log_error_message(message):
    if 'Unauthorized for url:' in message:
        print "Authentication Error : Wrong credentials for XLD server.\n"
    elif 'Illegal name:' in message:
        print "Incorrect application name: %s.\n" % message[message.find(':')+1:]
    elif 'Repository entity' in message and 'not found' in message:
        print "Invalid Package / Environment name: %s.\n" % message[message.find('[')+1:message.find(']')]
    else:
        print "XL Deploy error: %s.\n" % message


def xld_exception_decorator(function, *args):
    try:
        return function(*args)
    except Exception as e:
        catch_and_log_xld_exception(e)


def set_ca_bundle_path():
    ca_bundle_path = extract_file_from_jar("requests/cacert.pem")
    os.environ['REQUESTS_CA_BUNDLE'] = ca_bundle_path


def extract_file_from_jar(config_file):
    file_url = LoaderUtil.getResourceBySelfClassLoader(config_file)
    if file_url:
        tmp_file, tmp_abs_path = tempfile.mkstemp()
        tmp_file.close()
        Files.copy(file_url.openStream(), Paths.get(tmp_abs_path), StandardCopyOption.REPLACE_EXISTING)
        return tmp_abs_path
    else:
        return None

if 'REQUESTS_CA_BUNDLE' not in os.environ:
    set_ca_bundle_path()

def get_xldeploy_url(config, path):
    return "%s://%s:%s/%s%s" % (config.protocol, config.host, config.port, config.context_path, path)

def get_xml_headers():
    return {'content-type': 'application/xml', 'Accept': 'application/xml'}
