from xlrxldeploy import check_status
from xlrxldeploy import print_step_errors

def process(task_state):
    if task_state in ["EXECUTED", "DONE"]:
        task.setStatusLine('Executed')
        print "Completed XL Deploy Task: '%s' State: '%s'\n" % (xlDeployTaskId, task_state)
        task.schedule(None)  # as the schedule is set in check_status

    if task_state in ["STOPPED", "CANCELLED", "FAILED"]:
        print "Failed XL Deploy Task: '%s' State: '%s'\n" % (xlDeployTaskId, task_state)
        print_step_errors(task)
        rollbackOnFailure = task.getPythonScript().getProperty("rollbackOnFailure")
        if rollbackOnFailure:
            print "Starting rollback on failure.\n"
            task.schedule("xlrxldeploy/DeployRollback.py", 2)
        else:
            sys.exit(1)

connectionFailureCount = check_status(task, "xlrxldeploy/CheckUndeploymentStatus.py", server['url'], connectionFailureCount, process)
