/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 2);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


(function () {

    var XLDVersionsTileViewController = function XLDVersionsTileViewController($scope, XLDVersionsService, XlrTileHelper) {
        var vm = this;
        var tile;

        if ($scope.xlrTile) {
            // summary mode
            tile = $scope.xlrTile.tile;
        } else {
            // details mode
            tile = $scope.xlrTileDetailsCtrl.tile;
        }

        function tileConfigurationIsPopulated() {
            var config;
            // old style pre 7.0
            if (tile.properties == null) {
                config = tile.configurationProperties;
            } else {
                // new style since 7.0
                config = tile.properties;
            }
            return !_.isEmpty(config.xldeployServer) && !_.isEmpty(config.environment);
        }

        function getColor(value) {
            if (predefinedColors[value]) return predefinedColors[value];
            return colorPool.pop();
        }

        function getTitle() {
            if (vm.issuesSummaryData.total > 1) {
                return "tickets";
            } else {
                return "ticket";
            }
        }

        vm.chartOptions = {
            topTitleText: function topTitleText(data) {
                return data.total;
            },
            bottomTitleText: getTitle,
            series: function series(data) {
                var series = {
                    name: 'State',
                    data: []
                };
                series.data = _.map(data.data, function (value) {
                    return { y: value.counter, name: value.state, color: value.color };
                });
                return [series];
            },
            showLegend: false,
            donutThickness: '60%'
        };

        function load(config) {
            if (tileConfigurationIsPopulated()) {
                vm.loading = true;
                XLDVersionsService.executeQuery(tile.id, config).then(function (response) {
                    var versions = response.data.data;
                    if (versions[0] === "Invalid environment name") {
                        vm.invalidEnvironment = true;
                    } else {
                        var xldeployData = [];
                        vm.invalidEnvironment = false;
                        for (var app in versions) {
                            xldeployData.push(versions[app]);
                        }
                        vm.deployedAppsCounter = xldeployData.length;
                        vm.summaryGridOptions = createSummaryGridOptions(xldeployData);
                    }
                }).finally(function () {
                    vm.loading = false;
                });
            }
        }

        function createSummaryGridOptions(xldeployData) {
            var columnDefs = [{
                displayName: "Application",
                field: "application",
                cellTemplate: "static/@project.version@/include/xldeploy/VersionTile/grid/application.html",
                filterHeaderTemplate: "static/@project.version@/include/xldeploy/VersionTile/grid/name-filter-template.html",
                enableColumnMenu: false,
                width: '50%'
            }, {
                displayName: "Version",
                field: "version",
                cellTemplate: "static/@project.version@/include/xldeploy/VersionTile/grid/version.html",
                filterHeaderTemplate: "static/@project.version@/include/xldeploy/VersionTile/grid/name-filter-template.html",
                enableColumnMenu: false,
                width: '50%'
            }];
            return XlrTileHelper.getGridOptions(xldeployData, columnDefs);
        }

        function refresh() {
            load({ params: { refresh: true } });
        }

        load();

        vm.refresh = refresh;
    };

    XLDVersionsTileViewController.$inject = ['$scope', 'xlrelease.xldeploy.XLDVersionsService', 'XlrTileHelper'];

    var XLDVersionsService = function XLDVersionsService(Backend) {

        function executeQuery(tileId, config) {
            return Backend.get("/tiles/" + tileId + "/data", config);
        }
        return {
            executeQuery: executeQuery
        };
    };

    XLDVersionsService.$inject = ['Backend'];

    angular.module('xlrelease.XLDVersion.tile', []);
    angular.module('xlrelease.XLDVersion.tile').service('xlrelease.xldeploy.XLDVersionsService', XLDVersionsService);
    angular.module('xlrelease.XLDVersion.tile').controller('xldeploy.XLDVersionsTileViewController', XLDVersionsTileViewController);
})();

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(6);

var _xlDeployTaskDetailsController = __webpack_require__(4);

var _xlDeployTaskDetailsController2 = _interopRequireDefault(_xlDeployTaskDetailsController);

var _xlDeployTile = __webpack_require__(5);

var _xlDeployTile2 = _interopRequireDefault(_xlDeployTile);

var _inlineDynamicTextEditor = __webpack_require__(3);

var _inlineDynamicTextEditor2 = _interopRequireDefault(_inlineDynamicTextEditor);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var _module = angular.module('xlrelease.xldeploy', []);

_xlDeployTaskDetailsController2.default.$inject = ['$scope', 'Backend', 'TasksService', 'Ids'];
_xlDeployTile2.default.$inject = ['$scope', 'ReleasesService', 'XlrTileHelper', 'ConfigurationInstances'];

_module.controller('xlrelease.xldeploy.XLDeployTaskDetailsController', _xlDeployTaskDetailsController2.default);
_module.controller('xlrelease.xldeploy.XLDeployTileController', _xlDeployTile2.default);
_module.directive('inlineDynamicTextEditor', ['inlineEditorV2', function (inlineEditorV2) {
  return (0, _inlineDynamicTextEditor2.default)(inlineEditorV2);
}]);

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(1);

__webpack_require__(0);

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = inlineDynamicTextEditor;

__webpack_require__(7);

var typeMoreHintFinder1 = 'Please type ';
var typeMoreHint2 = ' or more characters.';
var noResultsMessage = 'No results';

function inlineDynamicTextEditor(inlineEditor) {
    var dynamicTextEditor = inlineEditor.directive('text-field.html', {
        renderAutocompleteItem: function renderAutocompleteItem(ul, item) {
            if (item.value == '--more--') {
                return $('<li class="ui-menu-item disabled"></li>').data("item.autocomplete", item).append('<span>' + item.value + '</span>').appendTo(ul);
            } else if (item.value.startsWith(typeMoreHintFinder1) || item.value === noResultsMessage) {
                // not clickable
                return $('<li class="ui-menu-item disabled-black ui-state-disabled"></li>').data("item.autocomplete", item).append('<span>' + item.value + '</span>').appendTo(ul);
            } else {
                return $("<li></li>").data("item.autocomplete", item).append("<a>" + item.value + "</a>").appendTo(ul);
            }
        }
    });

    return _.extend({}, dynamicTextEditor, {
        scope: _.extend({}, dynamicTextEditor.scope, { lookupItems: '&', lookupTriggerCount: '=' }),
        link: function link(scope, element, attrs) {
            var editable = element.find('.editable');
            scope.lastTerm = null;
            scope.page = 0;

            // do query a certain delay after typing.
            scope.autocompleteDelay = 200;

            // search from server for results.
            scope.autocompleteCallback = function (request, response) {

                // on term change always reset page num (if same term leave it alone, might be page advance search)
                if (scope.lastTerm != request.term) {
                    scope.page = 0;
                    scope.lastTerm = request.term;
                }
                // when length long enough conduct search.
                if (request.term.length >= scope.lookupTriggerCount) {
                    // set the new data in the control based on backend call
                    scope.lookupItems({ term: request.term, page: scope.page, callback: function callback(data) {
                            if (data.length === 0) {
                                response([noResultsMessage]);
                            } else {
                                response(data);
                            }
                        } });
                } else {
                    if (scope.lookupTriggerCount > 0) {
                        response([typeMoreHintFinder1 + ('' + scope.lookupTriggerCount) + typeMoreHint2]);
                    } else {
                        // clear/hide results
                        response(null);
                    }
                }
            };

            // dont allow --more-- as value
            scope.validate = function (payload) {
                if (payload.draft !== null && (payload.draft == '--more--' || payload.draft.startsWith(typeMoreHintFinder1) || payload.draft === noResultsMessage)) {
                    // Reverting to original value
                    scope.draft = scope.model;
                    return false;
                }
                return true;
            };

            // on change field always clear page count to avoid seeing it sometimes when you type same query.
            editable.on("blur", function (event, ui) {
                scope.page = 0;
            });
            // show results for next page on --more-- 
            editable.on("autocompleteselect", function (event, ui) {
                if (ui.item.label == '--more--') {
                    // next page
                    scope.page += 1;
                    // put event on end of the queue so search opens properly.
                    // next page with existing term
                    setTimeout(function () {
                        return editable.autocomplete('search', scope.lastTerm);
                    }, 0);
                } else if (ui.item.label.startsWith(typeMoreHintFinder1) || ui.item.label === noResultsMessage) {
                    return false;
                }
            });

            dynamicTextEditor.link(scope, element, attrs);
        }
    });
}

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var noServerSelected = 'No server selected';
var noServerSelectedOrNoApplication = 'No server selected or no application chosen.';

var XLDeployTaskDetailsController = function () {
    function XLDeployTaskDetailsController($scope, Backend, TasksService, Ids) {
        _classCallCheck(this, XLDeployTaskDetailsController);

        this._$scope = $scope;

        this._Backend = Backend;
        this._TasksService = TasksService;
        this._Ids = Ids;

        this._xldApplications = [];
        this._xldVersions = [];
        this._xldEnvironments = [];
        this._xldDeployeds = [];
        this._xldInfrastructureIds = [];
        this._status = true;
    }

    _createClass(XLDeployTaskDetailsController, [{
        key: '$onInit',
        value: function $onInit() {
            this._ConfigurationInstances = this._$scope.ConfigurationInstances;

            var task = this._$scope.task;
            // Backward compatibility
            if (task.inputProperties.deploymentPackage && !this._isPlaceholder(task.inputProperties.deploymentPackage)) {
                var index = task.inputProperties.deploymentPackage.lastIndexOf("/");
                var prefix = "";
                if (!task.inputProperties.deploymentPackage.startsWith("Applications/")) {
                    prefix = "Applications/";
                }
                task.inputProperties.deploymentApplication = prefix + task.inputProperties.deploymentPackage.substring(0, index);
                task.inputProperties.deploymentVersion = task.inputProperties.deploymentPackage.substring(index + 1);
            }
        }
    }, {
        key: '_isPlaceholder',
        value: function _isPlaceholder(value) {
            return value && value.indexOf("{") >= 0 && value.indexOf("}") >= 0;
        }
    }, {
        key: 'applicationChanged',
        value: function applicationChanged(task, callback) {
            this.resetPackage(task);
            this._$scope.saveTask(task, callback);
        }
    }, {
        key: 'versionChanged',
        value: function versionChanged(task, callback) {
            this.resetPackage(task);
            this._$scope.saveTask(task, callback);
        }
    }, {
        key: 'resetPackage',
        value: function resetPackage(task) {
            if (task.inputProperties.deploymentApplication && task.inputProperties.deploymentVersion) {
                task.inputProperties.deploymentPackage = task.inputProperties.deploymentApplication + "/" + task.inputProperties.deploymentVersion;
            }
        }
    }, {
        key: 'lookupDeployeds',
        value: function lookupDeployeds(term, page, callback) {
            var _this = this;

            this._xldDeployeds.length = 0;
            var task = this._$scope.task;

            if (task.inputProperties.server) {
                var serverId = this._Ids.toConfigurationId(task.inputProperties.server);
                var params = { taskId: task.id, serverId: serverId, idPattern: term, page: page };
                this._Backend.get('api/extension/deployeds', { params: params }).then(function (response) {
                    _this._xldDeployeds = response.data.entity;
                    callback(_this._xldDeployeds);
                });
            } else {
                callback([noServerSelected]);
            }
        }
    }, {
        key: 'lookupInfrastructures',
        value: function lookupInfrastructures(term, page, callback) {
            var _this2 = this;

            this._xldInfrastructureIds.length = 0;
            var task = this._$scope.task;

            if (task.inputProperties.server) {
                var serverId = this._Ids.toConfigurationId(task.inputProperties.server);
                var params = { taskId: task.id, serverId: serverId, idPattern: term, page: page };
                this._Backend.get('api/extension/infrastructures', { params: params }).then(function (response) {
                    _this2._xldInfrastructureIds = response.data.entity;
                    callback(_this2._xldInfrastructureIds);
                });
            } else {
                callback([noServerSelected]);
            }
        }
    }, {
        key: 'lookupEnvironments',
        value: function lookupEnvironments(term, page, callback) {
            var _this3 = this;

            this._xldEnvironments.length = 0;
            var task = this._$scope.task;

            if (task.inputProperties.server) {
                var serverId = this._Ids.toConfigurationId(task.inputProperties.server);
                var params = { taskId: task.id, serverId: serverId, idPattern: term, page: page };
                this._Backend.get('api/extension/environments', { params: params }).then(function (response) {
                    _this3._xldEnvironments = response.data.entity;
                    callback(_this3._xldEnvironments);
                });
            } else {
                callback([noServerSelected]);
            }
        }
    }, {
        key: 'lookupApplications',
        value: function lookupApplications(term, page, callback) {
            var _this4 = this;

            this._xldApplications.length = 0;
            var task = this._$scope.task;

            if (task.inputProperties.server) {
                var serverId = this._Ids.toConfigurationId(task.inputProperties.server);
                var params = { taskId: task.id, serverId: serverId, idPattern: term, page: page };
                this._Backend.get('api/extension/applications', { params: params }).then(function (response) {
                    _this4._xldApplications = response.data.entity;
                    callback(_this4._xldApplications);
                });
            } else {
                callback([noServerSelected]);
            }
        }
    }, {
        key: 'lookupVersions',
        value: function lookupVersions(term, page, callback) {
            var _this5 = this;

            this._xldVersions.length = 0;
            var task = this._$scope.task;

            if (task.inputProperties.server && task.inputProperties.deploymentApplication) {
                var serverId = this._Ids.toConfigurationId(task.inputProperties.server);
                var params = { taskId: task.id, serverId: serverId, namePattern: term, page: page, parent: task.inputProperties.deploymentApplication };
                this._Backend.get('api/extension/versions', { params: params }).then(function (response) {
                    _this5._xldVersions = response.data.entity;
                    callback(_this5._xldVersions);
                });
            } else {
                callback([noServerSelectedOrNoApplication]);
            }
        }
    }, {
        key: 'status',
        get: function get() {
            return this._status;
        },
        set: function set(value) {
            this._status = value;
        }
    }, {
        key: 'areTaskPropertiesReadonlyOrLocked',
        get: function get() {
            return this._TasksService.areTaskPropertiesReadonly(this._$scope.release, this._$scope.task) || this._TasksService.isLocked(this._$scope.task);
        }
    }, {
        key: 'xldApplications',
        get: function get() {
            return this._xldApplications;
        }
    }, {
        key: 'xldVersions',
        get: function get() {
            return this._xldVersions;
        }
    }, {
        key: 'xldDeployeds',
        get: function get() {
            return this._xldDeployeds;
        }
    }, {
        key: 'xldInfrastructureIds',
        get: function get() {
            return this._xldInfrastructureIds;
        }
    }, {
        key: 'xldEnvironments',
        get: function get() {
            return this._xldEnvironments;
        }
    }, {
        key: 'configurationInstances',
        get: function get() {
            return this._ConfigurationInstances;
        }
    }, {
        key: 'properties',
        get: function get() {
            return XLDeployTaskDetailsController._mapPropertyDefinitions(this._$scope.scriptDefinition);
        }
    }], [{
        key: '_mapPropertyDefinitions',
        value: function _mapPropertyDefinitions(taskDefinition) {
            if (!taskDefinition) {
                return {};
            }
            return taskDefinition.outputProperties.concat(taskDefinition.inputProperties).reduce(function (propertiesMap, property) {
                propertiesMap[property.name] = property;
                return propertiesMap;
            }, {});
        }
    }]);

    return XLDeployTaskDetailsController;
}();

exports.default = XLDeployTaskDetailsController;

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var XLDeployTileController = function () {
    function XLDeployTileController($scope, ReleasesService, XlrTileHelper, ConfigurationInstances) {
        _classCallCheck(this, XLDeployTileController);

        this._ConfigurationInstances = ConfigurationInstances;
        this._ReleasesService = ReleasesService;
        this._XlrTileHelper = XlrTileHelper;

        if ($scope.xlrDashboard) {
            // summary page
            this._release = $scope.xlrDashboard.release;
        } else {
            // details page
            this._release = $scope.xlrTileDetailsCtrl.release;
        }
    }

    _createClass(XLDeployTileController, [{
        key: '$onInit',
        value: function $onInit() {
            this._loadXldServersAndSetupData();
        }
    }, {
        key: '$onDestroy',
        value: function $onDestroy() {
            this._ConfigurationInstances.reset();
        }
    }, {
        key: '_loadXldServersAndSetupData',
        value: function _loadXldServersAndSetupData() {
            var _this = this;

            this._ConfigurationInstances.load().then(function () {
                var xldServers = _this._ConfigurationInstances.getInstancesByType('xldeploy.XLDeployServer');

                _this._allXLDeployTasks = _this._getAllXLDeployTasks(_this._release, xldServers);
                _this._counts = _this._XlrTileHelper.countTasksByStatus(_this._allXLDeployTasks);
                _this._totalCount = _this._allXLDeployTasks.length;
                _this._gridOptions = _this._getGridOptions(_this._allXLDeployTasks);

                _this._chartOptions = _this._XlrTileHelper.getChartOptions({
                    label: 'Deployment',
                    total: _this._totalCount
                });
            });
        }
    }, {
        key: '_getAllXLDeployTasks',
        value: function _getAllXLDeployTasks(release, xldServers) {
            var _this2 = this;

            return _(this._ReleasesService.getLeafTasks(release)).filter({ scriptDefinitionType: 'xldeploy.Deploy' }).map(function (task) {
                return {
                    taskName: task.title,
                    taskId: task.outputProperties.xlDeployTaskId ? task.outputProperties.xlDeployTaskId.value : undefined,
                    taskPackage: task.inputProperties.deploymentPackage,
                    taskEnvironment: task.inputProperties.deploymentEnvironment,
                    taskStatus: task.status,
                    taskStatusCategory: _this2._XlrTileHelper.getCategoryByTaskStatus(task.status),
                    xldUrl: XLDeployTileController._getXldUrl(xldServers, task.inputProperties.server)
                };
            }).value();
        }
    }, {
        key: '_getGridOptions',
        value: function _getGridOptions(allXLDeployTasks) {
            var columnDefs = [{
                displayName: "Task",
                field: "taskName",
                cellTemplate: "static/@project.version@/include/xldeploy/DeployTile/grid/deployment-name-cell-template.html",
                filterHeaderTemplate: "<div data-ng-include=\"'static/@project.version@/include/xldeploy/DeployTile/grid/name-filter-tpl.html'\"></div>",
                enableColumnMenu: false,
                width: '30%'
            }, {
                displayName: "Package",
                field: "taskPackage",
                enableColumnMenu: false,
                width: '20%'
            }, {
                displayName: "Environment",
                field: "taskEnvironment",
                enableColumnMenu: false,
                width: '20%'
            }, {
                displayName: "Status",
                field: "taskStatusCategory",
                cellTemplate: "static/@project.version@/include/xldeploy/DeployTile/grid/deployment-status-cell-template.html",
                filterHeaderTemplate: "<div data-ng-include=\"'static/@project.version@/include/xldeploy/DeployTile/grid/name-filter-tpl.html'\"></div>",
                enableColumnMenu: false,
                width: '10%'
            }, {
                displayName: "XL Deploy task ID",
                field: "taskId",
                cellTemplate: "static/@project.version@/include/xldeploy/DeployTile/grid/deployment-task-id-cell-template.html",
                filterHeaderTemplate: "<div data-ng-include=\"'static/@project.version@/include/xldeploy/DeployTile/grid/name-filter-tpl.html'\"></div>",
                enableColumnMenu: false,
                width: '20%'
            }];
            return this._XlrTileHelper.getGridOptions(allXLDeployTasks, columnDefs);
        }
    }, {
        key: 'release',
        get: function get() {
            return this._release;
        }
    }, {
        key: 'counts',
        get: function get() {
            return this._counts;
        }
    }, {
        key: 'totalCount',
        get: function get() {
            return this._totalCount;
        }
    }, {
        key: 'gridOptions',
        get: function get() {
            return this._gridOptions;
        }
    }, {
        key: 'chartOptions',
        get: function get() {
            return this._chartOptions;
        }
    }], [{
        key: '_getXldUrl',
        value: function _getXldUrl(xldServers, serverId) {
            var server = _.find(xldServers, { 'id': serverId });
            return server ? server.url : null;
        }
    }]);

    return XLDeployTileController;
}();

exports.default = XLDeployTileController;

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/** 
 * This is somewhat copied from xl-release/core/xlr-ui/app/js/directives/inline-editor-directive.js, but just the factory.
 *
 * New and improved auto-completeable inline text field. Directive factory. Properly implements autocomplete with
 * overrideable lookup function and lookup delay.
 */
angular.module('xlrelease').factory('inlineEditorV2', ['Doc', function (Doc) {
    var leaveEditMode = function leaveEditMode(scope, editable, refocus) {
        scope.editMode = false;
        scope.enableAutoComplete = false;
        variableTerm = "";
        if (angular.isUndefined(refocus) || refocus === true) {
            editable.parents(".modal").focus();
        }
    };

    var leaveAutoComplete = function leaveAutoComplete(scope) {
        scope.$apply(function () {
            variableTerm = "";
            startPosition = -1;
            scope.enableAutoComplete = false;
        });
    };

    var enableAutoComplete = function enableAutoComplete(scope, editable) {
        scope.$apply(function () {
            variableTerm = "";
            scope.enableAutoComplete = true;
            if (angular.isDefined(editable.autocomplete().data('ui-autocomplete'))) {
                editable.autocomplete('enable');
            }
        });
    };

    var setVariableKey = function setVariableKey(e) {
        if (e.key !== 'Meta') {
            if (COMBINED_KEY_SET.indexOf(e.which) > -1) {
                variableTerm = variableTerm + e.key;
            } else if (e.which === 8) {
                variableTerm = variableTerm.substring(0, variableTerm.length - 1);
            }
        }
        return variableTerm;
    };

    function validate(scope) {
        var status = scope.validate({ 'draft': scope.draft });
        if (angular.isUndefined(status))
            // No validation function provided
            return true;

        scope.$apply(function () {
            scope.validationStatus = status;
        });
        return status;
    }

    var canCommit = function canCommit(scope, editable) {
        return scope.allowCommitOnInvalid === 'true' || isValid(editable) && validate(scope);
    };

    function commit(scope, editable, options, refocus) {
        if (canCommit(scope, editable) && !scope.enableAutoComplete) {
            scope.$apply(function () {
                scope.model = options.getModelFromDraft(scope.draft, scope.model);
                leaveEditMode(scope, editable, refocus);
            });
            // Callback must be called in a separate apply call in order to update the text property first.
            scope.$apply(function () {
                scope.onChange();
            });
        }
    }

    function rollback(scope, editable, refocus) {
        scope.$apply(function () {
            if (angular.isDefined(scope.enableAutoComplete)) {
                scope.draft = scope.tempDraft;
                scope.model = scope.tempDraft;
            } else {
                scope.draft = scope.model;
            }
            leaveEditMode(scope, editable, refocus);

            if (angular.isDefined(scope.validationStatus)) {
                scope.validationStatus = true;
            }
        });
    }

    function edit(scope, editable, options) {
        scope.$apply(function () {
            scope.editMode = true;
            scope.draft = options.getDraftFromModel(scope.model);
            scope.tempDraft = options.getDraftFromModel(scope.model);
        });

        if (editable.is('select')) {
            editable.focus();
        } else {
            editable.select();
        }
    }

    function commitOnBlur(scope, element, editable, options) {
        var onClickHandler = function onClickHandler(event) {
            if (scope.editMode && !angular.element.contains(element[0], event.target)) {
                commit(scope, editable, options);
            }
        };

        var unbindActionHandlers = function unbindActionHandlers() {
            angular.element(document).off('click', onClickHandler);
            angular.element(document).off('mousedown', onClickHandler);
        };

        unbindActionHandlers();
        angular.element(document).on('click', onClickHandler);
        angular.element(document).on('mousedown', onClickHandler);
        element.on('$destroy', unbindActionHandlers);
    }

    function switchOnTab(scope, element, editable, options) {
        var onFocusHandler = function onFocusHandler(event) {
            edit(scope, editable, options);
        };

        var onTabHandler = function onTabHandler(event) {
            if (event.which === 9 && scope.editMode) {
                commit(scope, editable, options, false);
            }
        };

        element.find('.focusable').focus(onFocusHandler);
        editable.keydown(onTabHandler);
    }

    function setupAutocomplete(scope, element, editable, options) {
        var autocomplete = editable.autocomplete({
            autoFocus: true,
            source: scope.autocompleteData ? options.filterCandidates(scope.autocompleteData) : function (request, response) {
                scope.autocompleteCallback(request, function (data) {
                    // when data is returned, pass it through filter before setting it on the control
                    response(options.filterCandidates(data));
                });
            },
            delay: scope.autocompleteDelay || 0,
            minLength: 0,
            position: {
                my: "left top",
                at: "left bottom",
                collision: "flip",
                within: ".modal-body"
            },
            classes: {
                'ui-autocomplete': scope.autocompleteClasses
            },
            select: function select(event, ui) {
                scope.$apply(function () {
                    scope.draft = options.getModelFromCandidate(ui.item);
                });
                commit(scope, editable, options, false);
            }
        });

        if (angular.isDefined(options.renderAutocompleteItem)) {
            autocomplete.data('ui-autocomplete')._renderItem = options.renderAutocompleteItem;
        }
        editable.focus(function () {
            autocomplete.autocomplete('widget').position($.extend({
                of: editable
            }, autocomplete.autocomplete('option', 'position')));
        });
    }

    function setupRequired(scope, editable, attrs) {
        scope.$watch(attrs.required, function (value) {
            if (angular.isDefined(attrs.required)) {
                scope.isRequired = angular.isDefined(attrs.required) && attrs.required !== false;
            }
        });
    }

    var getCursorPos = function getCursorPos(input) {
        if ("selectionStart" in input && document.activeElement === input) {
            return {
                start: input.selectionStart,
                end: input.selectionEnd
            };
        } else if (input.createTextRange) {
            var sel = document.selection.createRange();
            if (sel.parentElement() === input) {
                var rng = input.createTextRange();
                rng.moveToBookmark(sel.getBookmark());
                var len = void 0;
                var pos = void 0;
                for (len = 0; rng.compareEndPoints("EndToStart", rng) > 0; rng.moveEnd("character", -1)) {
                    len++;
                }
                rng.setEndPoint("StartToStart", input.createTextRange());
                for (pos = { start: 0, end: len }; rng.compareEndPoints("EndToStart", rng) > 0; rng.moveEnd("character", -1)) {
                    pos.start++;
                    pos.end++;
                }
                return pos;
            }
        }
        return -1;
    };

    function isValid(editable) {
        return editable.hasClass('ng-valid');
    }

    // Reference for Key codes : https://www.cambiaresearch.com/articles/15/javascript-char-codes-key-codes

    var ALLOWED_KEYS_SET1 = _.range(48, 91);
    var ALLOWED_KEYS_SET2 = _.range(96, 112);
    var ALLOWED_KEYS_SET3 = _.range(186, 192);
    var ALLOWED_KEYS_SET4 = [32, 219, 220, 221, 222];
    var COMBINED_KEY_SET = ALLOWED_KEYS_SET1.concat(ALLOWED_KEYS_SET2).concat(ALLOWED_KEYS_SET3).concat(ALLOWED_KEYS_SET4);

    var variableTerm = "";
    var startPosition = -1;

    var DEFAULT_OPTIONS = {
        multiline: false,

        // Use autocomplete filtering by default
        filterCandidates: angular.identity,

        getModelFromCandidate: function getModelFromCandidate(item) {
            return item.value;
        },


        // Use model for draft by default
        getDraftFromModel: angular.identity,

        // Use draft for model by default
        getModelFromDraft: angular.identity

    };

    return {
        directive: function directive(template, options) {
            options = _.defaults(options || {}, DEFAULT_OPTIONS);

            return {
                restrict: 'A',
                templateUrl: 'partials/inline-editor/' + template,
                scope: {
                    name: '@',
                    placeholder: '@',
                    model: '=',
                    onChange: '&',
                    validate: '&',
                    validationStatus: '=',
                    selectOptions: '=',
                    autocompleteData: '=',
                    autocompleteClasses: '@',
                    allowCommitOnInvalid: '@',
                    enableAutoComplete: '=?',
                    position: '=?',
                    /**
                     * To usea function to return data (like from a backend call), set this on the scope with a 
                     * function accepting arguments (request: {term: <string>}, response: function( [] )) 
                     */
                    autocompleteCallback: '@',

                    /**
                     * Delay after typing stops before returning autocomplete results in milliseconds. Recommended to
                     * use this when pulling results from the server (avoids overburdening).
                     */
                    autocompleteDelay: '@'
                },
                transclude: true,
                link: function link(scope, element, attrs) {
                    var elemScrollTop = 0;
                    scope.editMode = false;
                    scope.enableAutoComplete = false;
                    var editable = element.find('.editable');

                    // On click
                    element.find('.display').on('click', function (event) {
                        if (options.multiline && !angular.element(event.target).hasClass('edit-icon')) {
                            return;
                        }
                        edit(scope, editable, options);
                    });

                    element.on('click', '.display-edit-mode', function () {
                        edit(scope, editable, options);
                    });

                    if (options.multiline) {
                        element.find('.ok').on('click', function () {
                            scope.enableAutoComplete = false;
                            commit(scope, editable, options);
                        });
                        element.find('.cancel').on('click', function () {
                            scope.enableAutoComplete = false;
                            rollback(scope, editable);
                        });
                    } else {
                        // On enter
                        editable.on('keypress', function (e) {
                            if (e.which === 13 && e.ctrlKey === false) {
                                scope.enableAutoComplete = false;
                                commit(scope, editable, options);
                                e.preventDefault();
                            }
                        });
                    }

                    setupAutocomplete(scope, element, editable, options);
                    setupRequired(scope, editable, attrs);

                    // On blur
                    if (!options.doNotCommitOnBlur) {
                        commitOnBlur(scope, element, editable, options);
                    }

                    // On escape
                    editable.on('keyup', function (e) {
                        if (e.which === 27) {
                            scope.enableAutoComplete = false;
                            rollback(scope, editable);
                            e.stopPropagation();
                        }
                    });

                    editable.on('keydown', function (e) {
                        if (options.multiline) {
                            // not relevant to the use of this... and certain imports are not available so removing this.
                        }
                    });

                    // On tab
                    switchOnTab(scope, element, editable, options);

                    scope.isNumber = angular.isNumber;
                    scope.hasText = function (data) {
                        return !_.isEmpty(data);
                    };

                    if (angular.isDefined(attrs.markdown)) {
                        scope.helpUrl = Doc.getMarkdownSyntaxURL();
                    }

                    // Populate the draft on link so validation attributes run on the correct state
                    scope.$watch('model', function (newModel) {
                        if (newModel) {
                            scope.draft = options.getDraftFromModel(newModel);
                        }
                    });

                    // convert enum structure
                    if (scope.selectOptions && angular.isString(scope.selectOptions[0])) {
                        scope.selectOptions = scope.selectOptions.map(function (item) {
                            return { id: item, title: item };
                        });
                        if (!attrs.required) {
                            scope.selectOptions.unshift({ title: "", id: null });
                        }
                    }
                }
            };
        }
    };
}]);

/***/ }),
/* 7 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })
/******/ ]);