/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.xlinsight.service;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.impact.api.DataSourceTypeEnum;
import com.xebialabs.impact.api.KnownArtefactRequestDescriptionVM;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.json.CiSerializerHelper$;
import com.xebialabs.xlrelease.plugins.xlinsight.config.PluginProperties;
import com.xebialabs.xlrelease.plugins.xlinsight.config.XLIInstance;
import com.xebialabs.xlrelease.plugins.xlinsight.repository.ReleaseInfo;
import com.xebialabs.xlrelease.plugins.xlinsight.service.IngestionApi;
import com.xebialabs.xlrelease.plugins.xlinsight.service.IngestionApiImpl;
import com.xebialabs.xlrelease.plugins.xlinsight.service.XlrService;
import com.xebialabs.xlrelease.plugins.xlinsight.um.Converters$;
import com.xebialabs.xlrelease.plugins.xlinsight.um.TenantAndDataSource;
import com.xebialabs.xlrelease.plugins.xlinsight.um.UmArtefact;
import com.xebialabs.xlrelease.plugins.xlinsight.utils.AuthUtil$;
import com.xebialabs.xlrelease.plugins.xlinsight.utils.Retry$;
import com.xebialabs.xlrelease.repository.Ids;
import java.io.Serializable;
import java.sql.Date;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0001\t}g\u0001B\u0001\u0003\u0001=\u0011q\u0003\u00177s\t\u0006$\u0018-\u0012=ue\u0006\u001cGo\u001c:TKJ4\u0018nY3\u000b\u0005\r!\u0011aB:feZL7-\u001a\u0006\u0003\u000b\u0019\t\u0011\u0002\u001f7j]NLw\r\u001b;\u000b\u0005\u001dA\u0011a\u00029mk\u001eLgn\u001d\u0006\u0003\u0013)\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005-a\u0011!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0011aA2p[\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\"Aq\u0003\u0001BC\u0002\u0013\u0005\u0001$\u0001\u0006yYJ\u001cVM\u001d<jG\u0016,\u0012!\u0007\t\u00035mi\u0011AA\u0005\u00039\t\u0011!\u0002\u00177s'\u0016\u0014h/[2f\u0011!q\u0002A!A!\u0002\u0013I\u0012a\u0003=meN+'O^5dK\u0002B\u0001\u0002\t\u0001\u0003\u0006\u0004%\t!I\u0001\u0006aJ|\u0007o]\u000b\u0002EA\u00111EJ\u0007\u0002I)\u0011Q\u0005B\u0001\u0007G>tg-[4\n\u0005\u001d\"#\u0001\u0005)mk\u001eLg\u000e\u0015:pa\u0016\u0014H/[3t\u0011!I\u0003A!A!\u0002\u0013\u0011\u0013A\u00029s_B\u001c\b\u0005C\u0003,\u0001\u0011\u0005A&\u0001\u0004=S:LGO\u0010\u000b\u0004[9z\u0003C\u0001\u000e\u0001\u0011\u00159\"\u00061\u0001\u001a\u0011\u0015\u0001#\u00061\u0001#Q\tQ\u0013\u0007\u0005\u00023{5\t1G\u0003\u00025k\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005Y:\u0014a\u00024bGR|'/\u001f\u0006\u0003qe\nQAY3b]NT!AO\u001e\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011\u0001P\u0001\u0004_J<\u0017B\u0001 4\u0005%\tU\u000f^8xSJ,G\rC\u0004A\u0001\t\u0007I\u0011A!\u0002\r1|wmZ3s+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#<\u0003\u0015\u0019HN\u001a\u001bk\u0013\t9EI\u0001\u0004M_\u001e<WM\u001d\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002\"\u0002\u000f1|wmZ3sA\u0015!1\n\u0001\u0003M\u0005-\u0011Vm\u001d9p]N,W*\u00199\u0011\t5#vK\u0017\b\u0003\u001dJ\u0003\"a\u0014\n\u000e\u0003AS!!\u0015\b\u0002\rq\u0012xn\u001c;?\u0013\t\u0019&#\u0001\u0004Qe\u0016$WMZ\u0005\u0003+Z\u00131!T1q\u0015\t\u0019&\u0003\u0005\u0002N1&\u0011\u0011L\u0016\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005EY\u0016B\u0001/\u0013\u0005\u001d\u0011un\u001c7fC:,AA\u0018\u0001\u0005?\n\u0019\"+\u001a7fCN,\u0017\nZ!oI\u0016sG\rR1uKB!\u0011\u0003Y,c\u0013\t\t'C\u0001\u0004UkBdWM\r\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\fA!\u001e;jY*\tq-\u0001\u0003kCZ\f\u0017BA5e\u0005\u0011!\u0015\r^3\t\u000f-\u0004!\u0019!C\u0001Y\u0006!An\\2l+\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003\u0015awnY6t\u0015\t\u0011H-\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001^8\u0003\u001bI+WM\u001c;sC:$Hj\\2l\u0011\u00191\b\u0001)A\u0005[\u0006)An\\2lA!9\u0001\u0010\u0001b\u0001\n\u0003I\u0018A\u0006:fMJ,7\u000f[#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0016\u0003i\u0004\"a\u001f?\u000e\u0003EL!!`9\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW\r\u0003\u0004\u0000\u0001\u0001\u0006IA_\u0001\u0018e\u00164'/Z:i\u000bb,7-\u001e;peN+'O^5dK\u0002B\u0001\"a\u0001\u0001\u0005\u0004%\t!_\u0001\u0010Kb,7-\u001e;peN+'O^5dK\"9\u0011q\u0001\u0001!\u0002\u0013Q\u0018\u0001E3yK\u000e,Ho\u001c:TKJ4\u0018nY3!\u0011%\tY\u0001\u0001b\u0001\n\u0003\ti!A\fd_:\u001cWO\u001d:f]R$\u0016m]6TG\",G-\u001e7feV\u0011\u0011q\u0002\t\u0005\u0003#\tI\"\u0004\u0002\u0002\u0014)\u0019!/!\u0006\u000b\u0007\u0005]\u0011(\u0001\u0006tG\",G-\u001e7j]\u001eLA!a\u0007\u0002\u0014\t92i\u001c8dkJ\u0014XM\u001c;UCN\\7k\u00195fIVdWM\u001d\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u0010\u0005A2m\u001c8dkJ\u0014XM\u001c;UCN\\7k\u00195fIVdWM\u001d\u0011\t\u0013\u0005\r\u0002A1A\u0005\u0002\u0005\u0015\u0012aE6o_^t7i\u001c8gS\u001e,(/\u0019;j_:\u001cXCAA\u0014!\u001dY\u0018\u0011FA\u0017\u0003gI1!a\u000br\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0004G\u0005=\u0012bAA\u0019I\tY\u0001\fT%J]N$\u0018M\\2fa\u0011\t)$a\u0010\u0011\u000bm\f9$a\u000f\n\u0007\u0005e\u0012OA\bTG\",G-\u001e7fI\u001a+H/\u001e:f!\u0011\ti$a\u0010\r\u0001\u0011a\u0011\u0011IA\"\u0003\u0003\u0005\tQ!\u0001\u0002H\t\u0019q\fJ\u0019\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003O\tAc\u001b8po:\u001cuN\u001c4jOV\u0014\u0018\r^5p]N\u0004\u0013\u0003BA%\u0003\u001f\u00022!EA&\u0013\r\tiE\u0005\u0002\b\u001d>$\b.\u001b8h!\r\t\u0012\u0011K\u0005\u0004\u0003'\u0012\"aA!os\"9\u0011q\u000b\u0001\u0005\u0002\u0005e\u0013a\u0002:fMJ,7\u000f\u001b\u000b\u0003\u00037\u00022!EA/\u0013\r\tyF\u0005\u0002\u0005+:LG\u000fC\u0004\u0002d\u0001!\t!!\u001a\u0002-M\u001c\u0007.\u001a3vY\u0016DF.[%ogR\fgnY3O_^$B!a\u001a\u0002rA\"\u0011\u0011NA7!\u0015Y\u0018qGA6!\u0011\ti$!\u001c\u0005\u0019\u0005=\u0014\u0011MA\u0001\u0002\u0003\u0015\t!a\u0012\u0003\u0007}#3\u0007\u0003\u0005\u0002t\u0005\u0005\u0004\u0019AA\u0017\u0003-AH.[%ogR\fgnY3\t\u000f\u0005]\u0004\u0001\"\u0001\u0002z\u0005I2o\u00195fIVdW\r\u00177j\u0013:\u001cH/\u00198dK\nK8I]8o)\u0019\tY(!\"\u0002\bB\"\u0011QPAA!\u0015Y\u0018qGA@!\u0011\ti$!!\u0005\u0019\u0005\r\u0015QOA\u0001\u0002\u0003\u0015\t!a\u0012\u0003\u0007}#C\u0007\u0003\u0005\u0002t\u0005U\u0004\u0019AA\u0017\u0011\u001d\tI)!\u001eA\u0002]\u000bab\u0019:p]\u0016C\bO]3tg&|g\u000eC\u0004\u0002\u000e\u0002!\t!a$\u0002%A\u0014xnY3tgbc\u0017.\u00138ti\u0006t7-\u001a\u000b\u0005\u00037\n\t\n\u0003\u0005\u0002t\u0005-\u00059AA\u0017\u0011\u001d\t)\n\u0001C\u0001\u00033\nqb]2iK\u0012,H.\u001a*fMJ,7\u000f\u001b\u0005\b\u00033\u0003A\u0011AA-\u0003\u0011Ig.\u001b;)\t\u0005]\u0015Q\u0014\t\u0005\u0003?\u000b9+\u0004\u0002\u0002\"*\u0019A'a)\u000b\u0005\u0005\u0015\u0016!\u00026bm\u0006D\u0018\u0002BAU\u0003C\u0013Q\u0002U8ti\u000e{gn\u001d;sk\u000e$\bbBAW\u0001\u0011\u0005\u0011qV\u0001\"g\u0016tG-\u00168L]><h.\u0011:uS\u001a\f7\r\u001e+p\u0013:<Wm\u001d;j_:\f\u0005/\u001b\u000b\u0007\u0003c\u000bY-a7\u0015\r\u0005M\u0016QXAd!\u0019\t),!/\u0002\\5\u0011\u0011q\u0017\u0006\u0003KJIA!a/\u00028\n\u0019AK]=\t\u0011\u0005}\u00161\u0016a\u0002\u0003\u0003\fA\"\u001b8hKN$\u0018n\u001c8Ba&\u00042AGAb\u0013\r\t)M\u0001\u0002\r\u0013:<Wm\u001d;j_:\f\u0005/\u001b\u0005\t\u0003\u0013\fY\u000bq\u0001\u0002.\u0005A\u0011N\\:uC:\u001cW\r\u0003\u0005\u0002N\u0006-\u0006\u0019AAh\u0003\u001d\u0011X\r\\3bg\u0016\u0004B!!5\u0002X6\u0011\u00111\u001b\u0006\u0004\u0003+D\u0011A\u00023p[\u0006Lg.\u0003\u0003\u0002Z\u0006M'a\u0002*fY\u0016\f7/\u001a\u0005\t\u0003;\fY\u000b1\u0001\u0002`\u0006!1.\u001b8e!\u0011\t\t/a;\u000e\u0005\u0005\r(\u0002BAs\u0003O\f1!\u00199j\u0015\r\tIOC\u0001\u0007S6\u0004\u0018m\u0019;\n\t\u00055\u00181\u001d\u0002\u0013\t\u0006$\u0018mU8ve\u000e,G+\u001f9f\u000b:,X\u000eC\u0004\u0002r\u0002!I!a=\u0002+\u0011,G/Z2u+:\\gn\\<o%\u0016dW-Y:fgRA\u0011Q\u001fB\n\u0005/\u0011\t\u0003\u0006\u0004\u0002x\n=!\u0011\u0003\t\u0007\u0003k\u000bI,!?\u0011\r\u0005m(Q\u0001B\u0006\u001d\u0011\tiP!\u0001\u000f\u0007=\u000by0C\u0001\u0014\u0013\r\u0011\u0019AE\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00119A!\u0003\u0003\t1K7\u000f\u001e\u0006\u0004\u0005\u0007\u0011\u0002c\u0001B\u0007;6\t\u0001\u0001\u0003\u0005\u0002J\u0006=\b9AA\u0017\u0011!\ty,a<A\u0004\u0005\u0005\u0007\u0002\u0003B\u000b\u0003_\u0004\r!!?\u0002%Ut7N\\8x]J+G.Z1tKN\f5m\u0019\u0005\t\u00053\ty\u000f1\u0001\u0003\u001c\u00051qN\u001a4tKR\u00042!\u0005B\u000f\u0013\r\u0011yB\u0005\u0002\u0005\u0019>tw\r\u0003\u0005\u0003$\u0005=\b\u0019\u0001B\u000e\u0003\u0015!W\r\\1zQ\u0011\tyOa\n\u0011\t\t%\"QF\u0007\u0003\u0005WQ!\u0001\u000e\n\n\t\t=\"1\u0006\u0002\bi\u0006LGN]3d\u0011\u001d\u0011\u0019\u0004\u0001C\u0003\u0005k\tQCZ8mIJKw\r\u001b;V]RLGnU;dG\u0016\u001c8/\u0006\u0003\u00038\t5CC\u0002B\u001d\u0005#\u0012)\u0006\u0006\u0003\u0003<\t\u0005\u0003cA\t\u0003>%\u0019!q\b\n\u0003\u0007%sG\u000f\u0003\u0005\u0003D\tE\u0002\u0019\u0001B#\u0003\t1g\u000eE\u0005\u0012\u0005\u000f\u0012YDa\u0013\u00024&\u0019!\u0011\n\n\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004\u0003BA\u001f\u0005\u001b\"\u0001Ba\u0014\u00032\t\u0007\u0011q\t\u0002\u0002)\"Q!1\u000bB\u0019!\u0003\u0005\rAa\u000f\u0002\u0007\u0005\u001c7\r\u0003\u0005\u0003X\tE\u0002\u0019\u0001B-\u0003!)G.Z7f]R\u001c\bCBA~\u00057\u0012Y%\u0003\u0003\u0003^\t%!aA*fc\"\"!\u0011\u0007B\u0014\u0011\u001d\u0011\u0019\u0007\u0001C\u0003\u0005K\nACZ8mI2+g\r^+oi&d7+^2dKN\u001cX\u0003\u0002B4\u0005c\"bA!\u001b\u0003t\tUD\u0003\u0002B\u001e\u0005WB\u0001Ba\u0011\u0003b\u0001\u0007!Q\u000e\t\n#\t\u001d#1\bB8\u0003g\u0003B!!\u0010\u0003r\u0011A!q\nB1\u0005\u0004\t9\u0005\u0003\u0006\u0003T\t\u0005\u0004\u0013!a\u0001\u0005wA\u0001Ba\u0016\u0003b\u0001\u0007!q\u000f\t\u0007\u0003w\u0014YFa\u001c)\t\t\u0005$q\u0005\u0005\b\u0005{\u0002A\u0011\u0001B@\u0003UIg.\u001b;Be\u000eD\u0017N^3FqR\u0014\u0018m\u0019;j_:$b!a\u0017\u0003\u0002\n\r\u0005\u0002CAe\u0005w\u0002\u001d!!\f\t\u0011\u0005}&1\u0010a\u0002\u0003\u0003DqAa\"\u0001\t\u0013\u0011I)\u0001\feKR,7\r^+oW:|wO\u001c+f[Bd\u0017\r^3t)\u0019\u0011YI!%\u0003\u0016R1\u00111\fBG\u0005\u001fC\u0001\"!3\u0003\u0006\u0002\u000f\u0011Q\u0006\u0005\t\u0003\u007f\u0013)\tq\u0001\u0002B\"A!1\u0013BC\u0001\u0004\u0011Y\"\u0001\u0003qC\u001e,\u0007\u0002\u0003B\u0012\u0005\u000b\u0003\rAa\u0007)\t\t\u0015%q\u0005\u0005\b\u00057\u0003A\u0011\u0001BO\u0003YIg.\u001b;UK6\u0004H.\u0019;f\u000bb$(/Y2uS>tGCBA.\u0005?\u0013\t\u000b\u0003\u0005\u0002J\ne\u00059AA\u0017\u0011!\tyL!'A\u0004\u0005\u0005\u0007b\u0002BS\u0001\u0011\u0005\u0011\u0011L\u0001\bI\u0016\u001cHO]8zQ\u0011\u0011\u0019K!+\u0011\t\u0005}%1V\u0005\u0005\u0005[\u000b\tK\u0001\u0006Qe\u0016$Um\u001d;s_fD\u0011B!-\u0001#\u0003%)Aa-\u0002?\u0019|G\u000e\u001a*jO\"$XK\u001c;jYN+8mY3tg\u0012\"WMZ1vYR$\u0013'\u0006\u0003\u00036\n\u001dWC\u0001B\\U\u0011\u0011YD!/,\u0005\tm\u0006\u0003\u0002B_\u0005\u0007l!Aa0\u000b\t\t\u0005'1F\u0001\nk:\u001c\u0007.Z2lK\u0012LAA!2\u0003@\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u0011\t=#q\u0016b\u0001\u0003\u000fB\u0011Ba3\u0001#\u0003%)A!4\u0002=\u0019|G\u000e\u001a'fMR,f\u000e^5m'V\u001c7-Z:tI\u0011,g-Y;mi\u0012\nT\u0003\u0002B[\u0005\u001f$\u0001Ba\u0014\u0003J\n\u0007\u0011q\t\u0015\u0004\u0001\tM\u0007\u0003\u0002Bk\u00057l!Aa6\u000b\u0007\te\u0017(\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAA!8\u0003X\n91+\u001a:wS\u000e,\u0007")
public class XlrDataExtractorService {
    private final XlrService xlrService;
    private final PluginProperties props;
    private final Logger logger;
    private final ReentrantLock lock;
    private final ScheduledExecutorService refreshExecutorService;
    private final ScheduledExecutorService executorService;
    private final ConcurrentTaskScheduler concurrentTaskScheduler;
    private final ConcurrentHashMap<XLIInstance, ScheduledFuture<?>> knownConfigurations;

    public XlrService xlrService() {
        return this.xlrService;
    }

    public PluginProperties props() {
        return this.props;
    }

    public Logger logger() {
        return this.logger;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public ScheduledExecutorService refreshExecutorService() {
        return this.refreshExecutorService;
    }

    public ScheduledExecutorService executorService() {
        return this.executorService;
    }

    public ConcurrentTaskScheduler concurrentTaskScheduler() {
        return this.concurrentTaskScheduler;
    }

    public ConcurrentHashMap<XLIInstance, ScheduledFuture<?>> knownConfigurations() {
        return this.knownConfigurations;
    }

    public void refresh() {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            List<XLIInstance> newInstances = this.props().getXliDestinationInstances();
            newInstances.foreach((Function1 & Serializable & scala.Serializable)instance -> this.knownConfigurations().computeIfAbsent((XLIInstance)instance, key -> {
                this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding new configuration: {}, {}, {}"})).s((Seq)Nil$.MODULE$), new Object[]{key.httpConfig().endpoint(), key.tenantId(), key.dataSourceId()});
                return this.scheduleXliInstanceNow((XLIInstance)key);
            }));
            Set newInstancesSet = newInstances.toSet();
            ((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.knownConfigurations().keySet()).asScala()).diff((GenSet)newInstancesSet).toList().foreach((Function1 & Serializable & scala.Serializable)removedConfiguration -> {
                ScheduledFuture<?> scheduledFuture;
                this.lock().lock();
                try {
                    ((Future)this.knownConfigurations().get(removedConfiguration)).cancel(true);
                    this.logger().info("Removing old configuration: {}, {}, {}", new Object[]{removedConfiguration.httpConfig().endpoint(), removedConfiguration.tenantId(), removedConfiguration.dataSourceId()});
                    scheduledFuture = this.knownConfigurations().remove(removedConfiguration);
                }
                finally {
                    this.lock().unlock();
                }
                return scheduledFuture;
            });
        });
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error("Exception when refreshing XLI instances", e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.scheduleRefresh();
    }

    public ScheduledFuture<?> scheduleXliInstanceNow(XLIInstance xliInstance) {
        return this.concurrentTaskScheduler().schedule(() -> this.processXliInstance(xliInstance), java.util.Date.from(Instant.now()));
    }

    public ScheduledFuture<?> scheduleXliInstanceByCron(XLIInstance xliInstance, String cronExpression) {
        return this.concurrentTaskScheduler().schedule(() -> this.processXliInstance(xliInstance), (Trigger)new CronTrigger(xliInstance.cronExpression()));
    }

    public void processXliInstance(XLIInstance xliInstance) {
        IngestionApiImpl ingestionApi = new IngestionApiImpl(xliInstance);
        this.initArchiveExtraction(xliInstance, ingestionApi);
        this.initTemplateExtraction(xliInstance, ingestionApi);
        this.knownConfigurations().put(xliInstance, this.scheduleXliInstanceByCron(xliInstance, xliInstance.cronExpression()));
    }

    public void scheduleRefresh() {
        Runnable action = () -> this.refresh();
        this.refreshExecutorService().schedule(action, 1L, TimeUnit.MINUTES);
    }

    @PostConstruct
    public void init() {
        this.scheduleRefresh();
        this.logger().info("Scheduled refresh in 1 minute");
    }

    public Try<BoxedUnit> sendUnKnownArtifactToIngestionApi(Release release, DataSourceTypeEnum kind, IngestionApi ingestionApi, XLIInstance instance) {
        Try<BoxedUnit> try_;
        TenantAndDataSource source = new TenantAndDataSource(instance.tenantId(), instance.dataSourceId());
        UmArtefact artefact = (UmArtefact)Converters$.MODULE$.convert(release, kind).apply((Object)source);
        DataSourceTypeEnum dataSourceTypeEnum = kind;
        if (((Object)((Object)DataSourceTypeEnum.BUILD_TEMPLATE)).equals((Object)dataSourceTypeEnum)) {
            try_ = ingestionApi.pushData(artefact, CiSerializerHelper$.MODULE$.serialize((ConfigurationItem)release));
        } else if (((Object)((Object)DataSourceTypeEnum.BUILD)).equals((Object)dataSourceTypeEnum)) {
            Failure failure;
            Option<String> option = this.xlrService().getReleaseJson(release.getId());
            if (option instanceof Some) {
                Some some = (Some)option;
                String json = (String)some.value();
                failure = ingestionApi.pushData(artefact, json);
            } else {
                failure = new Failure((Throwable)new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No json data found for release ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{release.getId()}))));
            }
            try_ = failure;
        } else {
            throw new MatchError((Object)dataSourceTypeEnum);
        }
        return try_;
    }

    private Try<List<Tuple2<String, java.util.Date>>> detectUnknownReleases(List<Tuple2<String, java.util.Date>> unknownReleasesAcc, long offset, long delay, XLIInstance instance, IngestionApi ingestionApi) {
        Success success;
        block7: {
            block4: {
                Failure failure;
                block6: {
                    Try try_;
                    block5: {
                        List updatedAcc;
                        while (true) {
                            Function1 & Serializable & scala.Serializable releaseWasStarted = (Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)XlrDataExtractorService.$anonfun$detectUnknownReleases$1(x0$1));
                            Tuple2<GenTraversable, Object> rs = Retry$.MODULE$.executeWithDelayIfNotInterrupted(Seq$.MODULE$.apply((Seq)Nil$.MODULE$), delay, (Function0 & Serializable & scala.Serializable)() -> (Seq)((TraversableLike)this.xlrService().fetchTopMostReleasesIdsSortedByEndDate(offset, instance.chunkLimit()).filter(releaseWasStarted)).map((Function1 & Serializable & scala.Serializable)t -> new Tuple2((Object)t.releaseId(), (Object)t.endDate()), Seq$.MODULE$.canBuildFrom()), instance);
                            Tuple2<GenTraversable, Object> tuple2 = rs;
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            Seq releases = (Seq)tuple2._1();
                            long nextDelay = tuple2._2$mcJ$sp();
                            Tuple2 tuple22 = new Tuple2((Object)releases, (Object)BoxesRunTime.boxToLong((long)nextDelay));
                            Tuple2 tuple23 = tuple22;
                            Seq releases2 = (Seq)tuple23._1();
                            long nextDelay2 = tuple23._2$mcJ$sp();
                            if (!releases2.nonEmpty()) break block4;
                            Seq artifacts = (Seq)releases2.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                String relId = (String)tuple2._1();
                                Date endDate = (Date)tuple2._2();
                                KnownArtefactRequestDescriptionVM knownArtefactRequestDescriptionVM = new KnownArtefactRequestDescriptionVM().setArtefactId(Ids.getFolderlessId((String)relId)).setVersion(Converters$.MODULE$.getReleaseHash(endDate));
                                return knownArtefactRequestDescriptionVM;
                            }, Seq$.MODULE$.canBuildFrom());
                            try_ = (Try)Retry$.MODULE$.executeIfNotInterrupted(new Success((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Function0 & Serializable & scala.Serializable)() -> ingestionApi.checkWhichArtefactsAreKnown((Seq<KnownArtefactRequestDescriptionVM>)artifacts, DataSourceTypeEnum.BUILD));
                            if (!(try_ instanceof Success)) break block5;
                            Success success2 = (Success)try_;
                            Map responseMap = (Map)success2.value();
                            Seq unknownReleases = (Seq)releases2.filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)XlrDataExtractorService.$anonfun$detectUnknownReleases$6(responseMap, x0$3)));
                            updatedAcc = (List)unknownReleasesAcc.$plus$plus((GenTraversableOnce)unknownReleases, List$.MODULE$.canBuildFrom());
                            if (unknownReleases.size() != releases2.size()) break;
                            long currentOffset = offset + (long)instance.chunkLimit();
                            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Next offset for unknown releases will be ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)currentOffset)})));
                            delay = nextDelay2;
                            offset = currentOffset;
                            unknownReleasesAcc = updatedAcc;
                        }
                        failure = new Success((Object)updatedAcc);
                        break block6;
                    }
                    if (try_ instanceof Failure) {
                        Failure failure2 = (Failure)try_;
                        Throwable e = failure2.exception();
                        failure = new Failure(e);
                    } else {
                        throw new MatchError((Object)try_);
                    }
                }
                success = failure;
                break block7;
            }
            success = new Success(unknownReleasesAcc);
        }
        return success;
    }

    public final <T> int foldRightUntilSuccess(int acc, Seq<T> elements, Function2<Object, T, Try<BoxedUnit>> fn) {
        int n;
        block3: {
            while (elements.nonEmpty()) {
                Object elm = elements.last();
                Try try_ = (Try)fn.apply((Object)BoxesRunTime.boxToInteger((int)acc), elm);
                if (try_ instanceof Success) {
                    elements = (Seq)elements.dropRight(1);
                    ++acc;
                    continue;
                }
                if (!(try_ instanceof Failure)) {
                    throw new MatchError((Object)try_);
                }
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                this.logger().error(ex.getMessage(), ex);
                int n2 = acc;
                n = n2;
                break block3;
            }
            n = acc;
        }
        return n;
    }

    public final <T> int foldRightUntilSuccess$default$1() {
        return 0;
    }

    public final <T> int foldLeftUntilSuccess(int acc, Seq<T> elements, Function2<Object, T, Try<BoxedUnit>> fn) {
        int n;
        block3: {
            while (elements.nonEmpty()) {
                Object elm = elements.head();
                Try try_ = (Try)fn.apply((Object)BoxesRunTime.boxToInteger((int)acc), elm);
                if (try_ instanceof Success) {
                    elements = (Seq)elements.tail();
                    ++acc;
                    continue;
                }
                if (!(try_ instanceof Failure)) {
                    throw new MatchError((Object)try_);
                }
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                this.logger().error(ex.getMessage(), ex);
                int n2 = acc;
                n = n2;
                break block3;
            }
            n = acc;
        }
        return n;
    }

    public final <T> int foldLeftUntilSuccess$default$1() {
        return 0;
    }

    public void initArchiveExtraction(XLIInstance instance, IngestionApi ingestionApi) {
        Try<List<Tuple2<String, java.util.Date>>> maybeReleases;
        this.logger().info("Starting XLR Archive extraction");
        Try<List<Tuple2<String, java.util.Date>>> try_ = maybeReleases = this.detectUnknownReleases((List<Tuple2<String, java.util.Date>>)Nil$.MODULE$, 0L, 0L, instance, ingestionApi);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            List unknownReleases = (List)success.value();
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " unknown archive releases"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)unknownReleases.size())})));
            int amountOfReleasesPushedToIngestionApi = this.foldRightUntilSuccess(0, (Seq)unknownReleases, (Function2)(Function2 & Serializable & scala.Serializable)(counter, releaseIdAndEndDate) -> XlrDataExtractorService.$anonfun$initArchiveExtraction$1(this, instance, ingestionApi, BoxesRunTime.unboxToInt((Object)counter), releaseIdAndEndDate));
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " releases pushed to XLI"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)amountOfReleasesPushedToIngestionApi)})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            this.logger().error(ex.getMessage(), ex);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    private void detectUnknownTemplates(long page, long delay, XLIInstance instance, IngestionApi ingestionApi) {
        block4: {
            BoxedUnit boxedUnit;
            block3: {
                Try try_;
                while (true) {
                    Tuple2<GenTraversable, Object> rs;
                    Tuple2<GenTraversable, Object> tuple2;
                    if ((tuple2 = (rs = Retry$.MODULE$.executeWithDelayIfNotInterrupted(Seq$.MODULE$.apply((Seq)Nil$.MODULE$), delay, (Function0 & Serializable & scala.Serializable)() -> this.xlrService().fetchTopMostTemplates(page, instance.chunkLimit()), instance))) == null) {
                        throw new MatchError(tuple2);
                    }
                    Seq templates = (Seq)tuple2._1();
                    long nextDelay = tuple2._2$mcJ$sp();
                    Tuple2 tuple22 = new Tuple2((Object)templates, (Object)BoxesRunTime.boxToLong((long)nextDelay));
                    Tuple2 tuple23 = tuple22;
                    Seq templates2 = (Seq)tuple23._1();
                    long nextDelay2 = tuple23._2$mcJ$sp();
                    if (!templates2.nonEmpty()) break block3;
                    Seq artifacts = (Seq)templates2.map((Function1 & Serializable & scala.Serializable)tpl -> new KnownArtefactRequestDescriptionVM().setArtefactId(Converters$.MODULE$.ReleaseId((Release)tpl).getFolderlessId()).setVersion(Converters$.MODULE$.ReleaseId((Release)tpl).getHash()), Seq$.MODULE$.canBuildFrom());
                    try_ = (Try)Retry$.MODULE$.executeIfNotInterrupted(new Success((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Function0 & Serializable & scala.Serializable)() -> ingestionApi.checkWhichArtefactsAreKnown((Seq<KnownArtefactRequestDescriptionVM>)artifacts, DataSourceTypeEnum.BUILD_TEMPLATE));
                    if (!(try_ instanceof Success)) break;
                    Success success = (Success)try_;
                    Map responseMap = (Map)success.value();
                    Seq unknownTemplates = (Seq)templates2.filter((Function1 & Serializable & scala.Serializable)tpl -> BoxesRunTime.boxToBoolean((boolean)XlrDataExtractorService.$anonfun$detectUnknownTemplates$4(responseMap, tpl)));
                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " unknown templates for page: ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)unknownTemplates.size()), BoxesRunTime.boxToLong((long)page)})));
                    int successfullySend = this.foldLeftUntilSuccess(0, unknownTemplates, (Function2 & Serializable & scala.Serializable)(x$4, tpl) -> this.sendUnKnownArtifactToIngestionApi(tpl, DataSourceTypeEnum.BUILD_TEMPLATE, ingestionApi, instance));
                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " templates successfully send to XLI for page ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)successfullySend), BoxesRunTime.boxToLong((long)page)})));
                    delay = nextDelay2;
                    ++page;
                }
                if (!(try_ instanceof Failure)) {
                    throw new MatchError((Object)try_);
                }
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                this.logger().error(ex.getMessage(), ex);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                boxedUnit = BoxedUnit.UNIT;
                break block4;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void initTemplateExtraction(XLIInstance instance, IngestionApi ingestionApi) {
        this.logger().info("Starting XLR Template extraction");
        AuthUtil$.MODULE$.pretendAsAdmin();
        this.detectUnknownTemplates(0L, 0L, instance, ingestionApi);
    }

    @PreDestroy
    public void destroy() {
        block1: {
            this.logger().info("Kill signal received stopping all processes, please wait...");
            this.executorService().shutdownNow();
            this.logger().warn("Waiting 30 seconds for executor service to shutdown...");
            boolean terminated = this.executorService().awaitTermination(30L, TimeUnit.SECONDS);
            if (!terminated) {
                this.logger().warn("Could not finish termination of executorService. There are still active threads.");
            }
            this.refreshExecutorService().shutdownNow();
            this.logger().warn("Waiting 30 seconds for refresh executor service to shutdown...");
            boolean refreshExecutorTerminated = this.refreshExecutorService().awaitTermination(30L, TimeUnit.SECONDS);
            if (refreshExecutorTerminated) break block1;
            this.logger().warn("Could not finish termination of refreshExecutorService. There are still active threads.");
        }
    }

    public static final /* synthetic */ boolean $anonfun$detectUnknownReleases$1(ReleaseInfo x0$1) {
        Option<Date> option;
        ReleaseInfo releaseInfo = x0$1;
        boolean bl = releaseInfo != null && (option = releaseInfo.startDate()) instanceof Some;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$detectUnknownReleases$6(Map responseMap$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String id = (String)tuple2._1();
        boolean bl = !BoxesRunTime.unboxToBoolean((Object)responseMap$1.getOrElse((Object)Ids.getFolderlessId((String)id), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        return bl;
    }

    public static final /* synthetic */ Try $anonfun$initArchiveExtraction$1(XlrDataExtractorService $this, XLIInstance instance$1, IngestionApi ingestionApi$1, int counter, Tuple2 releaseIdAndEndDate) {
        Try<BoxedUnit> try_;
        Tuple2 tuple2 = releaseIdAndEndDate;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String id = (String)tuple2._1();
        java.util.Date endDate = (java.util.Date)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)id, (Object)endDate);
        Tuple2 tuple23 = tuple22;
        String id2 = (String)tuple23._1();
        java.util.Date endDate2 = (java.util.Date)tuple23._2();
        Release rel = $this.xlrService().getArchiveRelease(id2);
        rel.setEndDate(endDate2);
        Try<BoxedUnit> rs = $this.sendUnKnownArtifactToIngestionApi(rel, DataSourceTypeEnum.BUILD, ingestionApi$1, instance$1);
        if (rs.isSuccess() && counter + 1 % instance$1.chunkLimit() == 0) {
            long millis = Retry$.MODULE$.getThrottlingMillis(instance$1);
            $this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Throttling applied with ", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)millis)})));
            Retry$.MODULE$.sleep(millis);
            try_ = rs;
        } else {
            try_ = rs;
        }
        return try_;
    }

    public static final /* synthetic */ boolean $anonfun$detectUnknownTemplates$4(Map responseMap$2, Release tpl) {
        return !BoxesRunTime.unboxToBoolean((Object)responseMap$2.getOrElse((Object)Converters$.MODULE$.ReleaseId(tpl).getFolderlessId(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
    }

    @Autowired
    public XlrDataExtractorService(XlrService xlrService, PluginProperties props) {
        this.xlrService = xlrService;
        this.props = props;
        this.logger = LoggerFactory.getLogger(XlrDataExtractorService.class);
        this.lock = new ReentrantLock();
        this.refreshExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService = Executors.newScheduledThreadPool(2);
        this.concurrentTaskScheduler = new ConcurrentTaskScheduler(this.executorService());
        this.knownConfigurations = new ConcurrentHashMap();
    }
}

