/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugins.xlinsight.utils;

import com.xebialabs.xlrelease.plugins.xlinsight.config.XLIInstance;
import java.io.Serializable;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Retry$ {
    public static Retry$ MODULE$;
    private final Logger logger;
    private final int MINUTE_TO_MILLIS;
    private final int SLEEP_MS_MIN;
    private final int SLEEP_MS_MAX;

    static {
        new Retry$();
    }

    public Logger logger() {
        return this.logger;
    }

    public int MINUTE_TO_MILLIS() {
        return this.MINUTE_TO_MILLIS;
    }

    public int SLEEP_MS_MIN() {
        return this.SLEEP_MS_MIN;
    }

    public int SLEEP_MS_MAX() {
        return this.SLEEP_MS_MAX;
    }

    public long getThrottlingMillis(XLIInstance xliInstance) {
        return xliInstance.throttlingMinutes() * this.MINUTE_TO_MILLIS();
    }

    public long getRetrySleepTime(int retryCounter, XLIInstance xliInstance) {
        return (long)this.MINUTE_TO_MILLIS() * RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(Math.pow(2.0, Math.min(retryCounter, xliInstance.maxNormalRetry()))));
    }

    public long calculateDelay(long latency, long previousDelay, XLIInstance instance) {
        double newDelay = (double)(previousDelay + latency) / 2.0;
        newDelay = Math.max((double)latency, newDelay);
        newDelay = Math.min(Math.max((double)this.SLEEP_MS_MIN(), newDelay), (double)this.SLEEP_MS_MAX());
        return RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(this.applyThrottleFactor(newDelay, instance)));
    }

    public void sleep(long millis) {
        block2: {
            Failure failure;
            if (Thread.currentThread().isInterrupted()) break block2;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Thread.sleep(millis));
            if (try_ instanceof Failure && (failure = (Failure)try_).exception() instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                this.logger().info("Received interruption signal");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private void tryToSleep(int retryCounter, int timeToSleep, XLIInstance xliInstance) {
        block0: {
            if (retryCounter <= 0) break block0;
            long retrySleepTime = timeToSleep == -1 ? this.getRetrySleepTime(retryCounter, xliInstance) : (long)timeToSleep;
            this.logger().info("Tried {} times. Increasing timeout exponentially to {}", (Object)BoxesRunTime.boxToInteger((int)retryCounter), (Object)BoxesRunTime.boxToLong((long)retrySleepTime));
            this.sleep(retrySleepTime);
        }
    }

    private int tryToSleep$default$2() {
        return -1;
    }

    private double applyThrottleFactor(double time, XLIInstance instance) {
        return time * instance.throttleFactor();
    }

    public <T> T executeIfNotInterrupted(T valueIfInterrupted, Function0<T> fn) {
        return (T)(!Thread.currentThread().isInterrupted() ? fn.apply() : valueIfInterrupted);
    }

    public <T> Tuple2<T, Object> executeWithDelayIfNotInterrupted(T valueIfInterrupted, long delay, Function0<T> fn, XLIInstance instance) {
        this.sleep(delay);
        Instant startDate = Instant.now();
        T result = this.executeIfNotInterrupted(valueIfInterrupted, fn);
        Instant latency = Instant.now().minusMillis(startDate.toEpochMilli());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(result), (Object)BoxesRunTime.boxToLong((long)this.calculateDelay(latency.toEpochMilli(), delay, instance)));
    }

    public final <S> Try<S> doWithRetry(int retryCounter, int timeToSleep, Function0<Try<S>> apiCall, XLIInstance instance) {
        Success success;
        block4: {
            Try<S> try_;
            Failure failure;
            boolean bl;
            while (true) {
                this.tryToSleep(retryCounter, timeToSleep, instance);
                bl = false;
                failure = null;
                try_ = this.executeIfNotInterrupted(new Failure((Throwable)new InterruptedException()), apiCall);
                if (try_ instanceof Success) {
                    Success success2 = (Success)try_;
                    Object r = success2.value();
                    success = new Success(r);
                    break block4;
                }
                if (!(try_ instanceof Failure)) break;
                bl = true;
                failure = (Failure)try_;
                Throwable e = failure.exception();
                if (retryCounter >= 16) break;
                this.logger().error(e.getMessage(), e);
                ++retryCounter;
            }
            if (bl) {
                Throwable ex = failure.exception();
                success = new Failure(ex);
            } else {
                throw new MatchError(try_);
            }
        }
        return success;
    }

    public final <S> int doWithRetry$default$1() {
        return 0;
    }

    public final <S> int doWithRetry$default$2() {
        return -1;
    }

    private Retry$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger((String)"XLI Retry engine");
        this.MINUTE_TO_MILLIS = 60000;
        this.SLEEP_MS_MIN = 5;
        this.SLEEP_MS_MAX = 10000;
    }
}

