/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlplatform.xli;

import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlplatform.xli.config.PluginProperties;
import com.xebialabs.xlrelease.security.PermissionChecker;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.net.ssl.HostnameVerifier;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.impl.client.CookieSpecRegistries;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.IgnoreSpecProvider;
import org.apache.http.impl.cookie.MyDefaultCookieSpecProvider;
import org.apache.http.impl.cookie.MyNetscapeDraftSpecProvider;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Path(value="/xli")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class XLInsightEndpoint {
    protected static final Logger logger = LoggerFactory.getLogger(XLInsightEndpoint.class);
    @Autowired
    protected PluginProperties properties;
    @Autowired
    protected PermissionChecker xlrPermissions;
    private RestTemplate restTemplate;
    private Optional<String> jwtToken = Optional.empty();

    @PostConstruct
    public void init() {
        this.restTemplate = new RestTemplate();
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        this.setupCookieHandlingForCorporateProxies(httpClientBuilder);
        if (this.properties.isAcceptSelfSignedSSLs()) {
            logger.warn("Possible security issue: accepting self-signed certificates..");
            try {
                SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
                sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)csf);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                logger.warn("Cannot setup SSL context for HTTP client: {}", (Throwable)e);
            }
        }
        if (this.properties.getProxyHost() != null && this.properties.getProxyHost() != null) {
            logger.info("Using proxy: {}:{}", (Object)this.properties.getProxyHost(), (Object)this.properties.getProxyPort());
            httpClientBuilder.setProxy(new HttpHost(this.properties.getProxyHost(), this.properties.getProxyPort().intValue()));
        }
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)httpClientBuilder.build()));
    }

    private void setupCookieHandlingForCorporateProxies(HttpClientBuilder httpClientBuilder) {
        PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.getDefault();
        RegistryBuilder registryBuilder = CookieSpecRegistries.createDefaultBuilder((PublicSuffixMatcher)publicSuffixMatcher);
        MyDefaultCookieSpecProvider provider = new MyDefaultCookieSpecProvider(publicSuffixMatcher);
        registryBuilder.register("default", (Object)provider).register("best-match", (Object)provider).register("compatibility", (Object)provider).register("standard", (Object)provider).register("standard-strict", (Object)provider).register("netscape", (Object)new MyNetscapeDraftSpecProvider()).register("ignoreCookies", (Object)new IgnoreSpecProvider());
        httpClientBuilder.setDefaultCookieSpecRegistry((Lookup)registryBuilder.build());
    }

    @GET
    @Path(value="/")
    public Response renderDashboard() {
        if (!this.properties.getUserRole().equals("user")) {
            this.xlrPermissions.check(PlatformPermissions.ADMIN);
        }
        if (!this.jwtToken.isPresent() && !this.login()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        HttpHeaders headers = this.jwtToken.map(this::createHeaders).orElse(new HttpHeaders());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity xliResponse = this.getRestTemplate().exchange(this.prepareUri(this.properties.getContextPath(), null), HttpMethod.GET, entity, byte[].class);
        if (xliResponse.getStatusCode().is2xxSuccessful()) {
            return Response.ok().type(javax.ws.rs.core.MediaType.TEXT_HTML_TYPE).entity(xliResponse.getBody()).build();
        }
        logger.error("Error getting XLI dashboard content: {} - {}", (Object)xliResponse.getStatusCode(), xliResponse.getBody());
        return Response.status((int)xliResponse.getStatusCode().value()).build();
    }

    @GET
    @Path(value="/{module:assets|api|static}/{asset:.*}")
    @Consumes(value={"*"})
    @Produces(value={"*"})
    public Response xliGetProxy() {
        return this.proxyXLICalls();
    }

    @POST
    @Path(value="/{module:assets|static}/{asset:.*}")
    @Consumes(value={"*"})
    @Produces(value={"*"})
    public Response xliPostProxy() {
        return this.proxyXLICalls();
    }

    @POST
    @Path(value="/api/{asset:.*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response xliPostJsonProxy(String body) {
        return this.proxyXLICalls(false, body);
    }

    @PUT
    @Path(value="/{module:assets|static}/{asset:.*}")
    @Consumes(value={"*"})
    @Produces(value={"*"})
    public Response xliPutProxy() {
        return this.proxyXLICalls();
    }

    @PUT
    @Path(value="/api/{asset:.*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response xliPutJsonProxy(String body) {
        return this.proxyXLICalls(false, body);
    }

    @DELETE
    @Path(value="/{module:assets|api|static}/{asset:.*}")
    @Consumes(value={"*"})
    @Produces(value={"*"})
    public Response xliDeleteProxy() {
        return this.proxyXLICalls();
    }

    @OPTIONS
    @Path(value="/{module:assets|api|static}/{asset:.*}")
    @Consumes(value={"*"})
    @Produces(value={"*"})
    public Response xliOptionsProxy() {
        return this.proxyXLICalls();
    }

    HttpServletRequest getServletRequestFromContext() {
        return (HttpServletRequest)ResteasyProviderFactory.getContextData(HttpServletRequest.class);
    }

    Response proxyXLICalls() {
        return this.proxyXLICalls(false, null);
    }

    private Response proxyXLICalls(boolean isRetry, String jsonBody) {
        HttpServletRequest incomingRequest = this.getServletRequestFromContext();
        if (!this.jwtToken.isPresent() && !this.login()) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        HttpMethod requestMethod = HttpMethod.valueOf((String)incomingRequest.getMethod());
        try {
            Function<String, HttpHeaders> createHeaders = token -> this.createHeadersFromIncomingRequest(incomingRequest, (String)token);
            HttpHeaders outgoingHeaders = this.jwtToken.map(createHeaders).orElseThrow(() -> new IllegalStateException("Empty jwtToken: " + this.jwtToken));
            HttpEntity outgoingRequest = requestMethod.equals((Object)HttpMethod.POST) || requestMethod.equals((Object)HttpMethod.PUT) ? new HttpEntity((Object)jsonBody, (MultiValueMap)outgoingHeaders) : new HttpEntity((MultiValueMap)outgoingHeaders);
            ResponseEntity bytesResponseEntity = this.getRestTemplate().exchange(this.prepareUri(incomingRequest.getRequestURI(), incomingRequest.getQueryString()), requestMethod, outgoingRequest, byte[].class);
            Map<String, String> responseHeaders = XLInsightEndpoint.mapHttpHeadersToMap(bytesResponseEntity.getHeaders());
            return XLInsightEndpoint.createResponseBuilderWithHeaders(responseHeaders, bytesResponseEntity.getStatusCodeValue()).entity(bytesResponseEntity.getBody()).build();
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode() == HttpStatus.UNAUTHORIZED && !isRetry) {
                this.jwtToken = Optional.empty();
                return this.proxyXLICalls(true, jsonBody);
            }
            return this.buildExceptionResponse((Exception)((Object)e));
        }
        catch (Exception e) {
            logger.error("Error proxying request body: {}", (Throwable)e);
            return this.buildExceptionResponse(e);
        }
    }

    private static Map<String, String> mapHttpHeadersToMap(HttpHeaders headers) {
        Collector<Map.Entry, ?, Map<String, String>> entryMapCollector = Collectors.toMap(Map.Entry::getKey, v -> ((List)v.getValue()).stream().collect(Collectors.joining(";")));
        return headers.entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("Access-Control")).collect(entryMapCollector);
    }

    private static Response.ResponseBuilder createResponseBuilderWithHeaders(Map<String, String> headersMap, int status) {
        Response.ResponseBuilder initial = Response.status((int)status);
        for (Map.Entry<String, String> entry : headersMap.entrySet()) {
            initial = initial.header(entry.getKey(), (Object)entry.getValue());
        }
        return initial;
    }

    private HttpHeaders createHeaders(String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + token);
        return headers;
    }

    private HttpHeaders createHeadersFromIncomingRequest(HttpServletRequest incomingRequest, String token) {
        HttpHeaders outgoingHeaders = this.createHeaders(token);
        Enumeration headerNames = incomingRequest.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                outgoingHeaders.set(headerName, incomingRequest.getHeader(headerName));
            }
        }
        return outgoingHeaders;
    }

    private Response buildExceptionResponse(Exception e) {
        int responseCode = e instanceof HttpClientErrorException ? ((HttpClientErrorException)((Object)e)).getStatusCode().value() : 500;
        return Response.status((int)responseCode).entity((Object)e).build();
    }

    boolean login() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        JSONObject authBody = new JSONObject();
        try {
            authBody.put("username", (Object)this.properties.getUsername());
            authBody.put("password", (Object)this.properties.getPassword());
            authBody.put("rememberMe", true);
        }
        catch (JSONException e) {
            logger.error("Error preparing XLI authentication JSON: {}", (Throwable)e);
        }
        HttpEntity request = new HttpEntity((Object)authBody.toString(), (MultiValueMap)headers);
        ResponseEntity xliResponse = this.getRestTemplate().postForEntity(this.prepareUri(this.properties.getApiPath() + "authenticate", null), (Object)request, String.class);
        try {
            JSONObject jsonBody = new JSONObject((String)xliResponse.getBody());
            if (jsonBody.has("id_token")) {
                this.jwtToken = Optional.ofNullable(jsonBody.getString("id_token")).filter(t -> !t.isEmpty());
                logger.info("Logged in to XLI. Token={}", this.jwtToken);
                return this.jwtToken.isPresent();
            }
            logger.error("Could not login XLR XLI user! Cause: {}", (Object)jsonBody);
        }
        catch (JSONException e) {
            logger.error("Error parsing XLI API JSON body: {}", (Throwable)e);
        }
        return false;
    }

    URI prepareUri(String path, String query) {
        try {
            return new URI(this.properties.getScheme(), null, this.properties.getHost(), this.properties.getPort(), path, query, null);
        }
        catch (URISyntaxException e) {
            logger.error("Error forming XLI URI: {}", (Throwable)e);
            throw new IllegalStateException("Error forming XLI URI for path: " + path + " query:" + query);
        }
    }

    Optional<String> getJwtToken() {
        return this.jwtToken;
    }

    RestTemplate getRestTemplate() {
        return this.restTemplate;
    }
}

