/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicCommentHandler;
import org.apache.http.impl.cookie.BasicExpiresHandler;
import org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.DefaultCookieSpec;
import org.apache.http.impl.cookie.DefaultCookieSpecProvider;
import org.apache.http.impl.cookie.NetscapeDraftSpec;
import org.apache.http.impl.cookie.RFC2109Spec;
import org.apache.http.impl.cookie.RFC2109VersionHandler;
import org.apache.http.impl.cookie.RFC2965CommentUrlAttributeHandler;
import org.apache.http.impl.cookie.RFC2965DiscardAttributeHandler;
import org.apache.http.impl.cookie.RFC2965PortAttributeHandler;
import org.apache.http.impl.cookie.RFC2965Spec;
import org.apache.http.impl.cookie.RFC2965VersionAttributeHandler;
import org.apache.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class MyDefaultCookieSpecProvider
extends DefaultCookieSpecProvider {
    private final DefaultCookieSpecProvider.CompatibilityLevel compatibilityLevel;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private final String[] datepatterns;
    private final boolean oneHeader;
    private volatile CookieSpec cookieSpec;

    public MyDefaultCookieSpecProvider(DefaultCookieSpecProvider.CompatibilityLevel compatibilityLevel, PublicSuffixMatcher publicSuffixMatcher, String[] datepatterns, boolean oneHeader) {
        this.compatibilityLevel = compatibilityLevel != null ? compatibilityLevel : DefaultCookieSpecProvider.CompatibilityLevel.DEFAULT;
        this.publicSuffixMatcher = publicSuffixMatcher;
        this.datepatterns = datepatterns;
        this.oneHeader = oneHeader;
    }

    public MyDefaultCookieSpecProvider(DefaultCookieSpecProvider.CompatibilityLevel compatibilityLevel, PublicSuffixMatcher publicSuffixMatcher) {
        this(compatibilityLevel, publicSuffixMatcher, null, false);
    }

    public MyDefaultCookieSpecProvider(PublicSuffixMatcher publicSuffixMatcher) {
        this(DefaultCookieSpecProvider.CompatibilityLevel.DEFAULT, publicSuffixMatcher, null, false);
    }

    public MyDefaultCookieSpecProvider() {
        this(DefaultCookieSpecProvider.CompatibilityLevel.DEFAULT, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CookieSpec create(HttpContext context) {
        if (this.cookieSpec == null) {
            MyDefaultCookieSpecProvider myDefaultCookieSpecProvider = this;
            synchronized (myDefaultCookieSpecProvider) {
                if (this.cookieSpec == null) {
                    String[] stringArray;
                    RFC2965Spec strict = new RFC2965Spec(this.oneHeader, new CommonCookieAttributeHandler[]{new RFC2965VersionAttributeHandler(), new BasicPathHandler(), new RFC2965PortAttributeHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new RFC2965CommentUrlAttributeHandler(), new RFC2965DiscardAttributeHandler()});
                    RFC2109Spec obsoleteStrict = new RFC2109Spec(this.oneHeader, new CommonCookieAttributeHandler[]{new RFC2109VersionHandler(), new BasicPathHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler()});
                    CommonCookieAttributeHandler[] commonCookieAttributeHandlerArray = new CommonCookieAttributeHandler[4];
                    commonCookieAttributeHandlerArray[0] = this.compatibilityLevel == DefaultCookieSpecProvider.CompatibilityLevel.IE_MEDIUM_SECURITY ? new BasicPathHandler(){

                        public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                        }
                    } : new BasicPathHandler();
                    commonCookieAttributeHandlerArray[1] = new BasicSecureHandler();
                    commonCookieAttributeHandlerArray[2] = new BasicCommentHandler();
                    if (this.datepatterns != null) {
                        stringArray = (String[])this.datepatterns.clone();
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "EEE, dd-MMM-yy HH:mm:ss z";
                    }
                    commonCookieAttributeHandlerArray[3] = new BasicExpiresHandler(stringArray);
                    NetscapeDraftSpec netscapeDraft = new NetscapeDraftSpec(commonCookieAttributeHandlerArray);
                    this.cookieSpec = new DefaultCookieSpec(strict, obsoleteStrict, netscapeDraft);
                }
            }
        }
        return this.cookieSpec;
    }
}

