/* eslint-disable object-shorthand */
'use strict';

(function () {

    const TestTileDefaultConfigController = function ($scope, GetDataService) {
        const vm = this;
        const xlrTile = $scope.xlrTile;

        vm.data = 'Refresh me';
        vm.refresh = refresh;

        function refresh() {
            vm.loading = true;
            GetDataService.executeQuery(xlrTile.tile.id).then(function (response) {
                vm.data = response.data.data;
            }).finally(function () {
                vm.loading = false;
            });
        }

        refresh();
    };

    TestTileDefaultConfigController.$inject = ['$scope', 'GetDataService'];

    const GetDataService = function (Backend) {

        function executeQuery(tileId) {
            return Backend.get("tiles/" + tileId + "/data");
        }

        return {
            executeQuery: executeQuery
        };
    };

    GetDataService.$inject = ['Backend'];

    angular.module('xlrelease.test.defaultconfig.tile', []);
    angular.module('xlrelease.test.defaultconfig.tile').service('GetDataService', GetDataService);
    angular.module('xlrelease.test.defaultconfig.tile').controller('DefaultController', TestTileDefaultConfigController);

})();
