'use strict';

(function () {
    const injectParams = ['ReleasesService', '$stateParams'];

    function TasksListPageController(ReleasesService, $stateParams) {
        const vm = this;

        vm.refresh = loadRelease;
        loadRelease();

        ///

        function loadRelease() {
            ReleasesService.getRelease($stateParams.releaseId).then(function (resp) {
                const release = resp.data;
                vm.tasks = ReleasesService.getAllTasks(release);
                vm.numberOfTasksTitlePart = vm.tasks.length;
                vm.release = release;
                vm.refreshedDate = new Date();
            });
        }
    }

    TasksListPageController.$inject = injectParams;

    angular.module('xlrelease').controller('test.tasksListPageController', TasksListPageController);
})();
