import json

from xlrelease.HttpRequest import HttpRequest

if accessToken is not None and accessToken.strip() == "":
    accessToken = None

url = "/repos/%s/commits?sha=%s" % \
      (repositoryId, branch)

print "Querying commits from GitHub API by URL %s" % url

request = HttpRequest({"url": "https://api.github.com"})
requestHeaders = {}
if accessToken:
    requestHeaders = {'Authorization': 'token %s' % accessToken}

response = request.get(url, contentType='application/json', headers = requestHeaders)

if response.status != 200:
    raise Exception("Request to GitHub failed with status %s, response %s" % (response.status, response.response))

commits = json.loads(response.response)

data = {
    "tile_configuration": {
        "repositoryId": repositoryId,
        "branch": branch
    },
    "commits": commits
}
