package com.xebialabs.xlrelease.assertions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

import com.xebialabs.xlrelease.domain.Variable;

import static com.xebialabs.xlrelease.domain.Variable.VariableType;

public class VariableAssertion extends AbstractAssert<VariableAssertion, Variable> {

    protected VariableAssertion(Variable actual) {
        super(actual, VariableAssertion.class);
    }

    public VariableAssertion hasValue(String value) {
        isNotNull();
        Assertions.assertThat(actual.getValue()).isEqualTo(value);
        return this;
    }

    public VariableAssertion hasPassword(String value) {
        isNotNull();
        Assertions.assertThat(actual.getPassword()).isEqualTo(value);
        return this;
    }

    public VariableAssertion hasNoValue() {
        isNotNull();
        Assertions.assertThat(actual.getValue()).isNull();
        return this;
    }

    public VariableAssertion hasKey(String key) {
        isNotNull();
        Assertions.assertThat(actual.getKey()).isEqualTo(key);
        return this;
    }

    public VariableAssertion hasType(VariableType type) {
        isNotNull();
        Assertions.assertThat(actual.getType()).isEqualTo(type);
        return this;
    }
}
