/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.google.common.base.Throwables;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.plumbing.XLReleaseTest;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.TestIds;
import com.xebialabs.xlrelease.XLReleaseIntegrationTestConfig;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.repository.ActivityLogs;
import com.xebialabs.xlrelease.rules.JcrTestInDirectoryRule;
import com.xebialabs.xlrelease.rules.JcrTestRule;
import com.xebialabs.xlrelease.rules.LoginRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestContextManager;

@RunWith(value=JUnit4.class)
@ContextConfiguration(locations={"/spring/xlrelease-context-test.xml"})
public abstract class XLReleaseIntegrationTest
extends XLReleaseTest {
    protected static JcrTestRule jcrTestRule = new JcrTestRule();
    @Autowired
    private ArchivedReleases archivedReleases;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private PermissionEditor permissionEditor;
    @Autowired
    private RoleService roleService;
    @Rule
    public JcrTestInDirectoryRule directory;

    public XLReleaseIntegrationTest() {
        this(false);
    }

    public XLReleaseIntegrationTest(boolean useCache) {
        this.directory = JcrTestInDirectoryRule.newDirectory(TestIds.RELEASES_DIR, jcrTestRule.getRepositoryService(), useCache);
    }

    @Before
    public void before() {
        try {
            new TestContextManager(this.getClass()).prepareTestInstance((Object)this);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        new JcrTemplateHolder(jcrTestRule.getJcrTemplate());
        this.archivedReleases.init();
        LoginRule.grantAdminPermissionTo("admin", this.permissionEditor, this.roleService);
    }

    @After
    public void deleteLogsDirectory() {
        if (this.repositoryService.exists(ActivityLogs.ACTIVITY_LOGS_DIR)) {
            this.repositoryService.delete(new String[]{ActivityLogs.ACTIVITY_LOGS_DIR});
        }
    }

    static {
        try {
            jcrTestRule.before();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        XLReleaseIntegrationTestConfig.init(jcrTestRule);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                jcrTestRule.after();
            }
        });
    }
}

