/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.assertions;

import com.xebialabs.xlrelease.assertions.XLReleaseAssertions;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.repository.ActivityLogs;
import com.xebialabs.xlrelease.user.User;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class ActivityLogAssertion
extends AbstractAssert<ActivityLogAssertion, ActivityLogs> {
    protected ActivityLogAssertion(ActivityLogs actual) {
        super((Object)actual, ActivityLogAssertion.class);
    }

    public ActivityLogAssertion logCreated(String activityType) {
        this.isNotNull();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ActivityLogEntry.class);
        ((ActivityLogs)Mockito.verify((Object)this.actual)).log(Matchers.anyString(), (ActivityLogEntry)captor.capture());
        XLReleaseAssertions.assertThat((ActivityLogEntry)captor.getValue()).hasActivityType(activityType);
        XLReleaseAssertions.assertThat((ActivityLogEntry)captor.getValue()).hasMessage();
        return this;
    }

    public ActivityLogAssertion logsCreated(String ... activityTypes) {
        this.isNotNull();
        ArgumentCaptor captor = ArgumentCaptor.forClass(List.class);
        ((ActivityLogs)Mockito.verify((Object)this.actual)).log(Matchers.anyString(), (List)captor.capture(), (User)Matchers.eq((Object)User.AUTHENTICATED_USER));
        List logs = (List)captor.getValue();
        ActivityLogAssertion.verifyLogsWithStatuses(logs, activityTypes);
        return this;
    }

    public static void verifyLogsWithStatuses(List<ActivityLogEntry> activityLogEntries, String ... activityTypes) {
        XLReleaseAssertions.assertThat(activityLogEntries).extracting("activityType").contains((Object[])activityTypes);
        XLReleaseAssertions.assertThat(activityLogEntries).hasSize(activityTypes.length);
        XLReleaseAssertions.assertThat(activityLogEntries).extracting("message").isNotNull();
    }
}

