/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.rules;

import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.plumbing.JackrabbitRepositoryBooter;
import com.xebialabs.deployit.repository.JcrRepositoryService;
import com.xebialabs.deployit.repository.RepositoryMetadataService;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.license.service.LicenseServiceImpl;
import com.xebialabs.xlplatform.repository.JcrRepositoryMetadataService;
import com.xebialabs.xlrelease.config.XlrConfig;
import java.security.Provider;
import java.security.Security;
import javax.crypto.SecretKey;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.rules.ExternalResource;

public class JcrTestRule
extends ExternalResource {
    private JcrTemplate jcrTemplate;
    private JcrRepositoryService repositoryService;
    private JackrabbitRepositoryBooter booter;

    public void before() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        PasswordEncrypter.init((SecretKey)DeployitKeys.DEFAULT_PASSWORD_ENCRYPTION_KEY);
        this.booter = new JackrabbitRepositoryBooter();
        Repository repo = this.booter.boot();
        this.jcrTemplate = new JcrTemplate(repo, (Credentials)this.booter.getXlConfig().credentials().get());
        new JcrTemplateHolder(this.jcrTemplate);
        JcrRepositoryMetadataService repositoryMetadataService = new JcrRepositoryMetadataService(this.jcrTemplate);
        LicenseServiceImpl licenseService = new LicenseServiceImpl(XlrConfig.license_location(), "XL Release", (RepositoryMetadataService)repositoryMetadataService);
        this.repositoryService = new JcrRepositoryService(this.jcrTemplate, PasswordEncrypter.getInstance(), (LicenseService)licenseService);
        licenseService.initialize((RepositoryService)this.repositoryService);
    }

    public void after() {
        this.booter.shutdown();
    }

    public JcrTemplate getJcrTemplate() {
        return this.jcrTemplate;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }
}

