/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.platform.script.jython.JythonException;
import com.xebialabs.platform.script.jython.ThreadLocalWriterDecorator;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.script.ScriptLifeCycle;
import com.xebialabs.xlrelease.script.ScriptService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SynchronousScriptService {
    private ScriptService scriptService;
    private ScriptLifeCycle scriptLifeCycle;

    @Autowired
    public SynchronousScriptService(ScriptService scriptService, ScriptLifeCycle scriptLifeCycle) {
        this.scriptService = scriptService;
        this.scriptLifeCycle = scriptLifeCycle;
    }

    public SynchronousScriptService() {
    }

    public String executeScriptTask(ScriptTask task) throws JythonException {
        ScriptContext scriptContext = this.scriptService.prepareScriptTaskContext(task, this.scriptService.getExecutionLog());
        return this.executeScriptSynchronously(task.getScript(), scriptContext, (Task)task, true);
    }

    public String executeCustomScriptTask(CustomScriptTask task) throws JythonException {
        try {
            String script = task.getPythonScript().getScript();
            return this.executeCustomScriptTask(task, script);
        }
        catch (IOException e) {
            throw new JythonException(String.format("Error while loading script on task '%s'", task.getId()), (Exception)e);
        }
    }

    @VisibleForTesting
    String executeCustomScriptTask(CustomScriptTask task, String scriptContent) throws JythonException {
        ScriptContext scriptContext = this.scriptService.prepareCustomScriptTaskContext(task, this.scriptService.getExecutionLog());
        String output = this.executeScriptSynchronously(scriptContent, scriptContext, (Task)task, false);
        this.saveOutputPropertiesInMemory(task, scriptContext);
        return output;
    }

    public boolean executePrecondition(Task task) throws JythonException {
        this.scriptLifeCycle.register(task.getExecutionId());
        StringWriter stringWriter = new StringWriter();
        this.scriptService.getExecutionLog().registerWriter((Writer)new PrintWriter(stringWriter));
        String script = task.getPrecondition();
        try {
            ScriptContext scriptContext = this.scriptService.preparePreconditionContext(task, this.scriptService.getExecutionLog());
            Object statementResult = this.scriptService.executeScript(script, scriptContext, task, true);
            Object resultVariable = scriptContext.getAttribute("result");
            if (statementResult == null && resultVariable == null) {
                throw new JythonException("Precondition did not return anything", null);
            }
            boolean bl = this.isTrue(statementResult) || this.isTrue(resultVariable);
            return bl;
        }
        catch (Exception exception) {
            this.closeQuietly(this.scriptService.getExecutionLog());
            throw new JythonException("Error while running script, the output so far:\n" + stringWriter.toString(), exception);
        }
        finally {
            this.closeQuietly(this.scriptService.getExecutionLog());
            this.scriptLifeCycle.unregister(task.getExecutionId());
        }
    }

    public String executeTrigger(ReleaseTrigger releaseTrigger) throws JythonException {
        StringWriter stringWriter = new StringWriter();
        this.scriptService.getExecutionLog().registerWriter((Writer)new PrintWriter(stringWriter));
        try {
            ScriptContext context = this.scriptService.makeScriptContext(releaseTrigger);
            this.scriptService.executeScript(releaseTrigger.getScript(), context);
            this.scriptService.setPropertiesFromScriptContext(context, releaseTrigger);
        }
        catch (Exception e) {
            throw new JythonException("Error during trigger execution, the output so far:\n" + stringWriter.toString(), e);
        }
        finally {
            this.closeQuietly(this.scriptService.getExecutionLog());
        }
        return stringWriter.toString();
    }

    private String executeScriptSynchronously(String script, ScriptContext scriptContext, Task task, boolean checkPolicyPermissions) throws JythonException {
        this.scriptLifeCycle.register(task.getExecutionId());
        StringWriter stringWriter = new StringWriter();
        this.scriptService.getExecutionLog().registerWriter((Writer)new PrintWriter(stringWriter));
        try {
            this.scriptService.executeScript(script, scriptContext, task, checkPolicyPermissions);
        }
        catch (ScriptException exception) {
            if (!this.scriptService.isSystemExit0(exception)) {
                this.closeQuietly(this.scriptService.getExecutionLog());
                throw new JythonException("Error while running script, the output so far:\n" + stringWriter.toString(), (Exception)exception);
            }
        }
        catch (Exception exception) {
            this.closeQuietly(this.scriptService.getExecutionLog());
            throw new JythonException("Error while running script, the output so far:\n" + stringWriter.toString(), exception);
        }
        finally {
            this.closeQuietly(this.scriptService.getExecutionLog());
            this.scriptLifeCycle.unregister(task.getExecutionId());
        }
        return stringWriter.toString();
    }

    private void saveOutputPropertiesInMemory(CustomScriptTask task, ScriptContext scriptContext) {
        Collection outputProperties = task.getPythonScript().getOutputProperties();
        for (PropertyDescriptor propertyDescriptor : outputProperties) {
            String propertyName = propertyDescriptor.getName();
            Object attr = scriptContext.getAttribute(propertyName);
            if (attr == null) continue;
            task.getPythonScript().setProperty(propertyName, (Object)attr.toString());
        }
    }

    private void closeQuietly(ThreadLocalWriterDecorator log) {
        try {
            log.getWriter().close();
        }
        catch (IOException exception) {
            Throwables.propagate((Throwable)exception);
        }
    }

    private boolean isTrue(Object preconditionResult) {
        return preconditionResult instanceof Boolean && (Boolean)preconditionResult != false;
    }
}

