package com.xebialabs.xlrelease.assertions;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.mockito.ArgumentCaptor;

import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.repository.ActivityLogs;
import com.xebialabs.xlrelease.user.User;

import static com.xebialabs.xlrelease.assertions.XLReleaseAssertions.assertThat;
import static com.xebialabs.xlrelease.user.User.AUTHENTICATED_USER;
import static org.mockito.Matchers.anyString;
import static org.mockito.Matchers.eq;
import static org.mockito.Mockito.verify;

public class ActivityLogAssertion extends AbstractAssert<ActivityLogAssertion, ActivityLogs> {

    protected ActivityLogAssertion(ActivityLogs actual) {
        super(actual, ActivityLogAssertion.class);
    }

    public ActivityLogAssertion logCreated(String activityType) {
        return logCreated(activityType, null);
    }

    public ActivityLogAssertion logCreated(String activityType, String message) {
        isNotNull();

        ArgumentCaptor<ActivityLogEntry> captor = ArgumentCaptor.forClass(ActivityLogEntry.class);
        verify(actual).log(anyString(), captor.capture());
        assertThat(captor.getValue()).hasActivityType(activityType);
        assertThat(captor.getValue()).hasMessage();
        if (message != null) {
            assertThat(captor.getValue().getMessage()).isEqualTo(message);
        }

        return this;
    }

    public ActivityLogAssertion logsCreated(String... activityTypes) {
        return logsCreated(AUTHENTICATED_USER, activityTypes);
    }

    public ActivityLogAssertion logsCreated(User user, String... activityTypes) {
        return logsCreated(user, Arrays.asList(activityTypes), null);
    }

    @SuppressWarnings("unchecked")
    public ActivityLogAssertion logsCreated(User user, List<String> activityTypes, List<String> messages) {
        isNotNull();

        ArgumentCaptor<List> captor = ArgumentCaptor.forClass(List.class);
        if (null == user) {
            verify(actual).log(anyString(), captor.capture());
        } else {
            verify(actual).log(anyString(), captor.capture(), eq(user));
        }
        List<?> logs = captor.getValue();
        verifyLogsWithStatuses((List<ActivityLogEntry>) logs, activityTypes, messages);

        return this;
    }

    public static void verifyLogsWithStatuses(List<ActivityLogEntry> activityLogEntries, String... activityTypes) {
        verifyLogsWithStatuses(activityLogEntries, Arrays.asList(activityTypes), null);
    }

    public static void verifyLogsWithStatuses(List<ActivityLogEntry> activityLogEntries,
                                              List<String> activityTypes, List<String> messages) {
        assertThat(activityLogEntries).extracting("activityType").containsAll(activityTypes);
        if (messages != null) {
            assertThat(activityLogEntries).extracting("message").containsAll(messages);
        } else {
            assertThat(activityLogEntries).extracting("message").isNotNull();
        }
        assertThat(activityLogEntries).hasSize(activityTypes.size());
    }
}
