package com.xebialabs.xlrelease.assertions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

import com.xebialabs.xlrelease.domain.Team;

public class TeamAssertion extends AbstractAssert<TeamAssertion, Team> {

    protected TeamAssertion(Team actual) {
        super(actual, TeamAssertion.class);
    }

    public TeamAssertion hasPermissions(String... permissionNames) {
        isNotNull();
        Assertions.assertThat(actual.getPermissions()).containsOnly(permissionNames);
        return this;
    }

    public TeamAssertion hasNoPermissions() {
        isNotNull();
        Assertions.assertThat(actual.getPermissions()).isEmpty();
        return this;
    }
}
