package com.xebialabs.xlrelease.service;

import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.upgrade.RepositoryInitializer;
import com.xebialabs.xlrelease.actors.ActorsInitializer;
import com.xebialabs.xlrelease.api.XLReleaseServiceHolder;
import com.xebialabs.xlrelease.api.v1.*;
import com.xebialabs.xlrelease.upgrade.jcr.XLReleaseUpgrader;

public class TestServiceStarter {
    private XLReleaseUpgrader upgrader;
    private RepositoryInitializer repositoryInitializer;
    private TaskApi taskApi;
    private RepositoryService repositoryService;
    private PhaseApi phaseApi;
    private ReleaseApi releaseApi;
    private TemplateApi templateApi;
    private ConfigurationApi configurationApi;
    private ActorsInitializer actorsInitializer;

    @Autowired
    public TestServiceStarter(XLReleaseUpgrader upgrader, RepositoryInitializer repositoryInitializer,
                              RepositoryService repositoryService, TaskApi taskApi,
                              PhaseApi phaseApi, ReleaseApi releaseApi, TemplateApi templateApi,
                              ConfigurationApi configurationApi, final ActorsInitializer actorsInitializer) {
        this.upgrader = upgrader;
        this.repositoryInitializer = repositoryInitializer;
        this.taskApi = taskApi;
        this.repositoryService = repositoryService;
        this.phaseApi = phaseApi;
        this.releaseApi = releaseApi;
        this.templateApi = templateApi;
        this.configurationApi = configurationApi;
        this.actorsInitializer = actorsInitializer;
    }

    @PostConstruct
    public void startServices() {
        XLReleaseServiceHolder.init(taskApi, phaseApi, releaseApi, templateApi, configurationApi, repositoryService);
        repositoryInitializer.initializeComponents();
        upgrader.autoUpgrade();
        actorsInitializer.initialize();
    }

}
