package com.xebialabs.xlrelease.rules;

import com.xebialabs.deployit.repository.NodeReaderContext;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.xlrelease.upgrade.jcr.XLRelease470InitializeDirectories;
import org.junit.rules.ExternalResource;

public class JcrTestInDirectoryRule extends ExternalResource {

    private String directoryId;
    private RepositoryService repositoryService;
    private boolean useCache;

    public JcrTestInDirectoryRule(String directoryId, RepositoryService repositoryService, boolean useCache) {
        this.directoryId = directoryId;
        this.repositoryService = repositoryService;
        this.useCache = useCache;
    }

    public static JcrTestInDirectoryRule newDirectory(String directoryId, RepositoryService repositoryService) {
        return newDirectory(directoryId, repositoryService, true);
    }

    public static JcrTestInDirectoryRule newDirectory(String directoryId, RepositoryService repositoryService, boolean useCache) {
        return new JcrTestInDirectoryRule(directoryId, repositoryService, useCache);
    }

    public void before() throws Exception {
        createAllDirectories();
        if (useCache) {
            NodeReaderContext.get().hold();
        }
    }

    @Override
    public void after() {
        if (useCache) {
            NodeReaderContext.get().release();
        }
        removeDirectory();
    }

    private void createAllDirectories() {
        createCurrentDirectory();
        new XLRelease470InitializeDirectories(repositoryService).doUpgrade(null);
    }

    private void createCurrentDirectory() {
        if (!repositoryService.exists(directoryId)) {
            Directory directory = new Directory();
            directory.setId(directoryId);
            repositoryService.create(directory);
        }
    }

    private void removeDirectory() {
        repositoryService.delete(directoryId);
    }
}
