package com.xebialabs.xlrelease.script

import java.util.{Map => JMap}

import akka.actor.ActorSystem
import akka.pattern.ask
import com.xebialabs.platform.script.jython.ScriptSource
import com.xebialabs.xlplatform.endpoints.AuthenticatedData
import com.xebialabs.xlplatform.endpoints.actors.{JythonScriptExecutorActor, RunScript, ScriptDone}
import com.xebialabs.xlplatform.endpoints.json.ScriptRequest
import com.xebialabs.xlplatform.settings.XlPlatformSettings
import com.xebialabs.xlrelease.config.XlrConfig
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import spray.json.{JsNull, JsValue, JsonParser}

import scala.collection.JavaConversions._
import scala.concurrent.Await

@Component
class EndpointJythonScriptTestExecutor @Autowired()(xlrConfig: XlrConfig) {

  private implicit val system = ActorSystem("extension-test-system")
  private def jythonScriptExecutor = system.actorOf(JythonScriptExecutorActor.props())
  private val settings = new XlPlatformSettings(xlrConfig.rootConfig)

  def executeEndpointScript(scriptLocation: String, query: JMap[String, AnyRef], jsonEntity: String, user: String): ScriptDone = {
    val jsValue: JsValue = Option(jsonEntity).map(s => JsonParser(s)).getOrElse(JsNull)
    val request = ScriptRequest(Option(query).map(_.toMap).getOrElse(Map.empty), jsValue)

    implicit val timeout = settings.ServerExtension.timeout
    val future = jythonScriptExecutor ? RunScript(ScriptSource.byResource(scriptLocation), request, AuthenticatedData(user))
    Await.result(future, timeout.duration).asInstanceOf[ScriptDone]
  }

}
