/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.assertions;

import com.xebialabs.xlrelease.assertions.PlanItemAssertion;
import com.xebialabs.xlrelease.assertions.XLReleaseAssertions;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseTrigger;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.MapEntry;

public class ReleaseAssertion
extends PlanItemAssertion<ReleaseAssertion, Release> {
    protected ReleaseAssertion(Release actual) {
        super(actual, ReleaseAssertion.class);
    }

    public ReleaseAssertion hasStatus(ReleaseStatus status) {
        this.isNotNull();
        Assertions.assertThat((Object)((Release)this.actual).getStatus()).isEqualTo((Object)status);
        return this;
    }

    public ReleaseAssertion isCompleted() {
        ((ReleaseAssertion)this.isNotNull()).hasStatus(ReleaseStatus.COMPLETED).hasEndDate().hasFlagStatus(FlagStatus.OK).hasFlagComment("");
        return this;
    }

    public ReleaseAssertion isInProgress() {
        ((ReleaseAssertion)this.isNotNull()).hasStatus(ReleaseStatus.IN_PROGRESS).hasNoEndDate();
        return this;
    }

    public ReleaseAssertion isFailing() {
        ((ReleaseAssertion)this.isNotNull()).hasStatus(ReleaseStatus.FAILING);
        return this;
    }

    public ReleaseAssertion isFailed() {
        ((ReleaseAssertion)this.isNotNull()).hasStatus(ReleaseStatus.FAILED);
        return this;
    }

    public ReleaseAssertion isAborted() {
        ((ReleaseAssertion)this.isNotNull()).hasStatus(ReleaseStatus.ABORTED);
        return this;
    }

    @Override
    public ReleaseAssertion hasOwner(String owner) {
        this.isNotNull();
        Assertions.assertThat((String)((Release)this.actual).getOwner()).isEqualTo((Object)owner);
        return this;
    }

    public ReleaseAssertion hasDescription(String description) {
        this.isNotNull();
        Assertions.assertThat((String)((Release)this.actual).getDescription()).isEqualTo((Object)description);
        return this;
    }

    public ReleaseAssertion hasTitle(String title) {
        this.isNotNull();
        Assertions.assertThat((String)((Release)this.actual).getTitle()).isEqualTo((Object)title);
        return this;
    }

    public ReleaseAssertion containsVariables(Variable ... variables) {
        this.isNotNull();
        MapEntry[] entries = new MapEntry[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            Variable variable = variables[i];
            entries[i] = MapEntry.entry((Object)VariableHelper.withVariableSyntax((String)variable.getKey()), (Object)variable.getValue());
        }
        Assertions.assertThat((Map)((Release)this.actual).getVariableValues()).contains(entries);
        return this;
    }

    public ReleaseAssertion hasTags(String ... tags) {
        this.isNotNull();
        Assertions.assertThat((List)((Release)this.actual).getTags()).containsExactly((Object[])tags);
        return this;
    }

    public ReleaseAssertion hasPrivateCalendar() {
        this.isNotNull();
        Assertions.assertThat((String)((Release)this.actual).getCalendarLinkToken()).isNotEmpty();
        Assertions.assertThat((boolean)((Release)this.actual).isCalendarPublished()).isFalse();
        return this;
    }

    public PlanItemAssertion hasAbortOnFailure(boolean abortOnFailure) {
        this.isNotNull();
        Assertions.assertThat((boolean)((Release)this.actual).isAbortOnFailure()).isEqualTo(abortOnFailure);
        return this;
    }

    public PlanItemAssertion hasAllowConcurrentReleasesFromTrigger(boolean allowConcurrentReleaseFromTrigger) {
        this.isNotNull();
        Assertions.assertThat((boolean)((Release)this.actual).isAllowConcurrentReleasesFromTrigger()).isEqualTo(allowConcurrentReleaseFromTrigger);
        return this;
    }

    public ReleaseAssertion hasOriginTemplateId(String originTemplateId) {
        this.isNotNull();
        Assertions.assertThat((String)((Release)this.actual).getOriginTemplateId()).isEqualTo((Object)originTemplateId);
        return this;
    }

    public ReleaseAssertion hasRunningTriggeredReleasesCount(int runningTriggeredReleasesCount) {
        this.isNotNull();
        Assertions.assertThat((int)((Release)this.actual).getRunningTriggeredReleasesCount()).isEqualTo(runningTriggeredReleasesCount);
        return this;
    }

    public ReleaseAssertion hasOnlyDisabledTriggers() {
        this.isNotNull();
        for (ReleaseTrigger releaseTrigger : ((Release)this.actual).getReleaseTriggers()) {
            XLReleaseAssertions.assertThat(releaseTrigger).hasNoExecutionId();
            XLReleaseAssertions.assertThat(releaseTrigger).isDisabled();
        }
        return this;
    }

    public ReleaseAssertion hasRealFlagStatus(FlagStatus releaseFlagStatus) {
        this.isNotNull();
        Assertions.assertThat((Object)((Release)this.actual).getRealFlagStatus()).isEqualTo((Object)releaseFlagStatus);
        return this;
    }

    public ReleaseAssertion hasScriptUsername(String scriptUserName) {
        this.isNotNull();
        Assertions.assertThat((String)((Release)this.actual).getScriptUsername()).isEqualTo((Object)scriptUserName);
        return this;
    }

    public ReleaseAssertion hasScriptUserPassword(String scriptUserPassword) {
        this.isNotNull();
        Assertions.assertThat((String)((Release)this.actual).getScriptUserPassword()).isEqualTo((Object)scriptUserPassword);
        return this;
    }

    public ReleaseAssertion containsOnlyMemberViewers(String ... members) {
        this.isNotNull();
        Assertions.assertThat((List)((Release)this.actual).getMemberViewers()).containsOnly((Object[])members);
        return this;
    }

    public ReleaseAssertion containsOnlyRoleViewers(String ... roles) {
        this.isNotNull();
        Assertions.assertThat((List)((Release)this.actual).getRoleViewers()).containsOnly((Object[])roles);
        return this;
    }
}

