package com.xebialabs.xlrelease.assertions;

import org.assertj.core.api.Assertions;

import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.Phase;

import static com.xebialabs.xlrelease.domain.status.PhaseStatus.ABORTED;
import static com.xebialabs.xlrelease.domain.status.PhaseStatus.COMPLETED;
import static com.xebialabs.xlrelease.domain.status.PhaseStatus.FAILED;
import static com.xebialabs.xlrelease.domain.status.PhaseStatus.FAILING;
import static com.xebialabs.xlrelease.domain.status.PhaseStatus.IN_PROGRESS;
import static com.xebialabs.xlrelease.domain.status.PhaseStatus.PLANNED;

public class PhaseAssertion extends PlanItemAssertion<PhaseAssertion, Phase> {

    protected PhaseAssertion(Phase actual) {
        super(actual, PhaseAssertion.class);
    }

    public PhaseAssertion hasStatus(PhaseStatus status) {
        isNotNull();
        Assertions.assertThat(actual.getStatus()).isEqualTo(status);
        return this;
    }

    public PhaseAssertion isCompleted() {
        isNotNull().hasStatus(COMPLETED);
        hasEndDate();
        return this;
    }

    public PhaseAssertion isInProgress() {
        isNotNull().hasStatus(IN_PROGRESS).hasNoEndDate();
        return this;
    }

    public PhaseAssertion isFailed() {
        isNotNull().hasStatus(FAILED);
        return this;
    }

    public PhaseAssertion isAborted() {
        isNotNull().hasStatus(ABORTED);
        return this;
    }

    public PhaseAssertion isPlanned() {
        isNotNull().hasStatus(PLANNED);
        return this;
    }

    public PhaseAssertion isFailing() {
        isNotNull().hasStatus(FAILING);
        return this;
    }
}
