package com.xebialabs.xlrelease.rules;

import com.xebialabs.deployit.repository.WorkDirContext;
import org.junit.rules.ExternalResource;
import com.xebialabs.deployit.repository.WorkDirFactory;

public class WorkDirRule extends ExternalResource {

    public void before() throws Throwable {
        WorkDirFactory workDirFactory = new WorkDirFactory(System.getProperty("java.io.tmpdir"));
        new WorkDirContext(workDirFactory);
        WorkDirContext.initWorkdir();
    }

    public void after() {
        if (WorkDirContext.get() != null) {
            WorkDirContext.get().delete();
            WorkDirContext.clear();
        }
    }
}
